
#ifndef __CTKMAIN_H__
# define __CTKMAIN_H__

#include <arr.h>

gint ctk_init_mouse();
gint ctk_close_mouse();
gint ctk_main();
gint ctk_close();
gint ctk_init(gint initmask);

#define CTK_NULL	0
#define CTK_USEMOUSE	1
#define CTK_CLEANDRAW	2

struct ctk_info_s {
	GMainLoop *main_loop;
	GSList *fds;
	gboolean running;
};

struct CtkClipboard_S {
	gchar *text;
	guint text_len;
};

extern struct CtkClipboard_S CtkClipboard;

extern GNode **focus_stack;
extern GSList *ctk_main_loops;
void ctk_main_quit(void);
void ctk_exit(gint errorcode);
gchar *ctk_set_locale(void);
CtkWidget *ctk_main_check_object_loc(CtkWidget *widget, gint row, gint col);

void ctk_main_garbage_add(CtkWidget *widget);
gint ctk_main_mouse_remove_stale_global(CtkObject* object);

extern gboolean ctk_mouse_draw;
extern gint ctk_mouse_x;
extern gint ctk_mouse_y;
extern gint ctk_mouse_dx;
extern gint ctk_mouse_dy;
extern gint ctk_scr_r;
extern gint ctk_scr_c;
extern gint ctk_keyval;

extern GSList *ctk_garbage_queue;

extern gboolean ctk_screen_dirty;
extern gboolean ctk_clean_redraw;

void ctk_main_garbage_cleanup();

#endif
