/***************************************************************************
 $RCSfile: ctcore_public.h,v $
                             -------------------
    cvs         : $Id: ctcore_public.h,v 1.5 2003/03/02 16:48:58 aquamaniac Exp $
    begin       : Fri Nov 22 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTCORE_DEFS_H
#define CTCORE_DEFS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <chameleon/conf.h>


#define CTCORE_ERROR_TYPE "CTCore"
#define CTCORE_ERROR_OPEN_DRIVER_PATH 1
#define CTCORE_ERROR_DRIVER_IO        2
#define CTCORE_ERROR_BUFFER           3
#define CTCORE_ERROR_NO_DRIVER        4
#define CTCORE_ERROR_NO_READER        5
#define CTCORE_ERROR_NO_CLIENT        6
#define CTCORE_ERROR_CARD_REMOVED     7
#define CTCORE_ERROR_LOCKED           8
#define CTCORE_ERROR_DRIVER_SOFT      9
#define CTCORE_ERROR_DRIVER_BUSY      10
#define CTCORE_ERROR_INVALID          11
#define CTCORE_ERROR_BAD_READER       12


/* Developers note: These values are redefined in libchipcard.h.
 * So please remember to change the values there, too, when changing these
 * values here ! */
#define CTREADERSTATUS_INSERTED        0x0001
#define CTREADERSTATUS_CONNECTED       0x0002
#define CTREADERSTATUS_PROCESSOR       0x0004
#define CTREADERSTATUS_LOCKED_BY_OTHER 0x0008

#define CTREADERFLAGS_KEYPAD  0x0001
#define CTREADERFLAGS_DISPLAY 0x0002


CHIPCARD_API typedef struct CTREADERDESCRSTRUCT CTREADERDESCRIPTION;

CHIPCARD_API typedef enum {
  DriverTypeUnknown=0,
  DriverTypePCSC,
  DriverTypeCTAPI
} CTDRIVERTYPE;


CHIPCARD_API struct CTREADERDESCRSTRUCT {
  CTREADERDESCRIPTION *next;
  int id;
  unsigned int readerFlags;
  char name[64];
  char portName[64]; /** name of the port (e.g. "COM1") */
  char typeName[64]; /** name of the reader type (e.g. "towitoko") */
  CTDRIVERTYPE driverType;
  char driverName[128];
};

CHIPCARD_API CTREADERDESCRIPTION *CTCore_ReaderDescr_new();
CHIPCARD_API void CTCore_ReaderDescr_free(CTREADERDESCRIPTION *rd);

CHIPCARD_API void CTCore_ReaderDescr_Add(CTREADERDESCRIPTION *cmd,
					 CTREADERDESCRIPTION **head);
CHIPCARD_API void CTCore_ReaderDescr_Remove(CTREADERDESCRIPTION *cmd,
					    CTREADERDESCRIPTION **head);
CHIPCARD_API CTREADERDESCRIPTION
  *CTCore_ReaderDescr_Duplicate(CTREADERDESCRIPTION *ds);

CHIPCARD_API CTREADERDESCRIPTION *CTCore_ReadReaderDescr(CONFIGGROUP *grp);
CHIPCARD_API int CTCore_WriteReaderDescr(CONFIGGROUP *grp,
					 CTREADERDESCRIPTION *ds);

CHIPCARD_API int CTCore_ReadDriverDescriptions(const char *configdir,
					       CONFIGGROUP *cfg);


#ifdef __cplusplus
}
#endif

#endif /* CTCORE_DEFS_H */


