/*
 * Copyright (C) 2003--2008  Enrico Zini <enrico@enricozini.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <buffy/utils/system.h>
#include <wibble/exception.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <cstdio>


using namespace std;
using namespace wibble;

namespace buffy
{

Directory::Directory(const std::string& name) : dir(0)
{
	if ((dir = opendir(name.c_str())) == NULL)
		throw wibble::exception::File(name, "opening directory");
}

void stat(const std::string& name, struct stat* st)
{
	if (::stat(name.c_str(), st) != 0)
			throw wibble::exception::File(name, "getting stat() informations");
}

bool statIfFound(const std::string& name, struct stat* st)
{
	if (::stat(name.c_str(), st) != 0)
		if (errno == ENOENT)
			return false;
		else
			throw wibble::exception::File(name, "getting stat() informations");
	return true;
}


}

// vim:set ts=4 sw=4:
