//$Id: examplewindow.cc,v 1.6 2002/07/28 14:45:16 cactus Exp $ -*- c++ -*-

/* bonobomm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "examplewindow.h"
#include <bonobomm/widgets/selector.h>

#include <iostream>

ExampleWindow::ExampleWindow ():
    m_pBonoboWidget (0)
{
    set_resizable ();
    set_default_size (250, 350);
    
    //Do regular GTK+ stuff:

    Gtk::VBox *main_box = new Gtk::VBox;

    // Create a label with instructions
    Gtk::Label *label = new Gtk::Label (
	"Click the button to choose and show a Bonobo Control.\n"
	"But remember that some controls might be empty by default.");

    main_box->pack_start (*manage (label), Gtk::PACK_SHRINK);

    // Create a button to change the embedded control
    Gtk::Button *button = new Gtk::Button ("Choose control");
    button->signal_clicked ().connect (SigC::slot (*this, &ExampleWindow::on_button_clicked));
    main_box->pack_start (*manage (button), Gtk::PACK_SHRINK);

    // This is where we'll stuff the controls
    main_box->pack_start (m_Box_Control);

    // Main screen turn on
    add (*manage (main_box));
    show_all_children ();
}

ExampleWindow::~ExampleWindow()
{
    delete m_pBonoboWidget;
}

void ExampleWindow::on_button_clicked()
{
    Glib::ustring moniker = Gnome::Bonobo::Selector::select_id ("Choose Bonobo control");
    
    if (moniker.size ())
    {
	g_warning ("Creating control: '%s'\n", moniker.c_str ());

	//Remove the existing control:
	if (m_pBonoboWidget)
	{
	    m_Box_Control.remove (*m_pBonoboWidget);	    

	    delete m_pBonoboWidget;
	    m_pBonoboWidget = 0;
	}
	
	//Create the new controls:
	m_pBonoboWidget = new Gnome::Bonobo::Widget (moniker);
	m_Box_Control.pack_start (*m_pBonoboWidget);
	m_pBonoboWidget->show ();
    }
}
