/* ------------------------------------------------------------------------
 * $Id: MapperImpl.cc,v 1.2 2001/08/21 02:20:41 steve Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-18 by Steve Houston.
 *
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes

// -- 3Dwm Includes
#include "Celsius/Vector3D.hh"
#include "Celsius/Matrix3D.hh"
#include "Polhem/MapperImpl.hh"

using namespace Nobel;

// -- Code Segment
MapperImpl::MapperImpl()
    : _transform(new TransformImpl)    
{

}

MapperImpl::~MapperImpl()
{
    deactivate(_transform);
    delete _transform;
}

void MapperImpl::scale(const Nobel::Vertex3D &v)
{
    _transform->scale(v);
}


/********************************************************
 * PlanarMapperImpl                                     *
 ********************************************************/

PlanarMapperImpl::PlanarMapperImpl()
{
    // EMPTY
}

PlanarMapperImpl::~PlanarMapperImpl()
{
    // EMPTY
}

Nobel::TexCoord PlanarMapperImpl::map(const Nobel::Vertex3D &v)
{
    // First, extract the vertex data from the CORBA compatible 
    // Nobel::Vertex3D and place it in a Vector3D class where it can
    // be manipulated.
    // TODO: one day make the Vector3D class CORBA compatible.
    Vector3D v3d(v.x, v.y, v.z);

    Nobel::Matrix m;
    _transform->store(m);
    Matrix3D m3d(m);

    // Transform the supplied point by the 'normalizing' matrix.
    // The resulting point should lie in the range -1,-1,-1 to 1,1,1
    Vector3D point3d = v3d * m3d;

    // Convert from the 'normalized' 3D point to a tex coord in the
    // range 0,0 to 1,1
    // We can just drop the Z as this is planar mapping.
    Nobel::TexCoord t;
    t.u = (point3d.x() + 1.0) / 2.0;
    t.v = (point3d.y() + 1.0) / 2.0;
    return t;
}
