/* ------------------------------------------------------------------------
 * Thread.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-19 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <pthread.h>

// -- Local Includes
#include "Thread.hh"
#include "debug.hh"
#include <iostream>

// -- Local Function Prototypes

// Thread start function
static void *start_thread(void *obj);

// -- Code Segment
Thread::Thread(Runnable *target) :
    _target(target),
    _running(false)
{
    DPRINT("Thread::Thread\n");
    // empty
}
    
Thread::~Thread()
{
    // empty
}

void Thread::run()
{
    DPRINT("Thread::run\n");

    // Execute the runnable object (if we have one)
    _running = true;
    _target->run();
}

void Thread::start()
{
    DPRINT("Thread::start\n");

    // Create the thread and start it on the runnable...
    pthread_create(&_thread, 0, ::start_thread, this);
}

void Thread::join()
{
    pthread_join(_thread, 0);
    _running = false;
}

void Thread::kill()
{
    pthread_cancel(_thread);
}

static void *start_thread(void *obj)
{
    // @@@Dynamic cast here?
    Thread *thread = (Thread *) obj;
    thread->run();
    return 0;
}
