/* ------------------------------------------------------------------------
 * $Id: Logger.cc,v 1.5 2001/06/18 21:55:14 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-07 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Mutex.hh"
#include "Time.hh"
#include "Logger.hh"

// -- Static Instances

std::ostream &		Logger::_output = std::cerr;
Mutex 			Logger::_mutex;
std::set<std::string>	Logger::_groups;

Logger::streamlock Logger::log(const std::string &name) 
{
    streamlock slock(name);
    emit(name, "[");
    emit(name, (long) Time::time());
    emit(name, " : ");
    emit(name, name);
    emit(name, "]\t");
    return slock;
}

void Logger::subscribe(const std::string &name)
{
    _groups.insert(name);
}

void Logger::unsubscribe(const std::string &name)
{
    _groups.erase(name);
}

bool Logger::isActive(const std::string &name)
{
    return _groups.find(name) != _groups.end();
}
