/* ------------------------------------------------------------------------
 * $Id: SolidKitImpl.hh,v 1.4 2001/08/22 12:23:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _SolidKitImpl_hh_
#define _SolidKitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/SolidKit.hh"
#include "Polhem/KitImpl.hh"

// -- Class Declarations

class SolidKitImpl : public virtual POA_Nobel::SolidKit, 
		     public KitImpl {
public:
    
    /**
     * Default constructor.
     **/
    SolidKitImpl() { }

    /**
     * Destructor.
     **/
    virtual ~SolidKitImpl() { }

    // IDL functions
    virtual char *name() {
	return CORBA::string_dup("SolidKit"); 
    }
    
    virtual char *description() {
	return CORBA::string_dup("Solid geometry kit."); 
    }
    
    virtual Nobel::SolidContainer_ptr createContainer();
    
    virtual Nobel::Solid::Binary_ptr createUnion(Nobel::Solid::Node_ptr left,
						 Nobel::Solid::Node_ptr right);
    
    virtual Nobel::Solid::Binary_ptr
    createIntersection(Nobel::Solid::Node_ptr left,
		       Nobel::Solid::Node_ptr right);
    
    virtual Nobel::Solid::Binary_ptr
    createSubtraction(Nobel::Solid::Node_ptr left,
		      Nobel::Solid::Node_ptr right);
    
    virtual Nobel::Solid::Unary_ptr
    createComplement(Nobel::Solid::Node_ptr body);
    
    virtual Nobel::Solid::Geometry_ptr
    createGeometry(Nobel::TriangleGeometry_ptr geo);

    virtual Nobel::Solid::Primitive_ptr
    createPrimitive(Nobel::Primitive_ptr prim);
    
    virtual Nobel::Solid::Transform_ptr
    createTransform(Nobel::Solid::Node_ptr body);
    
    virtual Nobel::Solid::Appearance_ptr
    createAppearance(Nobel::Appearance_ptr app);    
    
private:
    
    // No copy constructor for kits
    SolidKitImpl(const SolidKitImpl &kit);
};

#endif /* SolidKitImpl.hh */
