/* ------------------------------------------------------------------------
 * $Id: PickerImpl.hh,v 1.7 2001/08/22 12:23:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-17 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _PickerImpl_hh_
#define _PickerImpl_hh_

// -- System includes
#include <list>

// -- 3Dwm Includes
#include "Celsius/Vector3D.hh"
#include "Celsius/Vector2D.hh"
#include "Nobel/Picker.hh"
#include "Polhem/VisitorImpl.hh"

// -- Forward Declarations
class View;

// -- Class Declarations

/**
 * Picker implementation class. This class represents an abstract
 * pick, subclasses for ray picking and 3D point picking should
 * inherit from this one. 
 **/
class PickerImpl : public virtual POA_Nobel::Picker,
		   public VisitorImpl {
public:

    /**
     * Constructor.
     *
     * @@@ Need to pass event state here, too!
     **/
    PickerImpl();

    /**
     * Destructor.
     **/
    virtual ~PickerImpl();

    // IDL functions
    virtual void visit(Nobel::Node_ptr n);
    virtual void intersectsVolume(Nobel::Volume_ptr bounds,
				  Nobel::Node_ptr node) = 0;
};

/**
 * Ray picker class.
 **/
class RayPicker : public PickerImpl {
public:

    /**
     * Constructor.
     **/
    RayPicker(const Vector2D &point, View *view);

    /**
     * Destructor.
     **/
    virtual ~RayPicker();

    struct HitNode {
	Nobel::Node_var node;
	Nobel::Vertex3D point; // Point of intersection in model coords.
	float dist;            // Distance of intersection from 2D point.
    };

    const std::list<HitNode> &getHitNodeList() { return _hitList; }

    // IDL functions
    virtual void intersectsVolume(Nobel::Volume_ptr bounds,
				  Nobel::Node_ptr n);

private:

    // The direction of the ray into the scene
    Vector3D _dir;

    // The origin of the ray
    Vector3D _origin;

    std::list<HitNode> _hitList;
};
    
#endif /* PickerImpl.hh */
