/* ------------------------------------------------------------------------
 * LineGeometryImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-28 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _LineGeometryImpl_hh_
#define _LineGeometryImpl_hh_

// -- 3Dwm Includes
#include "Polhem/GeometryImpl.hh"
#include "Nobel/LineGeometry.hh"

// -- Namespace Definitions

class LineGeometryImpl : public POA_Nobel::LineGeometry, 
			 public GeometryImpl {    
public:
    
    /**
     * Default constructor
     **/
    LineGeometryImpl();
    
    /**
     * Destructor
     **/
    virtual ~LineGeometryImpl();
    
    // IDL Operations
    virtual void render(Nobel::Renderer_ptr r);    
    virtual void setVertexNumber(CORBA::Long n);
    virtual void setVertex(CORBA::Long index, const Nobel::Vertex3D &v);
    virtual Nobel::Vertex3D getVertex(CORBA::Long index);
    
    virtual CORBA::Long getLineNumber() { return _lineNumber; }
    virtual void setLineNumber(CORBA::Long);
    virtual void setVertexIndex(CORBA::Long index, const Nobel::Line &f);
    virtual Nobel::Line getVertexIndex(CORBA::Long index);
    virtual Nobel::LineMesh *getMesh();
    virtual void setMesh(const Nobel::LineMesh &mesh);

protected:

    /**
     * Recompute bounding volume. This will step through all the
     * vertices in the geometry and recreate the bounding volume for
     * it.
     **/
    virtual void recomputeBoundingVolume();
    
    /// Utility access functions
    static int offset(int n, int c = 0) { return n * 2 + c; }
    static int a(int n) { return offset(n, 0); }
    static int b(int n) { return offset(n, 1); }
    
    /// Line access
    Nobel::Line line(int n) const {
	Nobel::Line l;
	l.a = _mesh.vertexIndexList[a(n)]; l.b = _mesh.vertexIndexList[b(n)];
	return l;
    }
    
    int _lineNumber;
    Nobel::LineMesh _mesh;
};    

#endif /* LineGeometryImpl.hh */
