// Copyright (c) 1997,1998,1999,2000 Albrecht Kleine    All rights reserved
// Copyright (c) 1998 Artur Biesiadowski
// file version #305

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"



#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

#ifdef INLINE_LONGARITM
long long __divdi3( long long, long long);
long long __moddi3( long long, long long);
#endif

extern int jLOinitID;
extern char *exDetail;

#ifdef GATHER_STATS
int stats_opcodes[256];
int stats_checkcast_interface = 0;
#endif

#define QUICK_OP(opcode)	( (opcode)  > 0xCA )

#ifdef EXT_COMPAT

#ifndef JDK12
 extern void InitClass(ClassClass *kl);	// substitute function
#endif

void Deb_InitClass(ClassClass *kl)
{
   Classjava_lang_Class *classx=unhand(kl);
   fprintf(stderr,"TYA Init %s %x %x\n",  classx->name,classx->flags,classx->access);
   InitClass(kl);
}
#endif



//-----------------------------------------------------------------------
// most important: the code translator, producing x86_code from bytecode
//
// returns -1 if error    else x bytes read
//
int recode(int j,Classjava_lang_Class *klass,struct CINFO* cinfo)
{
   unsigned char code;
   struct fieldblock *fbp;
   struct methodblock *mbp;
   int jj=j;
   int k,m,n ,wop,stac,*pi;
   int i,defaultip,tabsize,aktip,indexmin,indexmax;
   unsigned char op1,op3;
   unsigned short op2;
   int compileJVMinvoke,compileLOCALspace,compileNOJFRset;
   ClassClass *clazz;
   void *tmp;

   if (cinfo->cptr - cinfo->codebase >= cinfo->maxspace - cinfo->resspace)
   {
	// lprintf("TYA: not enough space at %d\n",cinfo->maxspace - cinfo->resspace);
        return NOSPACE_ERROR;
   }
   code=*(cinfo->bptr+j);
   cinfo->iptab[cinfo->ipcnt].java=cinfo->bptr+j;
   cinfo->iptab[cinfo->ipcnt].x86=cinfo->cptr;
   cinfo->iptab[cinfo->ipcnt].type=ANY;
   cinfo->ipcnt++;
   j++;
   dprintf(stderr,"Code=%02x (%p)\n",code,cinfo->mb);
#ifdef VERBOSE_ASM86
   lprintf("-%d.--off %d.-------- OPCODE=%02x ",cinfo->ipcnt,j-1,code);
   decode_bytecode(cinfo->bptr+j-1);
   lprintf(" %p ---------\n",cinfo->cptr);
#endif
#ifdef GATHER_STATS
   INC_mem(&stats_opcodes[code]);
#endif
   // did not use any #defines like "#define NOP 0" etc,
   // because it's important for you to get a feeling 
   // for the real opcodes: if you see some hexdumped 
   // byte code, then it should be easy to "read" this ;-)
   switch (code)
     {
      case 0:break;	// nop
      case 0x01:	// aconst_null
      case 0x03:	// iconst_0
      case 0x0b:	// fconst_0
	n=*(cinfo->bptr+j);
	cinfo->iptab[cinfo->ipcnt-1].arg=0;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
#ifdef COMBINEOP
	if ((n==0x54 || n==0x4F || n==0x51) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_const0);
	else
#endif	  
	{
	   CB(PUSHAX);
	   CB(MOV_AX);
	   CL(0);
	}
	break;
      case 0x02:	// iconst_m1
	cinfo->iptab[cinfo->ipcnt-1].arg=-1;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(-1);
	break;
      case 0x04:	// iconst_1
	cinfo->iptab[cinfo->ipcnt-1].arg=1;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
#ifdef COMBINEOP	
	n=*(cinfo->bptr+j);
	if (n==0x54 && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_const1);
	   break;
	}
	else
#endif
	{
	   CB(PUSHAX);
	   CB(MOV_AX);
	   CL(1);
	}
	break;
      case 0x05:	// iconst_2
	cinfo->iptab[cinfo->ipcnt-1].arg=2;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;	
#ifdef COMBINEOP
	n=*(cinfo->bptr+j);
	if ((n==0x6C || n== 0x68) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_const2);
	   break;
	}
	else
#endif
	{
	   CB(PUSHAX);
	   CB(MOV_AX);
	   CL(2);
	}
	break;
      case 0x06:	// iconst_3
      case 0x07:	// iconst_4
      case 0x08:	// iconst_5
	cinfo->iptab[cinfo->ipcnt-1].arg=code-3;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(code-3);
	break;
      case 0x0a:	// lconst_1
	CB(PUSHAX);
	CW(XOR_AXAX);
	CB(PUSHAX);
	CB(INC_AX);
	break;
      case 0x0c:	// fconst_1
      	CB(PUSHAX);
	CB(MOV_AX);
	CL(0x3F800000);	// = "dd 1.0"
	break;
      case 0x0d:	// fconst_2
	CB(PUSHAX);
	CB(MOV_AX);
	CL(0x40000000);
	break;
      case 0x09:	// lconst_0
      case 0x0e:	// dconst_0	
	CB(PUSHAX);
	CW(XOR_AXAX);
	CB(PUSHAX);
	break;
      case 0x0F:	// dconst_1
	CB(PUSHAX);
	CW(XOR_AXAX);
	CB(PUSHLONG);
	CL(0x3FF00000);	// = "dq 1.0"
	break;
      case 0x10:	// bipush
	m=*(signed char*)(cinfo->bptr+j++);
	cinfo->iptab[cinfo->ipcnt-1].arg=m;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x11:	// sipush
	m=getint16S(&j,cinfo);
	cinfo->iptab[cinfo->ipcnt-1].arg=m;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x12:	// ldc
      case 0xCB:	// ldc_quick
	op1=*(cinfo->bptr+j++);
	if (code==0x12)
	 if (!ResolveClassConstantFromClass(klass->HandleToSelf,op1,cinfo->ee,(unsigned)-1))
	  {  
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif	     
	     return -1;
	  }
	m=klass->constantpool[op1].i;
	cinfo->iptab[cinfo->ipcnt-1].arg=m;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x13:	// ldc_w
      case 0xCC:	// ldc_w_quick
	wop=getint16U(&j,cinfo);
	if (code==0x13)
	 if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	     return -1;
	  }
	m=klass->constantpool[wop].i;
	cinfo->iptab[cinfo->ipcnt-1].arg=m;
	cinfo->iptab[cinfo->ipcnt-1].type=CONST;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x14:	// ldc2_w
      case 0xCD:	// ldc2_w_quick
	wop=getint16U(&j,cinfo);
	if (code!=0xCD)
	 if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	  {  
#ifdef VERBOSE2
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	  return -1;
	  }
	pi=&(klass->constantpool[wop].i);
	m=*pi;
	pi++;
	n=*pi;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);	
	CB(PUSHLONG);
	CL(n);
	break;
      case 0x15:	// iload
      case 0x17:	// fload
      case 0x19:	// aload
	if (cinfo->wide)
	     op2=getint16U(&j,cinfo);
	else
	     op2=*(cinfo->bptr+j++);
	cinfo->iptab[cinfo->ipcnt-1].arg=op2;
	cinfo->iptab[cinfo->ipcnt-1].type=LOAD;
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_TESTS_WORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_TestI);
	   Comp_PUSH_LocalVarToReg(op2,cinfo,EBX);
	}
	else	
#endif
	{
	   CB(PUSHAX);
	   Comp_PUSH_LocalVarToReg(op2,cinfo,EAX);
	}
	break;
      case 0x18:	// dload
      case 0x16:	// lload
      	if (cinfo->wide)
	     op2=getint16U(&j,cinfo);
	else
	     op2=*(cinfo->bptr+j++);
	CB(PUSHAX);
	n=Comp_PUSH_LocalVarToStack(op2,cinfo);
	Comp_PUSH_LocalVarToReg(op2+1,cinfo,EAX);
	if (n) CB(PUSHBX);
	break;

      case 0x2a:	// aload_0
      case 0x1A:	// iload_0
      case 0x22:	// fload_0
	cinfo->iptab[cinfo->ipcnt-1].arg=0;
	cinfo->iptab[cinfo->ipcnt-1].type=LOAD;
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_TESTS_WORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_TestI);
	   Comp_PUSH_LocalVarToReg(0,cinfo,EBX);
	}
	else	
#endif
	{
	   CB(PUSHAX);
	   Comp_PUSH_LocalVarToReg(0,cinfo,EAX);
	}
	break;
      case 0x26:	// dload_0
      case 0x1e:	// lload_0
	CB(PUSHAX);
	n=Comp_PUSH_LocalVarToStack(0,cinfo);
	Comp_PUSH_LocalVarToReg(1,cinfo,EAX);
	if (n) CB(PUSHBX);
	break;
      case 0x1B:	// iload_1
      case 0x23:	// fload_1
      case 0x2B:	// aload_1
	cinfo->iptab[cinfo->ipcnt-1].arg=1;
	cinfo->iptab[cinfo->ipcnt-1].type=LOAD;	
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_TESTS_WORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_TestI);
	   Comp_PUSH_LocalVarToReg(1,cinfo,EBX);
	}
	else	
#endif
	{
	   CB(PUSHAX);
	   Comp_PUSH_LocalVarToReg(1,cinfo,EAX);
	}
	break;
      case 0x27:	// dload_1
      case 0x1F:	// lload_1
	CB(PUSHAX);
	n=Comp_PUSH_LocalVarToStack(1,cinfo);
	Comp_PUSH_LocalVarToReg(2,cinfo,EAX);
	if (n) CB(PUSHBX);
	break;
      case 0x1C:	// iload_2
      case 0x24:	// fload_2
      case 0x2C:	// aload_2
	cinfo->iptab[cinfo->ipcnt-1].arg=2;
	cinfo->iptab[cinfo->ipcnt-1].type=LOAD;	
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_TESTS_WORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_TestI);
	   Comp_PUSH_LocalVarToReg(2,cinfo,EBX);
	}
	else	
#endif
	{
	   CB(PUSHAX);
	   Comp_PUSH_LocalVarToReg(2,cinfo,EAX);
	}
	break;
      case 0x28:	// dload_2
      case 0x20:	// lload_2
	CB(PUSHAX);
	n=Comp_PUSH_LocalVarToStack(2,cinfo);
	Comp_PUSH_LocalVarToReg(3,cinfo,EAX);
	if (n) CB(PUSHBX);
	break;
      case 0x1D:	// iload_3
      case 0x25:	// fload_3
      case 0x2D:	// aload_3
	cinfo->iptab[cinfo->ipcnt-1].arg=3;
	cinfo->iptab[cinfo->ipcnt-1].type=LOAD;	
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_TESTS_WORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_TestI);
	   Comp_PUSH_LocalVarToReg(3,cinfo,EBX);
	}
	else	
#endif
	{
	   CB(PUSHAX);
	   Comp_PUSH_LocalVarToReg(3,cinfo,EAX);
	}
	break;
      case 0x29:	// dload_3
      case 0x21:	// lload_3
	CB(PUSHAX);
	n=Comp_PUSH_LocalVarToStack(3,cinfo);
	Comp_PUSH_LocalVarToReg(4,cinfo,EAX);
	if (n) CB(PUSHBX);
	break;
      case 0x32:	// aaload
      case 0x2e:	// iaload
      case 0x30:	// faload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
	MOV_R_Rsib( EAX, SIB(SIB_SCALE4, EAX, EBX) );	// mov ax,[bx+ax*4]
	break;
      case 0x2f:	// laload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
	MOV_R_Rsiboffs8(ECX, SIB(SIB_SCALE8,EAX,EBX),4);// mov ecx, [eax*8+ebx+4]
	MOV_R_Rsib(EAX, SIB(SIB_SCALE8, EAX,EBX));	// mov eax, [eax*8+ebx]
        CB(PUSHCX);
	break;	
      case 0x31:	// daload
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);	// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  {
	     SET_OPTFLAG(DF_DD);
	     CW(FLDQW_M);CB(IDX_ADDR_BYTE3);		// fld qword ptr [ebx+8*eax]
	     if (NEXT_LOADS_2_QWORDS(n))
	       SET_OPTFLAG(DF_DDextra);
	     else
	       {
		  CB(PUSHAX);
		  CB(PUSHAX);
	       }
          }
	else
#endif
	{
	   MOV_R_Rsiboffs8(ECX, SIB(SIB_SCALE8, EAX,EBX), 4);	// mov ecx, [eax*8+ebx+4]
	   MOV_R_Rsib(EAX, SIB(SIB_SCALE8, EAX,EBX));	// mov eax, [eax*8+ebx]
           CB(PUSHCX);
	}
	break;
      case 0x33:	// baload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
	CL(0x0304be0f);	// movsxb eax, [ebx + eax]	baload should copy with sign extension
	break;
      case 0x34:	// caload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
#if 0
	CL(0x4304b70f);// movzwl	eax, [ebx + eax*2]
#else	
	MOV_R_Rsib(EAX, SIB(SIB_SCALE2, EAX, EBX));
	CB(AND_AX_LONG);
	CL(0xFFFF);	// hide other int16
#endif	
	break;
      case 0x35:	// saload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo);	// ebx will point to element 0
	CL(0x4304bf0f);	// movsxw eax, [ebx + eax*2]	saload should copy with sign extension
	break;
      case 0x36:	// istore
      case 0x38:	// fstore
      case 0x3a:	// astore
	if (cinfo->wide)
	  op2=getint16U(&j,cinfo);
	else
	  op2=*(cinfo->bptr+j++);
	cinfo->iptab[cinfo->ipcnt-1].arg=op2;
	cinfo->iptab[cinfo->ipcnt-1].type=STORE;
	Comp_POP_StoreLocalVarFromReg(op2,cinfo,code!=0x3A,EAX);
	CB(POPAX);
	break;
      case 0x39:	// dstore
      case 0x37:	// lstore
	if (cinfo->wide)
	     op2=getint16U(&j,cinfo);
	else
	     op2=*(cinfo->bptr+j++);
	Comp_POP_StoreLocalVarFromReg(op2+1,cinfo,1,EAX);
	CB(POPAX);
	Comp_POP_StoreLocalVarFromReg(op2,cinfo,1,EAX);
	CB(POPAX);
	break;
      case 0x3b:	//istore_0
      case 0x43:	//fstore_0
      case 0x4b:	//astore_0
	cinfo->iptab[cinfo->ipcnt-1].arg=0;
	cinfo->iptab[cinfo->ipcnt-1].type=STORE;
	Comp_POP_StoreLocalVarFromReg(0,cinfo,code!=0x4B,EAX);
	CB(POPAX);
	break;
      case 0x47:	//dstore_0
      case 0x3f:	//lstore_0
	Comp_POP_StoreLocalVarFromReg(1,cinfo,1,EAX);
	CB(POPAX);
	Comp_POP_StoreLocalVarFromReg(0,cinfo,1,EAX);
	CB(POPAX);
	break;
      case 0x3c:	//istore_1
      case 0x44:	//fstore_1
      case 0x4C:	//astore_1
	cinfo->iptab[cinfo->ipcnt-1].arg=1;
	cinfo->iptab[cinfo->ipcnt-1].type=STORE;
	Comp_POP_StoreLocalVarFromReg(1,cinfo,code!=0x4C,EAX);
	CB(POPAX);
	break;
      case 0x48:	//dstore_1
      case 0x40:	//lstore_1
	Comp_POP_StoreLocalVarFromReg(2,cinfo,1,EAX);
	CB(POPAX);
	Comp_POP_StoreLocalVarFromReg(1,cinfo,1,EAX);
	CB(POPAX);
	break;
      case 0x3d:	//istore_2
      case 0x45:	//fstore_2
      case 0x4d:	//astore_2
	cinfo->iptab[cinfo->ipcnt-1].arg=2;
	cinfo->iptab[cinfo->ipcnt-1].type=STORE;
	Comp_POP_StoreLocalVarFromReg(2,cinfo,code!=0x4D,EAX);
	CB(POPAX);
	break;
      case 0x49:	//dstore_2
      case 0x41:	//lstore_2
	Comp_POP_StoreLocalVarFromReg(3,cinfo,1,EAX);
	CB(POPAX);
	Comp_POP_StoreLocalVarFromReg(2,cinfo,1,EAX);
	CB(POPAX);
	break;
      case 0x4e:	//astore_3
      case 0x3e:	//istore_3
      case 0x46:	//fstore_3
	cinfo->iptab[cinfo->ipcnt-1].arg=3;
	cinfo->iptab[cinfo->ipcnt-1].type=STORE;
	Comp_POP_StoreLocalVarFromReg(3,cinfo,code!=0x4E,EAX);
	CB(POPAX);
	break;
      case 0x4A:	//dstore_3
      case 0x42:	//lstore_3
	Comp_POP_StoreLocalVarFromReg(4,cinfo,1,EAX);
	CB(POPAX);
	Comp_POP_StoreLocalVarFromReg(3,cinfo,1,EAX);
	CB(POPAX);
	break;
      case 0x4f:	// iastore
      case 0x51:	// fastore
#ifdef COMBINEOP
	if (GET_OPTFLAG(DF_const0))
	{
	   CB(POPBX);	// ebx =array  / index is in eax, data value is a const
	   CompTriggerNullPointerException(cinfo,EBX);
	   CompTriggerArrOutOfBoundsException(cinfo);
	   CB(0xC7);CB(0x04);CB(0x83);CL(0);	   // mov dword ptr [ebx+4*eax],0
	  }
	else
#endif
	{	
	CB(POPDX);	// =index	
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException2(cinfo,0);	// ebx will point to element 0
	MOV_Rsib_R( SIB(SIB_SCALE4, EDX,EBX ), EAX );
	}
	CB(POPAX);
	break;
      case 0x52:	// dastore
#ifdef COMBINEOP	
	if (GET_OPTFLAG(DF_DD))
	   CB(POPAX);
#endif	
	CB(POPCX);
	CB(POPDX);	// =index 
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException2(cinfo,-1);	// ebx will point to element 0
#ifdef COMBINEOP	
	if (GET_OPTFLAG(DF_DD))
	{
	     CW(FSTPQW_M);CB(INX_ADDR_BYTE3);
	}
	else
#endif	  
	{
	   MOV_Rsiboffs8_R( SIB(SIB_SCALE8, EDX, EBX), 4, ECX);	// mov [eax*8+ebx+4], ecx
	   MOV_Rsib_R(SIB(SIB_SCALE8, EDX,EBX), EAX);	// mov [eax*8+ebx], edx
	}
	CB(POPAX);
	break;
      case 0x50:	// lastore
	CB(POPCX);
	CB(POPDX);	// =index 
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException2(cinfo,-1);	// ebx will point to element 0
	MOV_Rsiboffs8_R( SIB(SIB_SCALE8, EDX, EBX), 4, ECX);	// mov [eax*8+ebx+4], ecx
	MOV_Rsib_R(SIB(SIB_SCALE8, EDX,EBX), EAX);	// mov [eax*8+ebx], edx
	CB(POPAX);
	break;
      case 0x53:	// aastore
	CB(POPDX);	// =index	
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	// eax is object value on stacktop
	CompTriggerArrayStoreException(cinfo);
	// does also check for	ArrOutOfBoundsException
	// and sets ebx as side effect to array element 0 ptr
	MOV_Rsib_R( SIB(SIB_SCALE4, EDX,EBX ), EAX );	// mov [ebx + 4*edx], eax
	CB(POPAX);
	break;
      case 0x54:	// bastore
#ifdef COMBINEOP	
	if (GET_OPTFLAG(DF_const0) || GET_OPTFLAG(DF_const1))
	{
	   CB(POPBX);	// ebx =array  / index is in eax, data value is a const
	   CompTriggerNullPointerException(cinfo,EBX);
	   CompTriggerArrOutOfBoundsException(cinfo);
	   CB(0xC6);CB(04);CB(03);
	   if (GET_OPTFLAG(DF_const0)) 
	     CB(0);				// mov byte ptr [ebx+eax],0
	   else 
	     CB(1);
	  }
	else
#endif
	{
	   CB(POPDX);	// =index
	   CB(POPBX);	// =array
	   CompTriggerNullPointerException(cinfo,EBX);
	   CompTriggerArrOutOfBoundsException2(cinfo,0);	// ebx will point to element 0
	   MOV_Rsib_8R(SIB(SIB_SCALE1, EDX, EBX), R8_AL);
	}
	CB(POPAX);
	break;
      case 0x55:	// castore
      case 0x56:	// sastore
	CB(POPDX);	// =index	
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException2(cinfo,0);	// ebx will point to element 0
	CB(PREF_32);
	MOV_Rsib_R(SIB(SIB_SCALE2, EDX,EBX), EAX);
	CB(POPAX);
	break;
      case 0x57:	//pop
	CB(POPAX);
	break;
      case 0x58:	//pop2
	CB(POPAX);
	CB(POPAX);
	break;
      case 0x59:	//dup
	CB(PUSHAX);
	break;
      case 0x5a:	//dup_x1
	CB(POPBX);
	CB(PUSHAX);
	CB(PUSHBX);
	break;
      case 0x5b:	//dup_x2	FYI: eax==stacktop
	CB(POPBX);//2
	CB(POPDX);//3
	CB(PUSHAX);//4=1
	CB(PUSHDX);//3
	CB(PUSHBX);//2
	break;
      case 0x5C:	//dup2		ditto
	CB(POPBX);//2
	CB(PUSHBX);//4=2
	CB(PUSHAX);//3=1
	CB(PUSHBX);//2
	break;
      case 0x5D:	//dup2_x1	etc
	CB(POPBX);//2
	CB(POPDX);//3
	CB(PUSHBX);//5=2
	CB(PUSHAX);//4=1
	CB(PUSHDX);//3
	CB(PUSHBX);//2
	break;
      case 0x5E:	//dup2_x2
	CB(POPBX);//2
	CB(POPCX);//3
	CB(POPDX);//4
	CB(PUSHBX);//6=2
	CB(PUSHAX);//5=1
	CB(PUSHDX);//4
	CB(PUSHCX);//3
	CB(PUSHBX);//2
	break;
      case 0x5F:	//swap
	CB(POPDX);
	CB(PUSHAX);
	CW(MOV_AXDX);
	break;	
      case 0x60:	//iadd
	cinfo->iptab[cinfo->ipcnt-1].type=ARIT;
	cinfo->iptab[cinfo->ipcnt-1].arg=ADD;// subtype
	CB(POPBX);
	CW(ADD_AXBX);
	break;
      case 0x61:	//ladd
	CB(POPCX);
	CB(POPBX);
	CB(POPDX);
	CW(ADD_AXBX);
	CW(ADC_CXDX);
	CB(PUSHCX);
	break;
      case 0x62:	// fadd
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// fld word [sp]
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FADDP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{
	   CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	   CB(POPAX);
	}
	break;
      case 0x63:	// dadd
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	// fld qword [sp]
	}
#ifdef COMBINEOP	
	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FADDP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x64:	// isub
	cinfo->iptab[cinfo->ipcnt-1].type=ARIT;
	cinfo->iptab[cinfo->ipcnt-1].arg=SUB;// subtype	
	CW(MOV_DXAX);
	CB(POPAX);
	CW(SUB_AXDX);
	break;
      case 0x65:	// lsub
	CW(MOV_BXAX);	// stacktop
	CB(POPDX);
	CB(POPAX);
	CB(POPCX);
	CW(SUB_AXBX);
	CW(SBB_CXDX);
	CB(PUSHCX);
	break;
      case 0x66:	// fsub
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// fld word [sp]
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSUBRP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{
	   CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	   CB(POPAX);
	}
	break;
      case 0x67:	// dsub
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif	  
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	}
#ifdef COMBINEOP	
	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSUBRP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x68:	// imul
#ifdef COMBINEOP
	if (GET_OPTFLAG(DF_const2))
	{
	   CW(ADD_AXAX);
	   break;
	}
#endif
	CB(POPBX);
	CW(IMUL_BX);
	break;
      case 0x69:	// lmul
	
	CB(MOV_BX);
	CL(llmul_wrapper);	
      	CB(PUSHAX);	// push logical stacktop on cpu stack
#if 1	
	CW(CALL_EBX);
	CB(POPCX);	
	CB(POPBX);
	CB(POPCX);
	CB(POPBX);
#else	
	CL(CALL_ADDSP);
	CB(0x10);
#endif
	CB(PUSHDX);
	break;
      case 0x6A:	// fmul
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
      	 CB(PUSHAX);
	 CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FMULP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX);
      	}
	break;
      case 0x6b:	// dmul
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif
	{
	   CB(PUSHAX); 
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	}
#ifdef COMBINEOP	
	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FMULP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x6c:	// idiv
#ifdef COMBINEOP
	if (GET_OPTFLAG(DF_const2))
	{
	   CW(SAR_AX);
	   CB(1);	   
	   CB(JNS);			// not negative is okay
	   CB(3);
	   CW(ADC_AX_BYTE);		// now fix rounding problem
	   CB(0);
	   break;
	}
#endif
#ifndef EXCEPTIONS_BY_SIGNALS
	CW(TEST_AXAX);
	CompTriggerDivZeroException(cinfo);
#endif
  	CB(POPBX);
	CB(XCHG_AXBX);
	CB(CMP_AX);
	CL(0x80000000);
	CB(JNE);
	CB(5);
	CW(CMP_BX_BYTE);
	CB(-1);
	CB(JE);
	CB(3);
	CB(CDQ);	// eax->edx:eax
	CW(IDIV_BX);
	break;
      case 0x6d:	// ldiv
////      	CB(PUSHAX);	// push logical stacktop on cpu stack
	CompTriggerLONGDivZeroException(cinfo); 
#ifdef INLINE_LONGARITM
	MOV_R_R( EAX, ESP );
	CB(MOV_BX);
	CL(__divdi3);	
	PUSH_Roffs8(EAX, 12);
	PUSH_Roffs8(EAX, 8);
	CL(CALL_ADDSP);
	CB(0x18);
	CB(PUSHDX); 	// eax is our stacktop
#else
	CB(MOV_BX);
	CL(lldiv_wrapper);
	CL(CALL_ADDSP);
	CB(0x10);
	CB(PUSHDX); 	// eax is our stacktop
#endif	
	break;
      case 0x6E:	// fdiv
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FDIVRP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{
	   CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	   CB(POPAX);
      	}
	break;
      case 0x6f:	// ddiv
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif  
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	}
#ifdef COMBINEOP	
	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FDIVRP_ST1);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);		//nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	   SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	   CB(POPAX);
	}
	break;
      case 0x70:	// irem
#ifndef EXCEPTIONS_BY_SIGNALS
	CW(TEST_AXAX);
	CompTriggerDivZeroException(cinfo);
#endif	
	CB(POPBX);
	CB(XCHG_AXBX);
	CB(CMP_AX);
	CL(0x80000000);
	CB(JNE);
	CB(10);
	CW(CMP_BX_BYTE);
	CB(-1);
	CB(MOV_DX);
	CL(0);
	CB(JE);
	CB(3);
	
	CB(CDQ);	// eax->edx:eax
	CW(IDIV_BX);
	CW(MOV_AXDX);
	break;
      case 0x71:	// lrem
////      	CB(PUSHAX);	// push logical stacktop on cpu stack
	CompTriggerLONGDivZeroException(cinfo);
#ifdef INLINE_LONGARITM
	MOV_R_R( EAX, ESP );
	CB(MOV_BX);
	CL(__moddi3);	
	PUSH_Roffs8(EAX, 12);
	PUSH_Roffs8(EAX, 8);
	CL(CALL_ADDSP);
	CB(0x18);
	CB(PUSHDX); 	// eax is our stacktop
#else	
	CB(MOV_BX);
	CL(llrem_wrapper);
	CL(CALL_ADDSP);	
	CB(0x10);
	CB(PUSHDX);
#endif
	break;

      case 0x72:	// frem
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FPREM);
	CW(FXCH);	
	CW(FSTP_ST0);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{	
	  CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	  CB(POPAX);
      	}
	break;
      case 0x73:	// drem
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	// fld qword [sp]
	}
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FPREM);
	CW(FXCH);
	CW(FSTP_ST0);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x74:	// ineg
	CW(NEG_AX);
	break;
      case 0x75:	// lneg
	CB(POPBX);
	CW(NOTBX);
	CW(NOTAX);
	CW(ADDAX);
	CB(1);		// =Zweier-Komplement  [ in English: "complement on two" ? ]
	CW(ADCBX);
	CB(0);
	CB(PUSHBX);
	break;
      case 0x76:	// fneg
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	}
	CW(FCHS);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_DWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   SET_OPTFLAG(DF_FF);
	}
	else
#endif	
	{
	   CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	   CB(POPAX);
      	}
	break;
      case 0x77:	// dneg
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	// fld qword [sp]
	}	
	CW(FCHS);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x78:	// ishl
	CW(MOV_CXAX);	// stacktop to reg ecx
	CB(POPAX);
	CW(SHL_AXCL);
	break;
      case 0x79:	// lshl
	CB(AND_AL);
	CB(0x3F);	// 6 bit
	CW(MOV_CXAX);	
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CB(PUSHDX);
	break;
	
      case 0x7A:	// ishr
	CW(MOV_CXAX);	// stacktop is shift
	CB(POPAX);
	CW(SAR_AXCL);
	break;

      case 0x7B:	// lshr
	CB(AND_AL);
	CB(0x3F);
	CW(MOV_CXAX);
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CB(PUSHDX);
	break;

      case 0x7C:	// iushr
	CW(MOV_CXAX);	//		etc
	CB(POPAX);
	CW(SHR_AXCL);
	break;

      case 0x7D:	// lushr
	CB(AND_AL);
	CB(0x3F);
	CW(MOV_CXAX);
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CB(PUSHDX);
	break;

      case 0x7E:	// iand
	CB(POPBX);
	CW(AND_AXBX);
	break;
      case 0x7F:	// land
	CB(POPBX);
	CB(POPCX);	
	CB(POPDX);
	CW(AND_AXCX);
	CW(AND_DXBX);
	CB(PUSHDX);
	break;
      case 0x80:	// ior
	CB(POPBX);
	CW(OR_AXBX);
	break;
      case 0x81:	// lor
	CB(POPBX);
	CB(POPCX);
	CB(POPDX);
	CW(OR_AXCX);
	CW(OR_DXBX);
	CB(PUSHDX);
	break;
      case 0x82:	// ixor
	CB(POPBX);
	CW(XOR_AXBX);
	break;
      case 0x83:	// lxor
	CB(POPBX);
	CB(POPCX);
	CB(POPDX);
	CW(XOR_AXCX);
	CW(XOR_DXBX);
	CB(PUSHDX);
	break;
      case 0x84:	// iinc
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	     n=getint16S(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	     n=*(signed char*)(cinfo->bptr+j++);
	  }
	dprintf(stderr,"iinc: op2=%d n=%d\n",op2,n);
	Comp_INC_LocalVar(op2,n,cinfo);
	cinfo->wide=0;
	break;
      case 0x85:	// i2l
#if 0	
	CB(CDQ);
#else
	CW(MOV_DXAX);
	CW(SAR_DX);
	CB(31);
#endif
	CB(PUSHDX);
	break;
      case 0x86:	// i2f
	CB(PUSHAX);
	CW(FILDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	break;
      case 0x87:	// i2d
	CB(PUSHAX);
	CW(FILDW_MSP);CB(SP_ADDR_BYTE3);
	CB(PUSHAX);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	   SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x88:	// l2i
	CB(POPBX);	// discard 32 bits
	break;
      case 0x89:	// l2f
	CB(PUSHAX);
	CW(FILDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	break;
      case 0x8a:	// l2d
	CB(PUSHAX);
	CW(FILDQW_MSP);CB(SP_ADDR_BYTE3);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	  SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x8b:	// f2i
      case 0x8c:	// f2l
      case 0x8e:	// d2i
      case 0x8f:	// d2l
	Comp87ToInteger(code,cinfo);
	break;
      case 0x8d:	// f2d
	CB(PUSHAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(PUSHAX);
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if (NEXT_LOADS_QWORD(n) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	   SET_OPTFLAG(DF_DD);
	else
#endif
	{
	   CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	   CB(POPAX);
	}
	break;
      case 0x90:	// d2f
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif	  
	{
	   CB(PUSHAX); 
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	}	
	CB(POPAX);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	break;
      case 0x91:	// int2byte
	CB(PREBYTE_0F);
	CW(0xC0BE);	// movsx eax,al
	break;
      case 0x92:	// int2char
#if 1
	CB(AND_AX_LONG);
	CL(0xffff);
#else
	CB(PREBYTE_0F);
	CW(0xC0B7);	// movzx eax,ax does not pair
#endif
	break;
      case 0x93:	// int2short
#if 0	
	CB(CWDE);
#else	
	CB(PREBYTE_0F);
	CW(0xC0BF);	// movsx eax,ax
#endif	
	break;
      case 0x94:	// lcmp
#ifdef COMBINEOP
	n= *(cinfo->bptr+j);			// nextcode
	if ((n==0x99 || n==0x9A) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	{
	   CB(POPBX);
	   CB(POPDX);
	   CB(POPCX);
	   CW(CMP_CXBX);
	   CB(JNE);
	   CB(2);
	   CW(CMP_DXAX);
	   SET_OPTFLAG(DF_CmpL);
	}
	else
#endif
	{
	CW(MOV_BXAX);						
	CB(POPAX);
	CB(POPDX);
	CB(POPCX);
	CW(CMP_CXAX);
	CB(MOV_AX);
	CL(0);
	CB(JNGE);
	CB(8);                        
	CB(JNLE);
	CB(9);
	CW(CMP_DXBX);						
	CB(JE);
	CB(6);
	CB(JA);
	CB(3);
	CB(DEC_AX);
	CB(JMPS);
	CB(1);
	CB(INC_AX);
	}
	break;
      case 0x95:	// fcmpl
      case 0x96:	// fcmpg
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_FF))
#endif	 
	{
	   CB(PUSHAX);
	   CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// fld word [sp]
	}
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	Comp87Vergleich(code,cinfo,*(cinfo->bptr+j));
	break;
      case 0x97:	// dcmpl
      case 0x98:	// dcmpg
#ifdef COMBINEOP
	if (!GET_OPTFLAG(DF_DD))
#endif
	{
	   CB(PUSHAX);
	   CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	// fld qword [sp]
	}
#ifdef COMBINEOP	
 	if (!GET_OPTFLAG(DF_DDextra))
#endif	  
	{
	   CB(POPAX);
	   CB(POPBX);
	}
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPAX);
	CB(POPBX);
	Comp87Vergleich(code,cinfo,*(cinfo->bptr+j));
	break;	
      case 0x99:	// ifeq
      case 0xC6:	// ifnull
	CompVergleich(0x99,&j,JZ2,cinfo,JZ2);
	break;
      case 0x9A:	// ifne
      case 0xC7:	// ifnonnull
	CompVergleich(0x9A,&j,JNZ2,cinfo,JNZ2);
	break;
      case 0x9B:	// iflt
	CompVergleich(0x9B,&j,JL2,cinfo,JB2);
	break;
      case 0x9c:	// ifge
	CompVergleich(0x9C,&j,JGE2,cinfo,JNB2);
	break;
      case 0x9d:	// ifgt
	CompVergleich(0x9D,&j,JG2,cinfo,JA2);
	break;
      case 0x9e:	// ifle
	CompVergleich(0x9E,&j,JLE2,cinfo,JNA2);
	break;
      case 0x9F:	// if_icmpeq
      case 0xa5:	// if_acmpeq
	CompVergleich(0x9F,&j,JZ2,cinfo,0);
	break;
      case 0xA0:	// if_icmpne
      case 0xA6:	// if_acmpne
	CompVergleich(0xA0,&j,JNZ2,cinfo,0);
	break;
      case 0xA1:	// if_icmplt
	CompVergleich(0xA1,&j,JL2,cinfo,0);
	break;
      case 0xA2:	// if_icmpge
	CompVergleich(0xA2,&j,JGE2,cinfo,0);
	break;
      case 0xA3:	// if_icmpgt
	CompVergleich(0xA3,&j,JG2,cinfo,0);
	break;
      case 0xA4:	// if_icmple
	CompVergleich(0xA4,&j,JLE2,cinfo,0);
	break;
      case 0xA7:	// goto
	CompVergleich(0xA7,&j,0/*unused*/,cinfo,0);
	break;

      case 0xA8:	// jsr
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	m=getint16S(&j,cinfo);
	dprintf(stderr,"jsr: jump %d java byte\n",m);
	CB(PUSHAX);
	CB(CALL);
	CL(0);
	CB(POPAX); //1
	CW(ADDAX); //3 	stacktop now is "next_java_instruction"
	CB(9);	   //4
	CB(JMP1);  //5
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0);     //9	 backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;

      case 0xA9:	// ret
	op1=*(cinfo->bptr+j++);
	dprintf(stderr,"ret: jump  #%d var\n",op1);	
	if (Comp_PUSH_LocalVarToStack(op1,cinfo))	// bypassing eax-stacktop
	  CB(PUSHBX);
	CB(RETN);
	break;

      case 0xAA:	// tableswitch
	k=j-1;		// jump base adr offset
  	while ((int)(cinfo->bptr+j) % 4)
	     j++;
	defaultip=getint32(&j,cinfo);
	indexmin =getint32(&j,cinfo);
	indexmax =getint32(&j,cinfo);
	tabsize  =indexmax-indexmin+1;
        dprintf(stderr, "defaultip = %d indexmin=%d indexmax=%d tabsize=%d\n",
              defaultip, indexmin, indexmax, tabsize);
	#define AATAB 5
	if (cinfo->cptr - cinfo->codebase >=
	    cinfo->maxspace - cinfo->resspace + tabsize * AATAB)
        {
	 lprintf("TYA: not enough space in tableswitch at %d\n", cinfo->cptr - cinfo->codebase);
         return NOSPACE_ERROR;
        }
	CW(LEA_BX_AX_LONG);	// eax==value to swich
	CL(-indexmin);		// lea ebx,[eax-indexmin]
	CB(POPAX);  	// <-- go jumping with a proper stacktop
	CW(CMP_BX);
	CL(tabsize);	
	CW(JNB2);	// default branch
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	CL(0);			// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=defaultip;
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	cinfo->backcnt++;
	CW(LEA_BX);		// lea ebx,[ebx+ebx*4]  == mul_5
	CB(0x9b);
	   
	CB(CALL);		// indexed relative jump
	CL(0);
	CB(POPCX);//1
	CB(0x8D);//2		// lea ebx,[ecx+ebx+7]
	CB(0x5C);//3
	CB(0x19);//4
	CB(0x07);//5   	// <---- 7 Byte  **take care**
	CW(JMP_BX);//7
	for (i=0;i<tabsize;i++)
	{
	  aktip=getint32(&j,cinfo);
	  CB(JMP1);  
	  cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	  cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	  CL(0);		// backpatched later
	  cinfo->backp[cinfo->backcnt].javadist=aktip;
	  cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	  cinfo->backcnt++;
	}
	#define AATAB 5		// 5 byte per tabentry
	break;

      case 0xAB:	// lookupswitch	
	k=j-1;		// jump base adr offset
  	while ((int)(cinfo->bptr+j) % 4)
	     j++;
	defaultip=getint32(&j,cinfo);
	tabsize  =getint32(&j,cinfo);
	dprintf(stderr,"lookupswitch tab=>%d  def=%d\n",tabsize,defaultip);
	#define ABTAB 12	// =byte per tabentry
	if (cinfo->cptr - cinfo->codebase >=
	    cinfo->maxspace - cinfo->resspace + tabsize * ABTAB)
        {
	 lprintf("TYA: not enough space in lookupswitch at %d\n", cinfo->cptr - cinfo->codebase);
         return NOSPACE_ERROR;
        }
	CW(MOV_DXAX);	//value to switch
	CB(POPAX);	// <-- go jumping with a proper stacktop
	for (i=0;i<tabsize;i++)
	{
	  CW(CMP_DX_LONG);
	  CL(getint32(&j,cinfo));	     	// read 1 int more: value to compare
	  aktip=getint32(&j,cinfo);
	  CW(JZ2);
	  cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	  cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	  CL(0);		// backpatched later
	  cinfo->backp[cinfo->backcnt].javadist=aktip;
	  cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	  cinfo->backcnt++;
	}			
	CB(JMP1);
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	CL(0);			// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=defaultip;
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	cinfo->backcnt++;
	break;
	
      case 0xB0:	// areturn
      case 0xAC:	// ireturn
      case 0xAE:	// freturn
      case 0xAD:	// lreturn
      case 0xAF:	// dreturn
	if (cinfo->isinline)
	{ 
	  if (cinfo->mb->code_length-j)
	  {
   	     cinfo->backp[cinfo->backcnt].java=cinfo->bptr+j-1;
	     cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	     CB(JMP1);
	     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	     CL(0);		// backpatched later
	     cinfo->backp[cinfo->backcnt].javadist=cinfo->mb->code_length-j+1;
	     cinfo->backcnt++;
	  }
	  break;
	}
#ifndef NOCOMPSYNC
        if (cinfo->mb->fb.access & ACC_SYNCHRONIZED)
	  {
	     CB(PUSHAX);
	     CB(MOV_BX);
	     CL(monitorExit);	     
	     if (cinfo->mb->fb.access & ACC_STATIC)
	       {
		  CB(PUSHLONG);
		  CL(klass->HandleToSelf);
	       }
	     else  
	       {
	          Comp_PUSH_LocalVarToReg(0,cinfo,EAX);
		  CB(PUSHAX);
               }  
	     CW(CALL_EBX);
	     CB(POPBX);	     
	     CB(POPAX);
	  }
#endif
	if (code==0xAD || code==0xAF)
	   CB(POPDX);
	CW(MOV_SPBP);
	CL(POPBPDISIBX);
	CB(RETN);
	break;
#define VRETURN 0xB1	
      case 0xB1:	// void return
	if (cinfo->isinline)
	{ 
	  if (cinfo->mb->code_length-j)
	  {
   	     cinfo->backp[cinfo->backcnt].java=cinfo->bptr+j-1;
	     cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	     CB(JMP1);
	     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	     CL(0);		// backpatched later
	     cinfo->backp[cinfo->backcnt].javadist=cinfo->mb->code_length-j+1;
	     cinfo->backcnt++;
	  }
	  break;
	}
#ifndef NOCOMPSYNC
	if (cinfo->mb->fb.access & ACC_SYNCHRONIZED)
	  {
	     CB(MOV_BX);
	     CL(monitorExit);	     
     	     if (cinfo->mb->fb.access & ACC_STATIC)
	       {
		  CB(PUSHLONG);
		  CL(klass->HandleToSelf);
	       }
	     else
	     {
	       Comp_PUSH_LocalVarToReg(0,cinfo,EAX);
	       CB(PUSHAX);
	     }  
	     CW(CALL_EBX);
	  }
#endif	
	CW(MOV_SPBP);
	CL(POPBPDISIBX);
	CB(RETN);
	break;

      case 0xD4:	// getstatic2_quick
	 dprintf(stderr,"TYA: !!!!! not yet debugged opcode (%x)\n",code);
      case 0xB2:	// getstatic
      case 0xD2:	// getstatic_quick
	CB(PUSHAX);
        fbp=GetBlock(NULL,0,code,&j,klass,cinfo,code==0xD2 || code==0xD4);
        if (!fbp)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	     return -1;	// error
	  }
#ifdef EXT_COMPAT
	if (!QUICK_OP(code) &&  !(unhand(fbp->clazz)->flags & DEF_CCF_IsInitialized) )
	{
	   CB(MOV_AX);
	   CL(DEF_InitClass);	   
	   CB(PUSHLONG);
	   CL(fbp->clazz);
	   CW(CALL_EAX);
	   CB(POPCX);
	}
#endif	
	
	// Unfortunately it seems all static finals are NOT guaranteed 
	// to be set after <clinit>  Sun Jun 20 17:50:30 1999
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	  {
	     MOV_R_mem( EDX, fbp->u.static_address+4);
	     MOV_R_mem( EAX, fbp->u.static_address);
	     CB(PUSHDX);
	  }
	else
	  {
     	     MOV_R_mem(EAX, &fbp->u.static_value );
	  }
	break;

      case 0xB3:	// putstatic
      case 0xD3:	// putstatic_quick
        fbp=GetBlock(NULL,0,code,&j,klass,cinfo,code==0xD3);
        if (!fbp)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	     return -1;	// error
	  }
#ifdef EXT_ERR
	if  (fbp->access & ACC_VALKNOWN)
	  {
	     CB(PUSHLONG);
	     CL(exDetail);	// FIXME: build string something like  
	     			// 	  "[class_name]: field [field_name] is final"
	     CB(MOV_AX);
	     CL(CreateIAException);
	     CW(CALL_EAX);
	     CompTriggerAthrowException(cinfo);	     //runtime IllAccess Exception
	     break;
	  }
#endif
#ifdef EXT_COMPAT
	if (!QUICK_OP(code) &&  !(unhand(fbp->clazz)->flags & DEF_CCF_IsInitialized) )	  
	{
	   CB(PUSHAX);
	   CB(MOV_AX);
	   CL(DEF_InitClass);	   
	   CB(PUSHLONG);
	   CL(fbp->clazz);
	   CW(CALL_EAX);
	   CB(POPCX);
	   CB(POPAX);
	}
#endif	
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	{
	     MOV_mem_R( fbp->u.static_address, EAX );
	     CB(POPAX);		// second half value on stacktop	     
	     MOV_mem_R( fbp->u.static_address+4, EAX );
	}
        else
	{
	     MOV_mem_R( &fbp->u.static_value, EAX );    
	}
	CB(POPAX);
	break;

      case 0xB4:	// getfield
      case 0xE3:	// getfield_quick_w
        fbp=GetBlock(NULL,0,code,&j,klass,cinfo,code==0xE3);
        if (!fbp)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	     return -1;
	  }
#ifdef EXT_ERR
	if (fbp->access & ACC_STATIC) {
	  char buf[256];
	  int len;
	  classname2string(cbName(fieldclass(fbp)), 
			   buf, sizeof(buf));
	  len = strlen(buf);
	  /* If buffer overflow, quietly truncate */
	  (void) jio_snprintf(buf + len, sizeof(buf)-len,
			      ": field %s did not used to be static",
			      fbp->name);
	  //	  dprintf(stderr, "triggering incompatible class exception\n");
	  // message pointer in EAX
	  CompTriggerIncompatibleClassChangeError(cinfo);
	}
#endif
	CompTriggerNullPointerException(cinfo,EAX);
	CW(MOV_BX_MAX);		// points to first instance variable
	m = fbp->u.offset;
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	{
#ifdef COMBINEOP
	   n= *(cinfo->bptr+j);		// nextcode
	   if (NEXT_LOADS_QWORD(n) && *fbp->signature==SIGNATURE_DOUBLE && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
	   {
	      SET_OPTFLAG(DF_DD);
	      CW(FLD_M_BX_32);	// fld qword ptr [ebx+xxxxxxxx]
	      CL(m);
	      if (NEXT_LOADS_2_QWORDS(n))
		SET_OPTFLAG(DF_DDextra);
	      else
		{
		   CB(PUSHAX);
		   CB(PUSHAX);
		}
	   }
	   else
#endif
	   {
	      MOV_R_Rmemoffs_(EDX, EBX, m+4);
	      MOV_R_Rmemoffs_(EAX, EBX, m);
	      CB(PUSHDX);
	   }
	}
	else
	{
	   MOV_R_Rmemoffs_(EAX, EBX, m);
	}
	break;

      case 0xB5:	// putfield
      case 0xE4:	// putfield_quick    (=value in eax)
        fbp=GetBlock(NULL,0,code,&j,klass,cinfo,code==0xE4);
        if (!fbp)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	     return -1;
	  }
#ifdef EXT_ERR
	if (*cinfo->mb->fb.name!='<') // not init constr
	  if (fbp->access & ACC_FINAL)
	  {
	     CB(PUSHLONG);
	     CL(exDetail);	// FIXME: build string something like  
	     			// 	  "[class_name]: field [field_name] is final"
	     CB(MOV_AX);
	     CL(CreateIAException);
	     CW(CALL_EAX);
	     CompTriggerAthrowException(cinfo);	     
	     break;
	  }
#endif	
	m = fbp->u.offset;
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	{
#ifdef COMBINEOP
	   if (GET_OPTFLAG(DF_DD))
	     CB(POPAX);
#endif
  	   CB(POPDX);
	   CB(POPBX);		// =object
	   CompTriggerNullPointerException(cinfo,EBX);
	   CW(MOV_BX_MBX);	// first instance variable adress
#ifdef COMBINEOP	   
	   if (GET_OPTFLAG(DF_DD) && *fbp->signature==SIGNATURE_DOUBLE)
	     {
		CW(FSTP_M_BX_32); // fstp qword ptr[ebx+xxxxxxx]

		CL(m);
	     }
	   else
#endif	     
	     {
		MOV_Rmemoffs__R( EBX, m+4, EDX);
		MOV_Rmemoffs__R( EBX, m, EAX);
	     }
	}
	else
	{
	   CB(POPBX);	// =object
	   CompTriggerNullPointerException(cinfo,EBX);
	   CW(MOV_BX_MBX);
	   MOV_Rmemoffs__R( EBX, m, EAX);
	}
	CB(POPAX);
	break;

      case 0xDC: 	// undocumented_invoke (?) (some kind of invoke_non_virtual)
	j+=2;		// "handled" by ignoring ;-)
	CB(POPAX);	// discard "this"-argument
	//dprintf(stderr,"0x DC short cut %x\n",code);
	break;

#define STATIC_INV(opcode)	( (opcode) == 0xB8 || (opcode) == 0xD9 )

#define VIRTUAL_INV(opcode)	( (opcode) == 0xB6 || (opcode) == 0xE2 )
#define INTERFACE_INV(opcode)	( (opcode) == 0xB9 || (opcode) == 0xDA )
#define NONVIRT_INV(opcode)	( (opcode) == 0xB7 || (opcode) == 0xD7 )
      case 0xb8:	// invokestatic
      case 0xD9:	// invokestatic_quick
	
      case 0xB7:	// invoke_non_virtual
      case 0xD7:	// invokenonvirtual_quick
	
      case 0xB9:	// invokeinterface
      case 0xDA:	// invokeinterface_quick
	
      case 0xB6:	// invokevirtual
      case 0xE2:	// invokevirtual_quick_w

	cinfo->mb->CompiledCodeFlags &= (~CCF_RESERVED);
   	tmp=cinfo->cptr;
      	CB(PUSHAX); 	// put logical stacktop to CPU-stack for the common caller stackframe
	compileJVMinvoke=FALSE;
	compileNOJFRset=FALSE;	// == TRUE means short way/no frame
	compileLOCALspace=-1;	// == "unknown at compile time"
	//
	// ======== 1. get a first method block [or alias] =================
	// (but could be invalid for virtual and interface methods)
	//
	mbp=GetBlock( VIRTUAL_INV(code) ? &k : NULL ,
		         STATIC_INV(code) ? 0: 2
		     ,code,&j,klass,cinfo, QUICK_OP(code));
	if (!mbp)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	    #if RESOLVE_FT>=3
	     CompTriggerLinkageError(cinfo);
	     if ( INTERFACE_INV(code) ) 
	       j++;
	     break;
	    #else	     
	     return -1;	// error
	    #endif	     
	  }
	//
	// ======== 2. get args_on_stack count =============================
	//
	if ( INTERFACE_INV(code) )
	  {
	     op1=*(cinfo->bptr+j++);
	     stac=op1*SIS4;
             if (code== 0xDA)
	       {
	          op3=*(cinfo->bptr+j++);
	          if (op3)
		   fprintf(stderr,"TYA: 0xDA invokeinterface_quick  !!!!! not yet debugged  (op3 =%x)\n",op3);
	       }
	     
	       else
	     j++;		// for the one reserved byte
	  }
	else
	  {
	     stac=Signature2ArgsSize(mbp->fb.signature) * SIS4;
	     if ( !STATIC_INV(code) )
	      stac+=SIS4;	// one for "this"
	  }
	//
	// 3. ========== if non static then get object from stack =============
	//
	if ( !STATIC_INV(code) )
	  if (*mbp->fb.name!='<')
          {   
	    // except for constructors....
	    // ...get object from stack for testing to be !NULL
	    // ...and for later access if INTERFACE_INV or VIRTUAL_INV
	    if (stac!=4)	// if stac == 4 then it is already in eax
	    {
	      CW(MOV_BX_SP);
	      if (stac<128)
              { 
		CW(MOV_AX_MBX_8);
	        CB((unsigned char)(stac - SIS4));
	      }
 	      else
	      {
		CW(MOV_AX_MBX_32);
	        CL(stac - SIS4);
	      }
	    }
#ifdef EXCEPTIONS_BY_SIGNALS	     
	    if ( INTERFACE_INV(code) || VIRTUAL_INV(code) )
	      ; // exception would be thrown by MOV_BX_MAX_8 below, so we don't care
	    else
#endif	     
	      CompTriggerNullPointerException2(cinfo, EAX);
	      // this test is independent of EXCEPTIONS_BY_SIGNALS
	 }
	//
	// 3A. =================== mbp is known, so try to inline ===================
	//
	if ( STATIC_INV(code)  ||  NONVIRT_INV(code)
	    || (mbp->fb.access & ACC_FINAL)  
	    || (mbp->fb.access & ACC_PRIVATE)
 	    || (unha11(mbp->fb.clazz)->access  & ACC_FINAL)
	    )
	  {
#ifdef EXT_COMPAT
	if (STATIC_INV(code) ||  NONVIRT_INV(code))
	if (!QUICK_OP(code) &&  !(unhand(mbp->fb.clazz)->flags & DEF_CCF_IsInitialized) )
	{
	   CB(MOV_AX);
	   CL(DEF_InitClass);	   
	   CB(PUSHLONG);
	   CL(mbp->fb.clazz);
	   CW(CALL_EAX);
	   CB(POPCX);
	}
#endif
#ifndef JDK12
	   if (classJavaLangObject==mbp->fb.clazz && mbp->fb.ID==jLOinitID)
	   {
	      cinfo->cptr=tmp;		// ...consider the VERBOSE_ASM86 output is not reset
	      CB(POPAX);		// ...this could cause some debug difficulties
	      break;
	   }
#else
	     
	     if (! (mbp->fb.access & ACC_NATIVE))
	      if (*mbp->code == VRETURN &&  !strcmp(mbp->fb.signature,"()V"))
		 {
#if 0		    // Sun Sep 26 10:34:54 1999 #282
		    cinfo->cptr=tmp;	// reset at start opcoding...
		    // ...consider the VERBOSE_ASM86 output is not reset
		    // ...this could cause some debug difficulties
#else
		    CB(POPAX);		// (we have pushed above!)
#endif		    
		    if (stac) 		// i.e. nonstatics
		     CB(POPAX);		// pop parameter "this"
		    break;
		 }
	      
#endif
#ifdef INLINE_FPARITM
#undef FAST_FPARITH	     
	     if (mbp->fb.access & ACC_NATIVE)
	      if (!strcmp(unha11(mbp->fb.clazz)->name,"java/lang/Math"))
	       if (CompInlineFP(cinfo,mbp))
		 break;
	     
#endif
#ifdef FAST_FPARITH
	     if (mbp->fb.access & ACC_NATIVE)
	       if (!strcmp(unha11(mbp->fb.clazz)->name,"java/lang/Math"))
		 if (CompFastCallFP(cinfo,mbp,stac,*(cinfo->bptr+j) /*nextcode*/))
		   break;
#endif	     
#ifdef INLINING
	   if (mbp->CompiledCodeFlags & CCF_INLINEOK)	// inline allowed ?
             if (!cinfo->isinline)			// no recursive inlining
	       if (!cinfo->inlineerr)			// don't do it in a 2nd try
	   {
             struct CINFO c2;
             int j,erg;
	     if (mbp->nlocals+mbp->args_size==2)
		{
		 	CW(MOV_MBP_8_SI);
		   	CB( LOCSTART-12);
			CW(MOV_MBP_8_DI);
			CB( LOCSTART-8 );
		}
	      else
	      if (mbp->nlocals+mbp->args_size==1)
		{
			CW(MOV_MBP_8_DI);
			CB( LOCSTART-8 );
		}
	      
	     if (stac==4)
	       CB(POPDI);
	     else   
	       if (stac==8)
               { 
		 CB(POPSI);
		 CB(POPDI); 
	       }
	     CB(POPAX);
             c2=*cinfo;
             c2.wide=0;
             c2.bptr=(unsigned char*)mbp->code;
             c2.mb=mbp;
	     c2.iptab=alloca(sizeof(struct iptrans) * (mbp->code_length+1));
	     memset(c2.iptab,0,sizeof(struct iptrans) * (mbp->code_length+1));

	     c2.backp=alloca(sizeof(struct back) * (mbp->code_length+1));
	     if (!c2.iptab || !c2.backp)
		{
#ifdef VERBOSE2
		   lprintf("TYA: inline coding: memory problem\n");
#endif
		   return -1;
		}
	     //
	     c2.ipcnt=0;
	     c2.backcnt=0;
             c2.isinline=mbp->code_length;
	     #ifdef VERBOSE_ASM86
	        lprintf("--now INLINING method: %s.%s\n",unha11(mbp->fb.clazz)->name,mbp->fb.name);
	     #endif
             for (j=0;j<mbp->code_length ;)
             {
                erg=recode(j,unha11(mbp->fb.clazz),&c2);
		if (erg<0)
		  {
		     if (erg==NOSPACE_ERROR)
		       {
			 #if 0
			 lprintf("TYA: no space in inline coding\n");
			 #endif
		       }
		     else
		       {
			  lprintf("TYA: inline coding aborted %d\n",erg);
			  mbp->CompiledCodeFlags &= (~CCF_INLINEOK);	// don't try twice
			  erg=INLINE_ERROR;
		       }
	            //lprintf("TYA:  method: %s.%s\n",unha11(mbp->fb.clazz)->name,mbp->fb.name);
		    //lprintf("TYA:  inlined in: %s.%s\n",unha11(cinfo->mb->fb.clazz)->name,cinfo->mb->fb.name);
		    cinfo->cptr=tmp;
		    cinfo->ipcnt--;
		    return erg;
		  }
                j+=erg;
                // no exceptions to handle
             }
	     //
	     // next "+1" is to handle intermediate return as jumps to the end
	     c2.iptab[c2.ipcnt].java=mbp->code+mbp->code_length;
	     c2.iptab[c2.ipcnt].x86=c2.cptr;
	     c2.ipcnt++;
	     BackPatchJumpDists(&c2);
	     dprintf(stderr,"inline end: %d\n",c2.ipcnt-1);
	     #ifdef VERBOSE_ASM86
	        lprintf("--end INLINING method: %s.%s\n",unha11(mbp->fb.clazz)->name,mbp->fb.name);
	     #endif	      
	     //
	     // continue "suspended" method
	     cinfo->cptr=c2.cptr;
	     if (mbp->nlocals+mbp->args_size==2)
		{
		    CW(MOV_SI_MBP_8);
		    CB(   LOCSTART-12);
		    CW(MOV_DI_MBP_8);
		    CB(   LOCSTART-8 );
		}
	      else
	      if (mbp->nlocals+mbp->args_size==1)
		{
		    CW(MOV_DI_MBP_8);
		    CB(   LOCSTART-8 );
		}
             break;
           }
#endif
	//
	// 4. =================== get a usable method block  ===================
	//
	   if (mbp->fb.access & ACC_NATIVE)
	       compileJVMinvoke=TRUE;
	   // "runtime" mbp known during compilation, but no inlining
	   compileLOCALspace=mbp->nlocals*SIS4;
///#ifndef JDK12
	   if (!cinfo->mb->exception_table_length)
	     if (mbp->CompiledCode  && (mbp->CompiledCodeFlags & CCF_RESERVED))
	      compileNOJFRset=TRUE;
////#endif
	   CB(PUSH_SP);			// compare next chapter (5.)
#ifdef USEASM
	   CB(MOV_AX);
	   CL(mbp);
	   CB(PUSHAX);
#else	     
	   CB(PUSHLONG);
	   CL(mbp);
#endif
	}
	else  // this is (INTERFACE_INV(code)  || ( VIRTUAL_INV(code)
  	{
	     CW(MOV_BX_MAX_8);
	     CB(4);			// &object->methodtabelle
	   
	     if ( VIRTUAL_INV(code) )
	       {
		  if (k< 12)		// care for _array_ methods
		    {
		       CW(TEST_BX);
		       CL(FLAG_MASK);	// ebx is T_NORMAL_OBJECT ?
		       CB(JE);
		       CB(7);
		       CB(MOV_AX);	// object class for ARRAY
		       CL(mbp);
		       CB(JMPS);
		       if ( (k+1)*SIS4>127 )
			 CB(6);
		       else
			 CB(k?3:5);
		    }
		  // (ebx contains object)
		  // the next is in C: { eax:=(obj_array_classblock(hobj))->methodtable->methods[nr] }	   
		  if (k)
		    {  
		       if ( (k+1)*SIS4>127 )
			 {			 
			CW(MOV_AX_MBX_32);
			CL((k+1)*SIS4);		// k method #
			 }
		       else
			 {
			CW(MOV_AX_MBX_8);
			CB((k+1)*SIS4);
			 }
		    }
		  #ifndef NOGUA_WORKAROUND
		  else
		    {
			CB(MOV_AX);
			CL(mbp);
			lprintf("TYA: GUA_WORKAROUND in action\n");
		    }
		  #endif
	       }
	     else
	       {
		  i=GetMethNr(mbp);
#ifdef USEASM
		  CW(MOV_AX_MBX);
		  CW(MOV_AX_MAX);
		  CW(MOV_AX_MAX_8);
		  k=(char*)(&klass->imethodtable) - (char*)klass;
		  CB( k );		// (currently imethodtable offset is 96)
		  CW(LEA_DX_AX_8);
		  CB(-4);
		  CW(ADD_DX_BYTE);
		  CB(8);
#ifdef EXT_ERR
		  CW(MOV_AX_MDX);
		  CW(TEST_AXAX);
		  CB(JNE);
		  CB(SIZEOFJMP86);
		  // currently no error message 
		  CompTriggerIncompatibleClassChangeError(cinfo);	//=SIZEOFJMP86
		  CB(CMP_AX);
		  CL(mbp->fb.clazz);
		  CB(JNE); 
		  CB(-12 -4-SIZEOFJMP86 );	// jmp loop
#else		  
		  CW(CMP_MDX_LONG);
		  CL(mbp->fb.clazz);
		  CB(JNE); 
		  CB(-11);		// jmp loop
#endif		  
		  CW(MOV_DX_MDX_8);
		  CB(4);
		  MOV_R_Rmemoffs_(EAX, EDX, i * sizeof(int) )
		  CL(0x0483448B);	// mov eax, 0x4( ebx, eax,4)
#else		  
		  if (i<128)
		    {
			 CB(PUSHLONG2);
			 CB(i);		       
		    }
		  else
		    {
			 CB(PUSHLONG);
			 CL(i);
		    }
		  CB(PUSHLONG);
		  CL((mbp->fb.clazz));
		  CB(PUSHAX);
		  CB(MOV_BX);
		  CL(RTGetIMeth);
		  CL(CALL_ADDSP);
		  CB(12);
		  CW(TEST_AXAX);
		  CB(JNE);
		  CB(SIZEOFJMP86);
		  CompTriggerIncompatibleClassChangeError(cinfo);
#endif		  
	       }
	     CB(PUSH_SP);		// compare next chapter (5.)
	     CB(PUSHAX);		// ebx == RT mbp_called
	}
	//
	// 5. ============ prepare invocation ====================
	//
	// Stack layout at runtime as follows:
	//  x. <--(here possibly method's args)
	//  3. <--(here possibly object reference)
	//  2. args pointer ==SP
	//  1. mb called
	//  0. EE		// this 3 stackplaces are later temp used
	//    (EE will be pushed in next step)
	// prepare call of:
	//   XY(ExecEnv *ee,struct methodblock *mb1,va_list args);
	//   ... where XY can be: FastInvCheck() or CodeRunner()
#ifdef TRY_FAST_INVOKE
	if (compileJVMinvoke)
#endif			  
	{
	  CW(MOV_BX_MBP_8);	// get EE into ebx
	  CB(LOCSTART-16);	// needed both fast invoke and native invoke
 	  CB(MOV_AX);
	  if (mbp->CompiledCodeFlags & CCF_R64)
	   CL(CodeRunner64);
	  else
	   CL(CodeRunner32);	   
	  CB(PUSHBX);		// EE in ebx
	//
	// 6A. ======== common JVM NMI invocation =========================
	// (using a wrapper for convenience)

	  CW(CALL_EAX);
	}
#ifdef TRY_FAST_INVOKE						       
	else
	{
	  CW(MOV_CX_MBP_8);	// get EE into ebx
	  CB(LOCSTART-16);	// needed both fast invoke and native invoke
	//
	// 6B. =============== fast invocation ============================
	// (call directly address returned by FastInvCheck
	//	   
	  if (compileNOJFRset)
	    CB(PUSHCX);		// EE in ecx
	  else
          {
	    CB(MOV_BX);
	    if ( compileLOCALspace!=-1 && mbp->CompiledCode)
	    {
	      // the asm versions of FastInv* preserve ecx 
	      CL(FastInvPrepare);
	      // returns ptr_to_code in eax, loc_var_stack_space in edx and keeps ecx!
	      // 32 bit or 64 bit: no difference
	    }
	    else
  	    {
	     if (mbp->CompiledCodeFlags & CCF_R64)
	       CL(FastInvCheck64);
	     else
	       CL(FastInvCheck32);
  	    }
	    CB(PUSHCX);		// EE in ecx
	    CW(CALL_EBX);
          }
	  if ( compileLOCALspace!=-1 && mbp->CompiledCode)
	  {
	    CB(MOV_AX);
	    CL(mbp->CompiledCode);
	    if (compileLOCALspace<128)
	    {
	      CW(SUB_SP_BYTE);
	      CB(compileLOCALspace);
	    }
	    else
	    {	     
	      CW(SUB_SP_LONG);
	      CL(compileLOCALspace);
	    }
	  }
	  else
	  {
	    CW(SUB_SPDX);	// get stack space: value returned by FastInvCheck*	    
	    CW(MOV_MBP_8_DX); 	// use helper place storing stack space
	    CB(LOCSTART-4);
	  //---
	  }
	    
#ifndef USEASM	    
	  CW(MOV_BX_MBP_8);	// get EE again
	  CB(LOCSTART-16);
	  CB(PUSHBX);		// EE
	  if (!compileNOJFRset)
	  {
	     // next is needed for common caller interface with "USEASM" part
	     CW(MOV_BX_MBX_8);
	     CB(CFR_OFF);	// mov ebx,&ee->current_frame
	     CB(CMP_AX);
	     CL(CodeRunner32_withDummies);
	     CB(JE);		// no prev
	     CB(10);
	     CB(CMP_AX);
	     CL(CodeRunner64_withDummies);
	     CB(JE);		// ditto
	     CB(3);
	     CW(MOV_BX_MBX_8);	// mov ecx,ee->current_frame->prev
	     CB(16);		// the frame to set when method returns
	  }
#else
	  CB(PUSHCX);		// ee in ecx [ from FastInvCheck() ]
#endif
	  CW(CALL_EAX);		// expecting 32bit result in eax, 64bit in edx:eax
	  //	    
	  CB(POPCX);		// ee
	  if ( compileLOCALspace!=-1 && mbp->CompiledCode)
		stac+=compileLOCALspace;
	  else
	  {
	     CW(ADD_SP_MBP_8);	// add local variable part
	     CB(LOCSTART-4);
	  }
	  if (!compileNOJFRset)
	  {
	     // in C you would write:  (with pointer to ExecEnv in ebx)
	     // { ee->current_frame=ee->current_frame->prev; }	     
	     CW(MOV_MCX_8_BX);	// frame->prev in ebx
	     CB(CFR_OFF);
	  }
	  // keep EE in ecx for CompTriggerExceptionFromInvoked() !
	}
#endif	// TRY_FAST_INVOKE
	// 7. ==== release used stack space, store results, check exceptions ===========
	// label:		// we are expecting EE in ebx
	//			// keep it for CompTriggerExceptionFromInvoked() !	   
#ifdef TRY_FAST_INVOKE
  	CompTriggerExceptionFromInvoked(cinfo,compileJVMinvoke?EBX:ECX);
#else
	CompTriggerExceptionFromInvoked(cinfo,EBX);
#endif
         stac+=12;
	  if (stac<128)
	  {
	    CW(ADD_SP_BYTE);	// add arguments stack part
	    CB(stac);
	  }
	  else
	  {	     
	    CW(ADD_SP_LONG);	// add arguments stack part
	    CL(stac);
	  }
	if (mbp->CompiledCodeFlags & CCF_R64)
	  CB(PUSHDX);
	if (mbp->CompiledCodeFlags & CCF_VOID)
	  CB(POPAX);
#ifdef DEBUG
	 /* this is an example how to get some information what's on stack during runtime */
	 CB(PUSHAX);			       
     	 CB(MOV_BX);
	 CL(debughelper);
	 CW(CALL_EBX);
	 CB(POPAX);
#endif
	 break;
      case 0xBB:	// new
      case 0xDD:	// new_quick
	cinfo->mb->CompiledCodeFlags &= (~CCF_RESERVED);
        clazz=GetBlock(NULL,1,code,&j,klass,cinfo,code==0xDD);
	if (!clazz)
	  {
#ifdef VERBOSE2
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	    #if RESOLVE_FT>=3
	     CompTriggerLinkageError(cinfo);
	     break;
	    #else	     
	     return -1;	// error
	    #endif	     
	  }
#ifdef EXT_ERR	  
	if (cbAccess(clazz) & (ACC_INTERFACE | ACC_ABSTRACT))
	  CompTriggerLinkageError(cinfo);
#endif
	dprintf(stderr,"NEW  class = %p %s\n",unha11(clazz), unha11(clazz)->name);
#ifdef INIT0
	CB(PUSHAX);	// eax is not a parameter here
#ifndef USEASM	   
	CB(PUSHLONG);
#else
	CB(MOV_AX);
#endif	   
	CL(clazz);
	CB(MOV_BX);
	CL(MyObjAlloc);// result in eax
	CW(CALL_EBX);
#ifndef USEASM				
	CB(POPCX);
#endif
#else
	CB(PUSHAX);	// eax is not a real parameter here
	CB(PUSHLONG);
	CL(clazz);
	CB(MOV_BX);
	CL(ObjAlloc);	// result in eax
	CW(CALL_EBX);
	CB(POPCX);
#endif	
#ifdef EXT_ERR	   
	CompTriggerOutOfMemoryException(cinfo);
#endif	   
	break;
	
      case 0xbc:	// newarray  array size on stacktop in eax
	cinfo->mb->CompiledCodeFlags &= (~CCF_RESERVED);
	op1=*(cinfo->bptr+j++);
	dprintf(stderr,"NEWARRAY op1 =%02x\n",op1);	// 11=long, etc.
	CompTriggerNegArraySizeException(cinfo);
	CB(MOV_BX);
	CL(MyArrayAlloc);	   
	CB(PUSHAX);
	CB(PUSHLONG2);	// type
	CB(op1);	// 4..11
	// HObject *MyArrayAlloc(int type,int len);
	CW(CALL_EBX);// result in eax
	CB(POPCX);
	CB(POPDX);
#ifdef EXT_ERR	   
	CompTriggerOutOfMemoryException(cinfo);
#endif	   
	break;
	
      case 0xBD:	// anewarray
      case 0xDE:	// newarray_quick	array size on stacktop in eax
	cinfo->mb->CompiledCodeFlags &= (~CCF_RESERVED);
	wop=getint16U(&j,cinfo);
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
  	{
#ifdef VERBOSE2
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	dprintf(stderr,"ANEWARRAY wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);

#ifdef EXT_COMPAT
	if (!QUICK_OP(code) && !(unhand(clazz)->flags & DEF_CCF_IsInitialized) )
	{
	   CB(PUSHAX);
	   CB(PUSHLONG);
	   CL(clazz);
	   CB(MOV_AX);
	   CL(DEF_InitClass);
	   CW(CALL_EAX);
	   CB(POPAX);
	   CB(POPAX);
	}
#endif	   
	CompTriggerNegArraySizeException(cinfo);
	CB(MOV_BX);
	CL(MyArrayAlloc);	   
	CB(PUSHAX);
	CB(PUSHLONG2);
	CB(T_CLASS);	// type
	// HObject *MyArrayAlloc(int type,int len);
	CW(CALL_EBX);
	CB(POPCX);
	CB(POPDX);	// len
#ifdef EXT_ERR	   
	CompTriggerOutOfMemoryException(cinfo);
#endif	   
	CW(MOV_BX_MAX);
	CB(MOV_CX);
	CL(clazz);
	// mov [ebx + 4*edx], ecx
	MOV_Rsib_R( SIB(SIB_SCALE4, EDX,EBX ), ECX );
	   

	break;

      case 0xbe:	// arraylength
	CompTriggerNullPointerException(cinfo,EAX);	// ==array object
	CW(MOV_AX_MAX_8);
        CB(4);
	CW(SHR_AX);
	CB( METHOD_FLAG_BITS );	// ==new value on stacktop
	break;

      case 0xBF:	// athrow
 	// this test is independent of EXCEPTIONS_BY_SIGNALS
	CompTriggerNullPointerException2(cinfo,EAX);
	CompTriggerAthrowException(cinfo);
	dprintf(stderr,"athrow athrow athrow\n");
	break;
  
      case 0xC0:	// checkcast
      case 0xE0:	// checkcast_quick
	wop=getint16U(&j,cinfo);
    	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	{
#ifdef VERBOSE2
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	dprintf(stderr,"CHECKCAST wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);
#ifdef GATHER_STATS
	if ( unha11(clazz)->access & ACC_INTERFACE )
	{
	  INC_mem(&stats_checkcast_interface);
	}
#endif
#if 1	   
	CW(TEST_AXAX);		// obj null -> result= 0    [Dalheimer S 129]
#define THROW_CCAST_EX 9
	CB(JE);
	CB(21+THROW_CCAST_EX);		// jmp to ready
#endif	   
	// #1
	PUSH_Roffs8(EBP, LOCSTART-16);	// push EE on stack
   	// #2
	CB(PUSHLONG);
	CL(clazz);
	// #3
	CB(PUSHAX);
	CB(MOV_BX);
	CL(is_instance_of);		//(h,clazz,ee);
	CW(CALL_EBX);
	CW(MOV_BXAX);			// chk result
	CB(POPAX);			// restore our stacktop in eax
	CB(POPCX);
	CB(POPDX);	   
	CompTriggerClassCastException(cinfo);
	// label:
	break;

      case 0xC1:	// instanceof
      case 0xE1:	// instanceof_quick
	wop=getint16U(&j,cinfo);
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
  	{
#ifdef VERBOSE2
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	CW(TEST_AXAX);	// eax obj null -> res= 0    [Dalheimer S 129]   
	CB(JE);
	CB(19);		// jmp to label1: return false
	dprintf(stderr,"INSTANCEOF wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);
	// #1
	PUSH_Roffs8(EBP, LOCSTART-16);	// push EE on stack
   	// #2
	CB(PUSHLONG);	
	CL(clazz);
	// #3
	CB(PUSHAX);
	CB(MOV_BX);
	CL(is_instance_of);		//(h,clazz,ee);
	CW(CALL_EBX);
	CB(POPCX);
	CB(POPDX);
	CB(POPBX);
	// label1:
	break;

// If we ever write own monitorEnter/Exit we could pass directly EAX instead of
// stack
      case 0xC2:
	CompTriggerNullPointerException2(cinfo,EAX);
      	CB(PUSHAX);
	CB(MOV_BX);
	CL(monitorEnter);
	CW(CALL_EBX);
	CB(POPBX);
	CB(POPAX);
	break;

      case 0xC3:
	CompTriggerNullPointerException2(cinfo,EAX);
      	CB(PUSHAX);
	CB(MOV_BX);
	CL(monitorExit);
	CW(CALL_EBX);
	CB(POPBX);
	CB(POPAX);
	break;

      case 0xC4:	// wide 	(have seen it yet only together with iinc)
 	cinfo->wide=1;
        dprintf(stderr,"wide prefix =%02x\n",cinfo->wide);
	break;

      case 0xC5:	// multiarrayalloc
	cinfo->mb->CompiledCodeFlags &= (~CCF_RESERVED);
	wop=getint16U(&j,cinfo);
	m=*(signed char*)(cinfo->bptr+j++);
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
  	{
#ifdef VERBOSE2
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
#endif
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
#ifdef EXT_COMPAT
	if (!(unhand(clazz)->flags & DEF_CCF_IsInitialized) )
	{
	   CB(PUSHAX);
	   CB(PUSHLONG);
	   CL(clazz);
	   CB(MOV_AX);
	   CL(DEF_InitClass);
	   CW(CALL_EAX);
	   CB(POPAX);
	   CB(POPAX);
	}
#endif	   
	dprintf(stderr,"MULT ARR AL wop =%d dim=%d %s\n",wop,m,unha11(clazz)->name);
	switch (m)	// reverse buffer
	     {
	      case 1:CB(PUSHAX);break;
	      case 2:CB(POPBX);CB(PUSHAX);CB(PUSHBX);break;
	      case 3:CB(POPBX);CB(POPCX);CB(PUSHAX);CB(PUSHBX);CB(PUSHCX);break;
	      case 4:CB(POPBX);CB(POPCX);CB(POPDX);
		     CB(PUSHAX);CB(PUSHBX);CB(PUSHCX);CB(PUSHDX);break;
	      default:lprintf("TYA: Too much dimensions: %d in opcode %x\n",m,code);
	   	    return -1;
		    // no problem: this method should run interpreted
	     }
	//
	// calling MultiArrayAlloc(int dimensions, ClassClass *, stack_item *sizes)
	//				#3		#2		#1
	// #buffer of sizes 
	// #1	   
	CB(PUSH_SP);
	// #2
	CB(PUSHLONG);
	CL(clazz);
	// #3
	CB(PUSHLONG2);
	CB(m);
	CB(MOV_BX);
	CL(MultiArrayAlloc);	// FIXME: some init with 0 ?
	CL(CALL_ADDSP);
	CB(12+ m*SIS4);
	CompTriggerOutOfMemoryException(cinfo);
	break;

      case 0xC8:	// goto_w
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	m=getint32(&j,cinfo);   
	iprintf("TYA: goto_w!!!!! not yet debugged   (jumping %d java byte)\n",m);
	CB(JMP1);
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0);		// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;

      case 0xC9:	// jsr_w
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	m=getint32(&j,cinfo);
	iprintf("TYA: jsr_w!!!!! not yet debugged   (jumping %d java byte)\n",m);
	CB(PUSHAX);
	CB(CALL);
	CL(0);
	CB(POPAX); //1
	CW(ADDAX); //3 	stacktop now is "next_java_instruction"
	CB(9);	   //4
	CB(JMP1);  //5
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt-1;
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0);     //9	 backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;
      case 0xCA:	// debugbreak;
	CB(DEBUGBREAK);
	break;
      case 0xD1:	// ret_w
   	op1=getint16U(&j,cinfo);
	iprintf("TYA: ret_w  !!!!! not yet debugged  (op1 =%x)\n",op1);
	if (Comp_PUSH_LocalVarToStack(op1,cinfo))	// bypassing eax-stacktop
	   CB(PUSHBX);
	CB(RETN);
	break;
      default:
	{
	   char *msg=alloca(32);
	   sprintf(msg,"TYA: unimplemented opcode=%02x\n",code);
	   lprintf(msg);panic(msg);
	}
     }
   return j-jj;		// bytes read
}
