/*
	**
	** traffic-tohtml.c
	**
	** Main module for report html generation for traffic-vis
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: traffic-tohtml.c,v 1.4 1999/04/07 23:07:09 dmiller Exp $
	**
 */

#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <sys/types.h>

#include "util.h"
#include "report.h"
#include "read-report.h"
#include "sort-report.h"
#include "htmlfe.h"

static char			rcsid[] = "$Id: traffic-tohtml.c,v 1.4 1999/04/07 23:07:09 dmiller Exp $";

#ifdef HAVE_GETOPT_LONG
/* Commandline options */
static struct option long_options[] =
{
	{"input", 1, NULL, 'i'},
	{"output", 1, NULL, 'o'},
	{"version", 0, NULL, 'V'},
	{"help", 0, NULL, 'h'},
	{NULL, 0, NULL, 0}
};
#endif /* HAVE_GETOPT_LONG */

/* Prototypes */
void usage(void);
void version(void);
int main(int argc, char **argv);

void usage(void)
{
	fprintf(stderr, "Usage: traffic-tohtml [OPTION]\n");

	fprintf(stderr, "\n");

	fprintf(stderr, "Filter which convers a network traffic summary created by traffic-collector\n");
	fprintf(stderr, "into a html report.\n");

	fprintf(stderr, "\n");

#ifdef HAVE_GETOPT_LONG
	fprintf(stderr, "  -i, --input  file    Read input from 'file' instead of stdin.\n");
	fprintf(stderr, "  -o, --output file    Write output to 'file' instead of stdout.\n");
	fprintf(stderr, "  -V, --version        Print program version.\n");
	fprintf(stderr, "  -h, --help           Display this help text.\n");
#else /* HAVE_GETOPT_LONG */
	fprintf(stderr, "  -i file  Read input from 'file' instead of stdin.\n");
	fprintf(stderr, "  -o file  Write output to 'file' instead of stdout.\n");
	fprintf(stderr, "  -V	    Print program version.\n");
	fprintf(stderr, "  -h	    Display this help text.\n");
#endif /* HAVE_GETOPT_LONG */

	fprintf(stderr, "\n");

	fprintf(stderr, "Please report bugs to dmiller@ilogic.com.au\n");
}

void version(void)
{
	fprintf(stderr, "traffic-tohtml %s\n", VERSION);
}

int main(int argc, char **argv)
{
	report_t			*r;

	int 				c;
	extern char 	*optarg;
	
	/* Commandline options */
	static char		*output_file = NULL;
	static char		*input_file = NULL;
	
	/* Fetch commandline options */
	while (1)
	{
#ifdef HAVE_GETOPT_LONG
		c = getopt_long (argc, argv, "o:i:hV?", long_options, NULL);
#else /* HAVE_GETOPT_LONG */
		c = getopt (argc, argv, "o:i:hV?");
#endif /* HAVE_GETOPT_LONG */
		if (c == -1)
			break;
		
		switch (c)
		{
			case 'i':
				input_file = util_strdup(optarg);
				break;
				
			case 'o':
				output_file = util_strdup(optarg);
				break;
				
			case 'V':
				version();
				exit(0);
				
			case 'h':
			case '?':
				usage();
				exit(0);
				
			default:
				fprintf(stderr, "Invalid commandline options.\n\n");
				usage();
				exit(-1);
		}
	}

	r = parse_report(input_file);
	
	html_display_summary(r, output_file);

	return(0);
}
