#ifndef S9X_ROM_H
#define S9X_ROM_H

#include "defines.h"
#include "frend.h"
#include "misc.h"

class s9x_ROMdata {
 private:
	bool		is_a_rom;
	char		Name[26];
	char		*FileName;
	long		FileSize;
	int		HiROM;
 public:
			s9x_ROMdata();
			~s9x_ROMdata();
	int		LoadROM(char*dir, char*file);
	bool		IsAROM();
	char*		GetName();
	char*		GetFile();
	long		GetSize();
	int		SetFile(char*dir, char*file);		
	bool		IsHiROM();
};

class s9x_ROMselector	: public fr_Window, private fr_Listener {
 private:
   int			CountFiles, Matched;
   fr_Label		RomIcon;
   fr_DataTable		ROMlist;
   fr_Box		InfoBox;
   fr_Label		LblFile, LblSize;
   fr_Label		InfFile, InfSize;
   fr_Button		BtnOK, BtnCancel;
   fr_ButtonBox		BtnBox;
   char			*InterfaceFile;
   void			LoadDirectory(char*dir);
   int			AddFile(char*dir, char*file);
   void			EventOccurred(fr_Event*e);
   void			RefreshContent();
   void			DeleteContent();
 public:
			s9x_ROMselector(fr_Element*parent);
   char*		GetSelectedFileName();
   void			RowSelected(int row);
   void			SetVisibility(bool v);
};

class s9x_ROM           : public s9x_Notepage {
 private:
   fr_Button		RomBtn;
   fr_File		File;
   fr_PulldownMenu	MemoryMap, Format;
   fr_Label		Bnr;
   s9x_ROMselector	Selector;
   void			EventOccurred(fr_Event*e);
 public:
                        s9x_ROM(fr_Element*parent);
   void			SetToDefaults();
   void			Set9xVersion(float version);
   void			SiftArgs(fr_ArgList& L);
   void			SetFileName(char*file);
   char*		GetFileName();
   void			FilePopup();
   void			CompileArgs(fr_ArgList& L);
};

#endif
