#!/bin/sh
##
## snes9express installation script
##

PROG=snes9express
WMCONFIG_DIR=/etc/X11/wmconfig
ICONS_DIR=/usr/share/icons

if [ "$1" = "--uninstall" ]; then
	if [ ! -r installed.files ]; then
		echo "$PROG not installed, or no installation log was made"
		exit 1
	fi
	for i in each `/bin/cat installed.files`; do
		echo "Removing $i ..."
		rm $i
	done
	echo "uninstallation complete."
	exit
fi

if [ "$1" != "--install" ]; then
	echo "this should only be run from \"make (un)install\". aborting"
	exit 1
fi

### Check if installation is possible
if [ ! -f $PROG ]; then
	echo "cannot install \"$PROG\", file doesn't exist"
	exit 1
fi

### Figure out where to make a log of files installed
##    Prefer ./installed.files  ( <-- required for RPM build )
##    Fall back on /tmp/snes9express.installed
unset INSTLOG
if [ ! -w . ]; then
	echo "Warning: you do not have write permission to this directory,"
	if [ -w /tmp ]; then
		INSTLOG="/tmp/snes9express.installed"
		echo "         an installation log will be made in $INSTLOG"
	else
		echo "         no installation log will be made"
	fi
else
	INSTLOG="./installed.files"
fi

### Create an empty installation log
if [ "$INSTLOG" != "" ]; then
	> $INSTLOG
fi

### Figure out where to install
##    Assume /usr/local/bin, or $HOME/bin in the case of a non-root user
##    the RPM installation script will override this with the install.dir file
if [ -f "install.dir" ]; then
	INSTDIR=`cat install.dir`
else
	INSTDIR="/usr/local/bin"
fi
if [ ! -w "$INSTDIR" ]; then
	INSTDIR="$HOME/bin"
fi
if [ ! -d "$INSTDIR" ]; then
	mkdir -p $INSTDIR
fi

echo "Installing $PROG to $INSTDIR"
cp -f $PROG $INSTDIR/$PROG
if [ ! -f "$INSTDIR/$PROG" ]; then
	echo "Error: $PROG could not be installed to $INSTDIR"
	exit 1
fi
chmod 755 $INSTDIR/$PROG
if [ "$INSTLOG" != "" ]; then
	echo "$INSTDIR/$PROG" >> $INSTLOG
fi

if [ -f wm.config ] && [ -w "$WMCONFIG_DIR/" ]; then
	cp wm.config $WMCONFIG_DIR/$PROG
	if [ "$INSTLOG" != "" ]; then
		echo "$WMCONFIG_DIR/$PROG" >> $INSTLOG
	fi
fi

if [ -f pix/logo.xpm ] && [ -w "$ICONS_DIR/" ]; then
	cp pix/logo.xpm $ICONS_DIR/$PROG.xpm
	if [ "$INSTLOG" != "" ]; then
		echo "$ICONS_DIR/$PROG.xpm" >> $INSTLOG
	fi
fi

echo "Installation summary ($INSTLOG):"
cat $INSTLOG
echo "snes9express installation complete."
echo "Type \"$PROG\" to run it."
