import gtk
import gobject
import sys
import re
import string
import time

#Skype4Py
import Skype4Py

REV="$Rev: 69 $"

class TransferCall:
	def __init__(self, skype_obj, friends):
		# Initialize vars
		self.calllist = {}
		self.call_ls = gtk.ListStore(str, object)
		self.friends = friends

		self.skype = skype_obj
		self.skype.RegisterEventHandler('CallStatus', self.CallStatus)
		self.skype.RegisterEventHandler('CallTransferStatusChanged',
			self.CallTransfer)

		for call in self.skype.ActiveCalls:
			self.calllist[call] = self.call_ls.append([
				call.PartnerDisplayName,
				call])

	def CallStatus(self, call, value):
		gtk.gdk.threads_enter()
		if value == "INPROGRESS":
			if not call in self.calllist.keys():
				self.calllist[call] = self.call_ls.append([
					call.PartnerDisplayName,
					call])
		else:
			if call in self.calllist.keys():
				self.call_ls.remove(self.calllist[call])
				del self.calllist[call]

		gtk.gdk.threads_leave()

	def CallTransfer(self, call, value):
		self.l_status.set_text(value)
		
	def transfer(self, widget):
		calliter = self.calls.get_active_iter()
		if not calliter:
			return 

		iter = self.entry.get_active_iter()
		if iter:
			transferto = self.entry_ls.get_value(iter, 1)
		else:
			transferto = self.entry.child.get_text()
		if transferto == "":
			return

		call = self.call_ls.get_value(calliter, 1)
		if call.CanTransfer(transferto):
			call.Transfer(transferto)
		else:
			self.l_status.set_text("Call can't be transferred!")
			

	def window_show(self):
		vbox = gtk.VBox(False, 0)

		label = gtk.Label("Transfer Call")
		label.set_markup("<span size=\"large\" weight=\"bold\">Transfer Call</span>")
		vbox.pack_start(label, False, False, 0)
		label.show()

		frame = gtk.Frame('Call:')
		self.calls = gtk.ComboBox(self.call_ls)
		cell = gtk.CellRendererText()
		self.calls.pack_start(cell, True)
		self.calls.add_attribute(cell, 'text', 0)

		frame.add(self.calls)
		self.calls.show()

		vbox.pack_start(frame, False, False, 0)
		frame.show()

		frame = gtk.Frame('Transfer To:')

		self.entry_ls = gtk.ListStore(str, str)
		self.entry = gtk.ComboBoxEntry(self.entry_ls, 0)

		friends = self.friends.keys()
		friends.sort()
		for friend in friends:
			self.entry_ls.append([friend, self.friends[friend]])
		frame.add(self.entry)
		self.entry.show()
		self.entry.grab_focus()
		vbox.pack_start(frame, False, False, 0)
		frame.show()

		self.sendbutton = gtk.Button("Transfer")
		self.sendbutton_connect = self.sendbutton.connect("clicked",
			self.transfer)
		self.sendbutton.set_flags(gtk.CAN_DEFAULT)
		vbox.pack_start(self.sendbutton, False, False, 0)
		self.sendbutton.show()

		label = gtk.Label()
		vbox.pack_start(label, False, False, 0)
		label.show()

		table = gtk.Table(rows=1, columns=2)

		label = gtk.Label("Transfer Status:")
		table.attach(label, 0, 1, 0, 1)
		label.show()

		self.l_status = gtk.Label("")
		table.attach(self.l_status, 1, 2, 0, 1)
		self.l_status.show()

		vbox.pack_start(table, False, False, 0)
		table.show()

		# Set Number from CmdLine if anything given.
		if len(sys.argv) == 2:
			self.entry.set_active_iter(self.entry_ls.append([sys.argv[1], sys.argv[1]]))

		# Now show everything
		vbox.show()
		return vbox


