/*
	This file contains all functions relevant to the projectile structure
*/

#include "rpggame.h"

void projectile::addlight()
{
	if(!rpgobj::effects.inrange(effect))
		return;

	projeffect *sfx = rpgobj::effects[effect];
	if(!(sfx->flags & PFX_DYNLIGHT) || sfx->lightradius < 32)
		return;

	vec colour = vec((sfx->lightcolour >> 16) &0xFF, (sfx->lightcolour >> 8) &0xFF, sfx->lightcolour&0xFF);
	if(colour.magnitude() < 64)
		return;

	//before adding the light, scale it down by 256 first, wouldn't want to hurt our eyes
	if(sfx->lightcolour < 0) colour.div(-256.0f);
	else colour.div(256.0f);

	//now that the tests have passed... ADD THE BLOODY LIGHT
	adddynlight(o, sfx->lightradius, colour);
}

/*void projectile::init()
{

}*/

/*void projectile::update()
{

}*/

void projectile::addtrail(bool &emitparts)
{
	projeffect *sfx = rpgobj::effects[effect];

	int length = lastemit.dist(o) / 3;
	if(!length)
	{
		if(!emitparts)
			return;
		length = 1;
	}

	vec delta = (vec(o).sub(lastemit)).div(length);

	loopj(length)
	{
		lastemit.add(delta);

		switch(sfx->trailpart)
		{
			case PART_EXPLOSION:
			case PART_EXPLOSION_NO_GLARE:
				particle_fireball(lastemit, sfx->trailsize, sfx->trailpart, sfx->trailfade, sfx->trailcol, sfx->trailsize);
				break;
			case PART_STREAK:
			case PART_LIGHTNING:
			{
				vec offset = vec((rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f).normalize().mul(rnd(51) * radius / 100.0f).add(lastemit);
				vec offset2 = vec((rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f).normalize().mul(rnd(51) * radius / 100.0f).add(lastemit);

				particle_flare(offset, offset2, sfx->trailfade, sfx->trailpart, sfx->trailcol, sfx->trailsize);
				break;
			}
			default:
				particle_splash(sfx->trailpart, 1, sfx->trailfade, lastemit, sfx->trailcol, sfx->trailsize, radius, sfx->gravity ? sfx->gravity : 200);
				break;
		}
	}
}