/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class AutoExtract
implements ActionListener {
    public JDialog licenseDialog;
    public boolean accepted;
    public String[] spinner = new String[]{"-", "\\", "|", "/"};
    public String message = "";
    public static String osName = System.getProperty("os.name");
    public static double osVersion = AutoExtract.doubleValue(System.getProperty("os.version"));
    public static String javaVersion = System.getProperty("java.version");

    private static double doubleValue(String string) {
        int n = string.indexOf(".");
        if (n >= 0) {
            n = string.indexOf(".", n + 1);
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    private boolean acceptLicense() {
        InputStream inputStream;
        Closeable closeable;
        String string = "";
        try {
            closeable = new JarFile("extract.jar");
            inputStream = ((JarFile)closeable).getInputStream(((JarFile)closeable).getJarEntry("license/cpl-v10.html"));
        }
        catch (IOException iOException) {
            return true;
        }
        if (inputStream == null) {
            return true;
        }
        closeable = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2 = ((BufferedReader)closeable).readLine();
            while (string2 != null) {
                string = string + string2;
                string2 = ((BufferedReader)closeable).readLine();
            }
            return this.acceptReject(string);
        }
        catch (IOException iOException) {
            System.err.println("Could not read line from license file: " + iOException);
            return true;
        }
    }

    private boolean acceptReject(String string) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.licenseDialog = new JDialog();
        this.licenseDialog.setTitle("License Agreement");
        this.licenseDialog.setModal(true);
        this.licenseDialog.setLocation((dimension.width - 500) / 2, (dimension.height - 400) / 2);
        this.licenseDialog.setSize(500, 400);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setText(string);
        jTextPane.setFont(new Font("Dialog", 0, 12));
        jTextPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jTextPane);
        this.licenseDialog.getContentPane().setLayout(new BorderLayout());
        this.licenseDialog.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Accept");
        JButton jButton2 = new JButton("Cancel");
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)jButton2, "East");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        this.licenseDialog.getContentPane().add((Component)jPanel, "South");
        this.licenseDialog.setVisible(true);
        return this.accepted;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.accepted = actionEvent.getActionCommand().equals("Accept");
        this.licenseDialog.dispose();
        this.licenseDialog = null;
    }

    private boolean extract(String string, File file) {
        Object object;
        JDialog jDialog = new JDialog();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 50;
        if (File.separatorChar == '/') {
            n = 100;
        }
        jDialog.setTitle("Installing");
        jDialog.setLocation((dimension.width - 500) / 2, (dimension.height - n) / 2);
        jDialog.setSize(500, n);
        JLabel jLabel = new JLabel();
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jLabel, "Center");
        jDialog.setVisible(true);
        byte[] byArray = new byte[2048];
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            object = this.getClass().getClassLoader().getResource(string).toString();
            int n2 = ((String)object).lastIndexOf("!");
            if (n2 >= 0) {
                object = ((String)object).substring(0, n2);
            }
            JOptionPane.showMessageDialog(null, (String)object + "\nContains an exclamation point.  Please move the file to a different directory.");
            System.exit(0);
        }
        try {
            object = new JarInputStream(inputStream);
            JarEntry jarEntry = ((JarInputStream)object).getNextJarEntry();
            while (jarEntry != null) {
                File file2;
                int n3 = 0;
                String string2 = jarEntry.getName();
                if (jarEntry == null) {
                    System.err.println("Could not find entry: " + jarEntry);
                } else if (jarEntry.isDirectory()) {
                    file2 = new File(file, jarEntry.getName());
                    file2.mkdirs();
                } else {
                    int n4;
                    jLabel.setText(string2 + " " + this.spinner[n3++]);
                    file2 = new File(file, jarEntry.getName());
                    File file3 = new File(file2.getParent());
                    file3.mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    int n5 = 0;
                    int n6 = 0;
                    while ((n4 = ((JarInputStream)object).read(byArray, 0, 2048)) != -1) {
                        fileOutputStream.write(byArray, 0, n4);
                        n5 += n4;
                        if (++n6 <= 80) continue;
                        jLabel.setText(string2 + " " + this.spinner[n3++] + " (" + n5 + " bytes)");
                        if (n3 > 3) {
                            n3 = 0;
                        }
                        n6 = 0;
                    }
                    fileOutputStream.close();
                    if (string2.length() > 3 && string2.substring(string2.length() - 3).equals(".sh") && File.separatorChar == '/') {
                        Runtime.getRuntime().exec("chmod 755 " + file2.toString());
                    }
                    jLabel.setText(string2 + " " + this.spinner[n3++] + " (" + n5 + " bytes)");
                }
                jarEntry = ((JarInputStream)object).getNextJarEntry();
            }
            jDialog.dispose();
            this.message = "Installation successful";
            return true;
        }
        catch (IOException iOException) {
            this.message = "Installation failed" + iOException;
            return false;
        }
    }

    public static void main(String[] stringArray) {
        if (javaVersion.startsWith("1.") && javaVersion.charAt(2) < '5') {
            JOptionPane.showMessageDialog(null, "Robocode requires Java 5.0 (1.5.0) or newer.\nYour system is currently running Java " + javaVersion + ".\n" + "If you have not installed (or activated) at least\n" + "JRE 5.0 or JDK 5.0, please do so.", "Error", 0);
            System.exit(0);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = null;
        AutoExtract autoExtract = new AutoExtract();
        if (autoExtract.acceptLicense()) {
            Object object;
            int n;
            File file2 = stringArray.length == 1 ? new File(stringArray[0]) : (File.separatorChar == '\\' ? new File("c:\\robocode\\") : new File(System.getProperty("user.home") + File.separator + "robocode" + File.separator));
            boolean bl = false;
            while (!bl) {
                n = JOptionPane.showConfirmDialog(null, "Robocode will be installed in:\n" + file2 + "\nIs this ok?", "Installing Robocode", 1, 3);
                if (n == 0) {
                    file = file2;
                    bl = true;
                    continue;
                }
                if (n == 1) {
                    object = JOptionPane.showInputDialog(null, "Please type in the installation directory", "Installation Directory", -1, null, null, file2);
                    if (object == null) {
                        JOptionPane.showMessageDialog(null, "Installation cancelled.");
                        System.exit(0);
                        continue;
                    }
                    file2 = new File(((String)object).trim());
                    continue;
                }
                if (n != 2) continue;
                JOptionPane.showMessageDialog(null, "Installation cancelled.");
                System.exit(0);
            }
            if (!file.exists()) {
                n = JOptionPane.showConfirmDialog(null, file.getPath() + "\ndoes not exist.  Would you like to create it?", "Installing Robocode", 0, 3);
                if (n == 0) {
                    file.mkdirs();
                } else {
                    JOptionPane.showMessageDialog(null, "Installation cancelled.");
                    System.exit(0);
                }
            }
            if ((n = autoExtract.extract("extract.jar", file)) != 0) {
                autoExtract.createShortcuts(file, "robocode.bat", "Robocode", "Robocode");
            } else {
                JOptionPane.showMessageDialog(null, autoExtract.message);
            }
            AutoExtract.move(new File(file, "robocode.properties"), new File(file, "config/robocode.properties"));
            AutoExtract.move(new File(file, "window.properties"), new File(file, "config/window.properties"));
            AutoExtract.move(new File(file, "compiler.properties"), new File(file, "config/compiler.properties"));
            AutoExtract.move(new File(file, "robot.database"), new File(file, "robots/robot.database"));
            AutoExtract.move(new File(file, ".robotcache"), new File(file, "robots/.robotcache"));
            object = AutoExtract.createDir(new File(file, "roborumble"));
            AutoExtract.createDir(new File((File)object, "files"));
            AutoExtract.createDir(new File((File)object, "temp"));
            AutoExtract.move(new File(file, "config/roborumble.txt"), new File(file, "roborumble/roborumble.txt"));
            AutoExtract.move(new File(file, "config/meleerumble.txt"), new File(file, "roborumble/meleerumble.txt"));
            AutoExtract.move(new File(file, "config/teamrumble.txt"), new File(file, "roborumble/teamrumble.txt"));
        } else {
            JOptionPane.showMessageDialog(null, "Installation cancelled.");
        }
        System.exit(0);
    }

    private void createShortcuts(File file, String string, String string2, String string3) {
        if (osName.toLowerCase().indexOf("win") == 0) {
            if (!this.createWindowsShortcuts(file, string, string2, string3)) {
                JOptionPane.showMessageDialog(null, this.message + "\n" + "To start Robocode, enter the following at a command prompt:\n" + "cd " + file.getAbsolutePath() + "\n" + "robocode.bat");
            }
        } else if (osName.toLowerCase().indexOf("mac") == 0) {
            if (osVersion >= 10.1) {
                JOptionPane.showMessageDialog(null, this.message + "\n" + "To start Robocode, browse to " + file + " then double-click robocode.jar\n");
            } else {
                JOptionPane.showMessageDialog(null, this.message + "\n" + "To start Robocode, enter the following at a command prompt:\n" + file.getAbsolutePath() + "/robocode.sh");
            }
        } else {
            JOptionPane.showMessageDialog(null, this.message + "\n" + "To start Robocode, enter the following at a command prompt:\n" + file.getAbsolutePath() + "/robocode.sh");
        }
    }

    private boolean createWindowsShortcuts(File file, String string, String string2, String string3) {
        int n = JOptionPane.showConfirmDialog(null, "Would you like to install a shortcut to Robocode in the Start menu? (Recommended)", "Create Shortcuts", 0, 3);
        if (n != 0) {
            return false;
        }
        String string4 = osName.indexOf("9") != -1 ? "command.com /c cscript.exe " : "cmd.exe /c cscript.exe ";
        try {
            File file2 = new File(file, "makeshortcut.js");
            PrintStream printStream = new PrintStream(new FileOutputStream(file2));
            printStream.println("WScript.Echo(\"Creating shortcuts...\");");
            printStream.println("Shell = new ActiveXObject(\"WScript.Shell\");");
            printStream.println("ProgramsPath = Shell.SpecialFolders(\"Programs\");");
            printStream.println("fso = new ActiveXObject(\"Scripting.FileSystemObject\");");
            printStream.println("if (!fso.folderExists(ProgramsPath + \"\\\\" + string2 + "\"))");
            printStream.println("\tfso.CreateFolder(ProgramsPath + \"\\\\" + string2 + "\");");
            printStream.println("link = Shell.CreateShortcut(ProgramsPath + \"\\\\" + string2 + "\\\\" + string3 + ".lnk\");");
            printStream.println("link.Arguments = \"\";");
            printStream.println("link.Description = \"" + string3 + "\";");
            printStream.println("link.HotKey = \"\";");
            printStream.println("link.IconLocation = \"" + this.escaped(file.getAbsolutePath()) + "\\\\" + "robocode.ico,0\";");
            printStream.println("link.TargetPath = \"" + this.escaped(file.getAbsolutePath()) + "\\\\" + string + "\";");
            printStream.println("link.WindowStyle = 1;");
            printStream.println("link.WorkingDirectory = \"" + this.escaped(file.getAbsolutePath()) + "\";");
            printStream.println("link.Save();");
            printStream.println("DesktopPath = Shell.SpecialFolders(\"Desktop\");");
            printStream.println("link = Shell.CreateShortcut(DesktopPath + \"\\\\" + string3 + ".lnk\");");
            printStream.println("link.Arguments = \"\";");
            printStream.println("link.Description = \"" + string3 + "\";");
            printStream.println("link.HotKey = \"\";");
            printStream.println("link.IconLocation = \"" + this.escaped(file.getAbsolutePath()) + "\\\\" + "robocode.ico,0\";");
            printStream.println("link.TargetPath = \"" + this.escaped(file.getAbsolutePath()) + "\\\\" + string + "\";");
            printStream.println("link.WindowStyle = 1;");
            printStream.println("link.WorkingDirectory = \"" + this.escaped(file.getAbsolutePath()) + "\";");
            printStream.println("link.Save();");
            printStream.println("WScript.Echo(\"Shortcuts created.\");");
            printStream.close();
            Process process = Runtime.getRuntime().exec(string4 + " makeshortcut.js", null, file);
            process.waitFor();
            int n2 = process.exitValue();
            try {
                file2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 == 0) {
                JOptionPane.showMessageDialog(null, this.message + "\n" + "A Robocode program group has been added to your Start menu\n" + "A Robocode icon has been added to your desktop.");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String escaped(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                string2 = string2 + '\\';
            }
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    private static File createDir(File file) {
        if (file != null && !file.isDirectory()) {
            file.mkdir();
        }
        return file;
    }

    private static void move(File file, File file2) {
        if (file != null && file2 != null && file.exists() && !file.equals(file2)) {
            byte[] byArray = new byte[4096];
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while (fileInputStream.available() > 0) {
                    fileOutputStream.write(byArray, 0, fileInputStream.read(byArray, 0, byArray.length));
                }
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.delete();
        }
    }
}

