/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ClassObserver;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private List field_vec = new ArrayList();
    private List method_vec = new ArrayList();
    private List attribute_vec = new ArrayList();
    private List interface_vec = new ArrayList();
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object object, Object object2) {
            ClassGen classGen = (ClassGen)object;
            ClassGen classGen2 = (ClassGen)object2;
            return classGen.getClassName().equals(classGen2.getClassName());
        }

        public int hashCode(Object object) {
            ClassGen classGen = (ClassGen)object;
            return classGen.getClassName().hashCode();
        }
    };
    private ArrayList observers;

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray, ConstantPoolGen constantPoolGen) {
        this.class_name = string;
        this.super_class_name = string2;
        this.file_name = string3;
        this.access_flags = n;
        this.cp = constantPoolGen;
        if (string3 != null) {
            this.addAttribute(new SourceFile(constantPoolGen.addUtf8("SourceFile"), 2, constantPoolGen.addUtf8(string3), constantPoolGen.getConstantPool()));
        }
        this.class_name_index = constantPoolGen.addClass(string);
        this.superclass_name_index = constantPoolGen.addClass(string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addInterface(stringArray[i]);
            }
        }
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray) {
        this(string, string2, string3, n, stringArray, new ConstantPoolGen());
    }

    public ClassGen(JavaClass javaClass) {
        int n;
        this.class_name_index = javaClass.getClassNameIndex();
        this.superclass_name_index = javaClass.getSuperclassNameIndex();
        this.class_name = javaClass.getClassName();
        this.super_class_name = javaClass.getSuperclassName();
        this.file_name = javaClass.getSourceFileName();
        this.access_flags = javaClass.getAccessFlags();
        this.cp = new ConstantPoolGen(javaClass.getConstantPool());
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Attribute[] attributeArray = javaClass.getAttributes();
        Method[] methodArray = javaClass.getMethods();
        Field[] fieldArray = javaClass.getFields();
        String[] stringArray = javaClass.getInterfaceNames();
        for (n = 0; n < stringArray.length; ++n) {
            this.addInterface(stringArray[n]);
        }
        for (n = 0; n < attributeArray.length; ++n) {
            this.addAttribute(attributeArray[n]);
        }
        for (n = 0; n < methodArray.length; ++n) {
            this.addMethod(methodArray[n]);
        }
        for (n = 0; n < fieldArray.length; ++n) {
            this.addField(fieldArray[n]);
        }
    }

    public JavaClass getJavaClass() {
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        Attribute[] attributeArray = this.getAttributes();
        ConstantPool constantPool = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, constantPool, nArray, fieldArray, methodArray, attributeArray);
    }

    public void addInterface(String string) {
        this.interface_vec.add(string);
    }

    public void removeInterface(String string) {
        this.interface_vec.remove(string);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute attribute) {
        this.attribute_vec.add(attribute);
    }

    public void addMethod(Method method) {
        this.method_vec.add(method);
    }

    public void addEmptyConstructor(int n) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConstants.THIS);
        instructionList.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        instructionList.append(InstructionConstants.RETURN);
        MethodGen methodGen = new MethodGen(n, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, instructionList, this.cp);
        methodGen.setMaxStack(1);
        this.addMethod(methodGen.getMethod());
    }

    public void addField(Field field) {
        this.field_vec.add(field);
    }

    public boolean containsField(Field field) {
        return this.field_vec.contains(field);
    }

    public Field containsField(String string) {
        for (Field field : this.field_vec) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string, String string2) {
        for (Method method : this.method_vec) {
            if (!method.getName().equals(string) || !method.getSignature().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute attribute) {
        this.attribute_vec.remove(attribute);
    }

    public void removeMethod(Method method) {
        this.method_vec.remove(method);
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.method_vec.indexOf(method);
        if (n < 0) {
            this.method_vec.add(method2);
        } else {
            this.method_vec.set(n, method2);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.field_vec.indexOf(field);
        if (n < 0) {
            this.field_vec.add(field2);
        } else {
            this.field_vec.set(n, field2);
        }
    }

    public void removeField(Field field) {
        this.field_vec.remove(field);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String string) {
        this.class_name = string.replace('/', '.');
        this.class_name_index = this.cp.addClass(string);
    }

    public void setSuperclassName(String string) {
        this.super_class_name = string.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(string);
    }

    public Method[] getMethods() {
        return this.method_vec.toArray(new Method[this.method_vec.size()]);
    }

    public void setMethods(Method[] methodArray) {
        this.method_vec.clear();
        for (int i = 0; i < methodArray.length; ++i) {
            this.addMethod(methodArray[i]);
        }
    }

    public void setMethodAt(Method method, int n) {
        this.method_vec.set(n, method);
    }

    public Method getMethodAt(int n) {
        return (Method)this.method_vec.get(n);
    }

    public String[] getInterfaceNames() {
        int n = this.interface_vec.size();
        String[] stringArray = new String[n];
        this.interface_vec.toArray(stringArray);
        return stringArray;
    }

    public int[] getInterfaces() {
        int n = this.interface_vec.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.cp.addClass((String)this.interface_vec.get(i));
        }
        return nArray;
    }

    public Field[] getFields() {
        return this.field_vec.toArray(new Field[this.field_vec.size()]);
    }

    public Attribute[] getAttributes() {
        return this.attribute_vec.toArray(new Attribute[this.attribute_vec.size()]);
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public void setClassNameIndex(int n) {
        this.class_name_index = n;
        this.class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int n) {
        this.superclass_name_index = n;
        this.super_class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver classObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(classObserver);
    }

    public void removeObserver(ClassObserver classObserver) {
        if (this.observers != null) {
            this.observers.remove(classObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((ClassObserver)iterator.next()).notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        _cmp = bCELComparator;
    }

    public boolean equals(Object object) {
        return _cmp.equals(this, object);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

