/*
 * Decompiled with CFR 0.152.
 */
package codesize;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class Codesize {
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private static boolean verbose;

    private Codesize() {
    }

    private static List processCmdLine(String[] stringArray) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (int i = 0; i < stringArray.length; ++i) {
            Item item;
            File file;
            if (stringArray[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (stringArray[i].equals("-r")) {
                File file2 = new File(stringArray[++i]);
                String[] stringArray2 = file2.list();
                for (int j = 0; j < stringArray2.length; ++j) {
                    file = new File(file2, stringArray2[j]);
                    item = stringArray2[j].toLowerCase().endsWith(".class") ? Codesize.processClassFile(file) : Codesize.processZipFile(file);
                    if (item == null) continue;
                    arrayList.add(item);
                }
                continue;
            }
            file = new File(stringArray[i]);
            item = file.isDirectory() ? Codesize.processDirectory(file) : (stringArray[i].toLowerCase().endsWith(".class") ? Codesize.processClassFile(file) : Codesize.processZipFile(file));
            if (item == null) continue;
            arrayList.add(item);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static void deepListClassFiles(File file, List list) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                Codesize.deepListClassFiles(file2, list);
                continue;
            }
            if (!stringArray[i].toLowerCase().endsWith(".class")) continue;
            list.add(file2);
        }
    }

    private static String stripFilename(File file) {
        String string = file.toString();
        if (string.indexOf(File.separator) > -1) {
            string = string.substring(string.lastIndexOf(File.separator) + 1);
        }
        return string;
    }

    private static void help() {
        Package package_ = Codesize.class.getPackage();
        System.out.println(package_.getImplementationTitle() + " " + package_.getImplementationVersion() + " - http://user.cs.tu-berlin.de/~lulli/codesize/");
        System.out.println("SYNTAX:");
        System.out.println();
        System.out.println("  codesize [-v] [<class-file> | <zip-file> | <directory> | -r <repository>]+");
        System.out.println();
        System.out.println("- <class-file> is a single .class file");
        System.out.println("- <zip-file> is a zip compressed file (or a .jar file)");
        System.out.println("- <directory> is treated like an uncompressed <zip-file>,");
        System.out.println("  recursively processing any subdirectories");
        System.out.println("- <repository> is a directory like '<robocode>/robots':");
        System.out.println("  - any class file in it is treated like a <class-file>");
        System.out.println("  - any zip file in it is treated like a <zip-file>");
        System.out.println("  - any subdirectory is ignored (can't distinguish different robots here)");
        System.out.println("- specify -v for verbose output");
    }

    private static int processClassInputStream(InputStream inputStream, String string) throws IOException {
        int n = 0;
        ClassParser classParser = new ClassParser(inputStream, string);
        Method[] methodArray = classParser.parse().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Code code = methodArray[i].getCode();
            if (code == null) continue;
            n += code.getCode().length;
        }
        if (verbose) {
            System.out.println(string + " code size: " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processClassFile(File file) {
        Item item;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            item = new Item(file, 1, (int)file.length(), Codesize.processClassInputStream(bufferedInputStream, file.getName()));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                System.err.println("Ignoring " + Codesize.stripFilename(file) + ": " + iOException.getMessage());
                return null;
            }
        }
        ((InputStream)bufferedInputStream).close();
        return item;
    }

    public static Item processDirectory(File file) {
        int n = 0;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        Codesize.deepListClassFiles(file, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Item item = Codesize.processClassFile((File)arrayList.get(i));
            n += item.ttlClassSize;
            n2 += item.ttlCodeSize;
        }
        return new Item(file, arrayList.size(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processZipFile(File file) {
        Item item;
        if (verbose) {
            System.out.println("Processing zip file " + file.getName());
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            item = Codesize.processZipFile(file, zipInputStream);
        }
        catch (Throwable throwable) {
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                System.err.println("Ignoring " + Codesize.stripFilename(file) + ": " + iOException.getMessage());
                return null;
            }
        }
        zipInputStream.close();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processZipFile(File file, ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            ByteArrayOutputStream byteArrayOutputStream;
            String string = zipEntry.getName().toLowerCase();
            if (string.endsWith(".class")) {
                byteArrayOutputStream = Codesize.getByteArrayOutputStream(zipInputStream, (int)file.length());
                n3 += Codesize.processClassInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), zipEntry.getName());
                n2 += byteArrayOutputStream.size();
                ++n;
                continue;
            }
            if (!string.endsWith(".jar")) continue;
            byteArrayOutputStream = Codesize.getByteArrayOutputStream(zipInputStream, (int)file.length());
            ZipInputStream zipInputStream2 = new ZipInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            try {
                Item item = Codesize.processZipFile(file, zipInputStream2);
                n3 += item.ttlCodeSize;
                n2 += item.ttlClassSize;
            }
            finally {
                zipInputStream2.close();
            }
        }
        if (n3 == 0) {
            throw new IOException("total code size is 0");
        }
        return new Item(file, n, n2, n3);
    }

    private static ByteArrayOutputStream getByteArrayOutputStream(ZipInputStream zipInputStream, int n) throws IOException {
        int n2;
        if (n < 0) {
            n = 524288;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n];
        while ((n2 = zipInputStream.read(byArray, 0, n)) > -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream;
    }

    public static void dump(List list, PrintStream printStream) {
        printStream.println("\tCode\tClass\tClass");
        printStream.println("Nr\tsize\tsize\tfiles\tLocation");
        printStream.println("--------------------------------------------------------------------");
        for (int i = 0; i < list.size(); ++i) {
            Item item = (Item)list.get(i);
            printStream.println("" + (i + 1) + "\t" + item.ttlCodeSize + "\t" + item.ttlClassSize + "\t" + item.nClassFiles + "\t" + Codesize.stripFilename(item.location));
        }
    }

    public static void main(String[] stringArray) {
        List list = Codesize.processCmdLine(stringArray);
        if (list.size() == 0) {
            Codesize.help();
        } else {
            Codesize.dump(list, System.out);
        }
    }

    public static class Item
    implements Comparable {
        private File location;
        private int nClassFiles;
        private int ttlClassSize;
        private int ttlCodeSize;

        Item(File file, int n, int n2, int n3) {
            this.location = file;
            this.nClassFiles = n;
            this.ttlClassSize = n2;
            this.ttlCodeSize = n3;
        }

        public File getLocation() {
            return this.location;
        }

        public int getNClassFiles() {
            return this.nClassFiles;
        }

        public int getClassSize() {
            return this.ttlClassSize;
        }

        public int getCodeSize() {
            return this.ttlCodeSize;
        }

        public int compareTo(Object object) {
            return this.ttlCodeSize - ((Item)object).ttlCodeSize;
        }
    }
}

