/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.explain.view;

/**
 * Event that indicates that something important in an ExplainView
 * component has occurred. Events are generated for the following:
 * <p>
 * <ul>
 * <li>A zoom in the TreeDisplay component has been performed
 * <li>The overview window has been closed
 * <li>The EXPLAIN output window has been closed
 * <li>The EXPLAIN VERBOSE output window has been closed
 * </ul>
 *
 * @author Liam Stewart
 * @version 1.2.0
 */
public class ExplainViewEvent extends java.awt.AWTEvent {
	/** A zoom has occurred. */
	public static final int ZOOM_PERFORMED = 0;

	/** Overview window has closed */
	public static final int OVERVIEW_WINDOW_CLOSED = 1;

	/** Explain window has closed */
	public static final int EXPLAIN_WINDOW_CLOSED = 2;

	/** Explain verbose has closed */
	public static final int EXPLAIN_VERBOSE_WINDOW_CLOSED = 3;

	/** Explain verbose has closed */
	public static final int OPTIONS_WINDOW_CLOSED = 4;

	/**
	 * Creates a new <code>ExplainViewEvent</code> instance.
	 *
	 * @param source an <code>ExplainView</code> value
	 * @param id an <code>int</code> value. One of {@link #ZOOM_PERFORMED},
	 * {@link #OVERVIEW_WINDOW_CLOSED}, {@link #EXPLAIN_WINDOW_CLOSED},
	 * {@link #EXPLAIN_VERBOSE_WINDOW_CLOSED}, {@link #OPTIONS_WINDOW_CLOSED}
	 */
	public ExplainViewEvent(ExplainView source, int id)
	{
		super(source, id);
	}
}
