/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Simple status bar widget.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 1.0
 */
public class StatusBar extends JPanel {
	JLabel statusbar;
	
	/**
	 * Creates a new <code>StatusBar</code> instance.
	 *
	 */
	public StatusBar() {
		this("");
	}

	/**
	 * Creates a new <code>StatusBar</code> instance with some text.
	 *
	 * @param text a <code>String</code> value
	 */
	public StatusBar(String text) {
		statusbar = new JLabel(text);
		
		this.setLayout(new BorderLayout());
		this.add(statusbar, BorderLayout.CENTER);
	}

	/**
	 * Get the text that the status bar is currently displaying.
	 *
	 * @return a <code>String</code> value
	 */
	public String getText() {
		return statusbar.getText();
	}

	/**
	 * Set the text for the status bar to display.
	 *
	 * @param text a <code>String</code> value
	 */
	public void setText(String text) {
		statusbar.setText(text);
	}
}// StatusBar
