/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

/**
 * Exception for special errors that might be thrown by TreeDisplay
 * objects.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class TreeDisplayException extends Exception {
	/**
	 * Creates a new <code>TreeDisplayException</code> instance.
	 */
	public TreeDisplayException()
	{
		super();
	}

	/**
	 * Creates a new <code>TreeDisplayException</code> instance with a
	 * specific message.
	 *
	 * @param msg a <code>String</code> value
	 */
	public TreeDisplayException(String msg)
	{
		super(msg);
	}
}// TreeDisplayException
