/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

/**
 * Simple implmentation of the TreeLayoutEdge interface.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class DefaultTreeLayoutEdge implements TreeLayoutEdge {
	private TreeLayoutModel model;
	private TreeLayoutNode parent, child;
	private int offset;

	/**
	 * Create a new DefaultTreeLayoutEdge object. The parent offset is
	 * set to 0.
	 *
	 * @param p the parent TreeLayoutNode
	 * @param c the child TreeLayoutNode
	 */
	public DefaultTreeLayoutEdge(TreeLayoutNode p,
								 TreeLayoutNode c,
								 TreeLayoutModel m)
	{
		this(p, c, 0, m);
	}

	/**
	 * Create a new DefaultTreeLayoutEdge object.
	 *
	 * @param p the parent TreeLayoutNode
	 * @param c the child TreeLayoutNode
	 * @param o the parent offset
	 */
	public DefaultTreeLayoutEdge(TreeLayoutNode p,
								 TreeLayoutNode c,
								 int o,
								 TreeLayoutModel m)
	{
		parent = p;
		child = c;
		offset = o;
		model = m;
	}

	// inherits doc comment
	public TreeLayoutNode getParent()
	{
		return parent;
	}

	// inherits doc comment
	public TreeLayoutNode getChild()
	{
		return child;
	}

	// inherits doc comment
	public int getParentOffset()
	{
		return offset;
	}

	public TreeLayoutModel getTreeLayoutModel()
	{
		return model;
	}

	public void setTreeLayoutModel(TreeLayoutModel m)
	{
		model = m;
	}
}// DefaultTreeLayoutEdge
