\name{ColorScheme-class}
\docType{class}
\alias{ColorScheme-class}
\title{Color Scheme representation}
\description{
  A color scheme is a  collection of colors that can be used
  to provide a particular style or theme.
  A color scheme has colors for the
  background and the labels/annotations, and a pallette of color
  values that can be used to display different values within the scheme.
  There are different types of schemes for displaying different
  effects or styles. For example, there are continuous or divergent
  schemes.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("ColorScheme", ...)}.
Typically, we retrieve schemes using \code{\link{getColorSchemes}}.
}
\section{Slots}{
  \describe{
    \item{\code{colors}:}{A list containing the different colors for the
      values in the color scheme. Each element is an object of class
      \code{\link{Color-class}}, currently \code{\link{RGBColor-class}}.}
    \item{\code{background}:}{Object of class \code{"Color"}. This is
      used as the background color for displays using this scheme. }
    \item{\code{annotations}:}{Object of class \code{"Color"}. This is
      used to color labels, etc., i.e. decorations on plots.}
    \item{\code{criticalvalue}:}{Object of class \code{"integer"}  }
    \item{\code{description}:}{Object of class \code{"character"}. A
      string giving a human readable description of the characteristics
      of this color scheme.}
    \item{\code{type}:}{Object of class \code{"integer"}. An integer and
      name describing the particular type of the color scheme.
      These are currently qualitative, sequential, divergin and
      spectral.
      The integer value is used internally. Generally, R users will only
     refer to these by the name of the type.}
    \item{\code{system}:}{Object of class \code{"integer"}.  A name and
      integer value identifying how the colors are
      represented. Currently, we are only using RGB. }
    \item{\code{name}:}{Object of class \code{"character"}. A name for
      identifying the color scheme.}
  }
}

\section{Methods}{
No methods defined with class "ColorScheme" in the signature.
}
\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}


\seealso{
  \code{\link{Color-class}}
  \code{\link{RGBColor-class}}
  \code{\link{getColorSchemes}}  
}

\examples{

}
\keyword{classes}
