// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/interface/orp_for_gc.h,v 1.2 2001/09/28 15:56:50 rlhudson Exp $
//


#ifndef _ORP_FOR_GC_H_
#define _ORP_FOR_GC_H_

#include "orp_types.h"
#include "object_layout.h"

//
// Function called by GC when an object becomes
// "f-reachable, finalizable"
// The ORP later finalizes those objects in a way that
// is not part of this interface.
//
ORPExport void orp_finalize_object(Java_java_lang_Object *p_obj);


//
// Root set enumeration for all Java threads.
//
ORPExport void orp_enumerate_root_set_all_threads();



// This function resumes all threads suspended by 
// orp_enumerate_root_set_all_threads
ORPExport void orp_resume_threads_after(bool debug_breakpoint);

//
// Exit and perform the necessary cleanup.
//
ORPExport void orp_exit(int exit_code);



//
// Upper 16 bits are the major number.  A ORP with a new major version
// number may have a different interface.
// Lower 16 bits are the minor version.  An increment in the minor version
// indicates a new build with no changes in the interface.
//
ORPExport uint32 orp_version();

//
// This is the offset of the class_properties field
// in the class data structure.  The CL_PROP masks apply
// to this field.
//
// CLASS_PROPERTIES_OFFSET IS AN UINT32, the other fields are pointers.
//#define CLASS_PROPERTIES_OFFSET      2*(sizeof(char *))
//#define CLASS_GC_INFORMATION_OFFSET  2*(sizeof(char *))+(sizeof(uint32))
//#define CLASS_GC_ARRAY_INFORMATION_OFFSET  2*(sizeof(char *))+(sizeof(uint32))+(sizeof(uint32))

#define CL_PROP_ALIGNMENT_MASK      0x00FFF
#define CL_PROP_NON_REF_ARRAY_MASK  0x01000
#define CL_PROP_ARRAY_MASK          0x02000
#define CL_PROP_PINNED_MASK         0x04000
#define CL_PROP_FINALIZABLE_MASK    0x08000 


// 3322|2222|2222|1111|1111|1100|0000|0000
// 1098|7654|3210|9876|5432|1098|7654|3210
//                          ^^^^^^^^^^^^^^------ CL_PROP_ALIGNMENT_MASK
//                        ^--------------------- CL_PROP_NON_REF_ARRAY_MASK
//                       ^---------------------- CL_PROP_ARRAY_MASK
//                      ^----------------------- CL_PROP_PINNED_MASK
//                     ^------------------------ CL_PROP_FINALIZABLE_MASK 



//**************************************************************************
//
// orp_build_filler_class 
// INTERFACE IS UNDERDISCUSSION AND DOES NOT HAVE THE APPROVAL OF ALL
//
//**************************************************************************

//
// The GC needs the vtable for a first class object that it can use for 'filler' when
// it is aligning certain data types. For example arrays of doubles are aligned
// on double word boundaries. We use this to create and array of bytes.
//
ORPExport void *orp_get_array_of_byte_vtable();

//
// orp_build_filler_class creates a class that can be used by the gc if it needs
// to align objects. For example the gc supports alignement of double arrays so 
// that the elements of the array are on 8 byte boundaries. These objects are pinned and
// if an object is needed to pad out the unused space this is the type of the object.
//
// Input: bytes in an allocated instance, currently we only support 12.
// Output: a (void *) pointer to a vtable construct that points to the 
// new class.
//
ORPExport void *orp_build_filler_class (int size);
//
//

// !!!!!!!!Michal and Rick needs to OK this interface!!!!!!!!!

// during collection, gc has just moved old_obj to new_obj location,
// thus gc needs to call orp synchronization code to update any pointers
// it has to point to new object location
ORPExport void orp_fixup_monitor_lock(void *p_old_obj, void *p_new_obj);

//
// This defines the interface between the threads and the GC.
// It exists so the GC can get from the thread logic the location of certain information
// that might be associated with either a java thread, an OS thread, or a
// CPU.

//
// We have a tension here between needing to be fast in the normal case and
// avoid the call overhead while not wanting to reveal the entire thread
// data structure to the GC.
//
// For the current implementation we will will make this a call interface.
// In the long run it probable should just be inlined but this would mean
// allowing this interface to know about p_TLS_orpthread and the ORP_thread data
// type.

ORPExport void *orp_get_nursery();

ORPExport void orp_change_nursery(void *p_nursery);

#ifdef RECLAIM_EVERY_ALLOCATION
inline unsigned get_thread_allocation_count()
{
	return p_TLS_orpthread->allocation_count;
}

inline void increment_thread_allocation_count()
{
	p_TLS_orpthread->allocation_count += 1;
}

inline void reset_thread_allocation_count()
{
	p_TLS_orpthread->allocation_count = 0;
}
#endif // RECLAIM_EVERY_ALLOCATION

#endif
