// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/jit_utils/dump_jit.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifdef DUMP_JIT

#include "platform.h"

//class.h -> Class.h by LXF 3/27/2001
#include "Class.h"
#include "jit_intf.h"

#include "dump_jit.h"


static Boolean dump_jit_initialized = FALSE;
static CRITICAL_SECTION dump_CriticalSection;
static Boolean dump_CriticalSection_initialized = FALSE;
static FILE *dump_jit_file = NULL;


static void print_separator(FILE *_f)
{
    fprintf(_f,
        "------------------------------------------------------------------\n");
} //print_separator

static void close_dump_jit()
{
    if(dump_jit_file)
        fclose(dump_jit_file);
} //close_dump_jit

static void init_dump_jit()
{
    if(!dump_CriticalSection_initialized) {
        InitializeCriticalSection(&dump_CriticalSection);
        dump_CriticalSection_initialized = TRUE;
    }
    EnterCriticalSection(&dump_CriticalSection);

    assert(!dump_jit_initialized);
    dump_jit_initialized = TRUE;

    if(!dump_jit_file) {
        dump_jit_file = fopen("dump_jit.txt", "w");
        atexit(close_dump_jit);
    }

    LeaveCriticalSection(&dump_CriticalSection);
} //init_dump_jit



/////////////////////////////////////////////////////////////////
// begin Class
/////////////////////////////////////////////////////////////////


static void class_print_for_dump_jit(Class_Handle ch, FILE *_f)
{
    Class *clss = (Class *) ch;
//    if(clss->printed_in_dump_jit)
//        return;
//    clss->printed_in_dump_jit = TRUE;

    Class *super = clss->super_class;
    if(super)
        class_print_for_dump_jit((Class_Handle)super, _f);

    print_separator(_f);
    fprintf(_f, "Class %s extends %s\n",
        clss->name->bytes,
        super ? super->name->bytes : "_");

    unsigned i;

    fprintf(_f, "Instance data (%d bytes):\n", clss->instance_data_size);
    for(i = 0; i < clss->n_fields; i++) {
        Field &f = clss->fields[i];
		if(!f.is_static()) {
            fprintf(_f,
                "%10x %-40s %-30s\n",
                f.get_offset(),
                f.get_signature()->descriptor->bytes,
                f.get_name()->bytes
                );
        }
    }

    fprintf(_f, "Static data (%d bytes):\n", clss->static_data_size);
    for(i = 0; i < clss->n_fields; i++) {
        Field &f = clss->fields[i];
		if(f.is_static()) {
	        char *b = ((char *)clss->static_data_block) + f.get_offset();
            fprintf(_f,
                "%10x %-40s %-30s\n",
                b,
                f.get_signature()->descriptor->bytes,
                f.get_name()->bytes
                );
        }
    }

    fprintf(_f, "Vtable (%d entries):\n", clss->n_virtual_method_entries);
	for (i = 0; i < clss->n_virtual_method_entries; i++) {
		Method *method = clss->vtable_descriptors[i];
        fprintf(_f, "%4x %s.%s%s\n", (4 * i + 8),
            method->get_class()->name->bytes,
            method->get_name()->bytes,
            method->get_descriptor());
        
    }

    fprintf(_f, "End of Class %s\n\n",
        clss->name->bytes);
	fflush(_f);
} //class_print_for_dump_jit



/////////////////////////////////////////////////////////////////
// end Class
/////////////////////////////////////////////////////////////////





FILE *acquire_dump_jit_file(Class_Handle ch)
{
    if (!dump_jit_initialized)
        init_dump_jit();
    EnterCriticalSection(&dump_CriticalSection);
    FILE *result = (dump_jit_file == NULL ? stdout : dump_jit_file);
    if (ch != NULL)
        class_print_for_dump_jit(ch, result);
    print_separator(result);

    return result;
}

void release_dump_jit_file()
{
    if (dump_jit_file != NULL)
        fflush(dump_jit_file);
    LeaveCriticalSection(&dump_CriticalSection);
}



#endif 
