// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/sync_bits.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _sync_bits_H
#define _sync_bits_H


// RLH to WW please check this fact.
// On IA64 the lower 32 bits are the same as on the IA32. 
// The upper 32 bits are used only when there is a pointer in the field. 

#if 1
// These are all POINTER_SIZE_INT but I can't cast them since they are
// used inside of ASM code so things like (POINTER_SIZE_INT)0x0000001E breaks syntatically
// since it isn't C code...
// a max of 4K threads
#define BUSY_FORWARDING_OFFSET                  0x00000000
#define QUICK_RECURSION_MASK                    0x0000001E
#define QUICK_RECURSION_LEFT_SHIFT_COUNT        0x00000001
#define QUICK_RECURSION_ABOUT_TO_OVERFLOW       0x0000001C
#define SLOW_LOCKING                            0x0000001E
#define QUICK_RECURSION_INC_DEC_REMENT          0x00000002
#define QUICK_THREAD_INDEX_MASK                 0x0001FFE0
#define QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT     0x00000005
#define QUICK_THREAD_INDEX_WIDTH                0x0000000C
#define QUICK_HASH_MASK                         0xFFFE0000
#define QUICK_HASH_MASK_WIDTH                   0x0000000F
#define QUICK_HASH_LEFT_SHIFT_COUNT             0x00000011
#ifdef POINTER64
#define LOCK_BLOCK_POINTER_MASK                 0xFFFFffffFFFFFFE0
#else
#define LOCK_BLOCK_POINTER_MASK                 0xFFFFFFE0
#endif
#define SINGLE_THREAD_W_RECURSION_SET_TO_ONE    0x00000022

#else

// deep java lock recursion test (sets recursion overflow to smallest possible value)
#define BUSY_FORWARDING_OFFSET                  0x00000000
#define QUICK_RECURSION_MASK                    0x00000006
#define QUICK_RECURSION_LEFT_SHIFT_COUNT        0x00000001
#define QUICK_RECURSION_ABOUT_TO_OVERFLOW       0x00000004
#define SLOW_LOCKING                            0x00000006
#define QUICK_RECURSION_INC_DEC_REMENT          0x00000002
#define QUICK_THREAD_INDEX_MASK                 0x0001FFF8
#define QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT     0x00000003
#define QUICK_THREAD_INDEX_WIDTH                0x0000000E
#define QUICK_HASH_MASK                         0xFFFE0000
#define QUICK_HASH_MASK_WIDTH                   0x0000000F
#define QUICK_HASH_LEFT_SHIFT_COUNT             0x00000011
#define LOCK_BLOCK_POINTER_MASK                 0xFFFFFFE0
#define SINGLE_THREAD_W_RECURSION_SET_TO_ONE    0x0000000A

#endif 


#if 0
// a max of 512 threads (use this only if chasing a bug in 4k version above
#define BUSY_FORWARDING_OFFSET                  0x00000000
#define QUICK_RECURSION_MASK                    0x0000001E
#define QUICK_RECURSION_LEFT_SHIFT_COUNT        0x00000001
#define QUICK_RECURSION_ABOUT_TO_OVERFLOW       0x0000001C
#define SLOW_LOCKING                            0x0000001E
#define QUICK_RECURSION_INC_DEC_REMENT          0x00000002
#define QUICK_THREAD_INDEX_MASK                 0x00003FE0
#define QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT     0x00000005
#define QUICK_THREAD_INDEX_WIDTH                0x00000009
#define QUICK_HASH_MASK                         0xFFFFC000
#define QUICK_HASH_MASK_WIDTH                   0x00000012
#define QUICK_HASH_LEFT_SHIFT_COUNT             0x0000000E
#define LOCK_BLOCK_POINTER_MASK                 0xFFFFFFE0
#endif   

#endif // \include\sync_bits.h

