// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/nogc.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


// This file contains the prototypes for allocation routines that are
// not currently supported by the GC. The clients of these routines
// shouldn't be relying on gc_for_orp.h or the older garbage_collector.h. Instead, this stop
// gap header file.
//

#ifndef _NOGC_H_
#define _NOGC_H_

#include "platform.h"

void orp_init_mem_alloc();
void *gc_malloc_fixed_code_for_jit(unsigned size);
void  gc_free_fixed_code_for_class_loading(void *a);
void  gc_free_fixed_code_for_jit(void *a);
void *gc_malloc_fixed_data_C(unsigned size);
void  gc_free_fixed_data_C(void *a);

ORPExport void *gc_malloc_fixed_code_for_class_loading(unsigned size);

#endif // _NOGC_H_
