// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/jni_direct.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//




#ifndef _JNI_DIRECT_H_
#define _JNI_DIRECT_H_

#include "jni.h"



void jni_init();

ORPExport jint JNICALL GetVersion(JNIEnv *env);

ORPExport jclass JNICALL DefineClass(JNIEnv *env, const char *name, jobject loader, const jbyte *buf, jsize len);

ORPExport jclass JNICALL FindClass(JNIEnv *env, const char *name);

ORPExport jclass JNICALL GetObjectClass(JNIEnv *env, jobject obj);

ORPExport jboolean JNICALL IsAssignableFrom(JNIEnv *env, jclass clazz1, jclass clazz2);

ORPExport jclass JNICALL GetSuperclass(JNIEnv *env, jclass clazz);

ORPExport jobject JNICALL NewGlobalRef(JNIEnv *env, jobject obj);
ORPExport void JNICALL DeleteGlobalRef(JNIEnv *env, jobject globalRef);
ORPExport void JNICALL DeleteLocalRef(JNIEnv *env, jobject localRef);

ORPExport jobject JNICALL AllocObject(JNIEnv *env, jclass clazz);


ORPExport jobject JNICALL NewObject(JNIEnv *env,
                          jclass clazz,
                          jmethodID methodID,
                          ...);
ORPExport jobject JNICALL NewObjectV(JNIEnv *env,
                           jclass clazz,
                           jmethodID methodID,
                           va_list args);
ORPExport jobject JNICALL NewObjectA(JNIEnv *env,
                           jclass clazz,
                           jmethodID methodID,
                           jvalue *args);

ORPExport jstring JNICALL NewString(JNIEnv *env,
                  const jchar *unicodeChars,
                  jsize length);

ORPExport jstring JNICALL NewStringUTF(JNIEnv *env,
                     const char *bytes);

ORPExport jboolean JNICALL IsSameObject(JNIEnv *env,
                      jobject ref1,
                      jobject ref2);

ORPExport jboolean JNICALL IsInstanceOf(JNIEnv *env,
                      jobject obj,
                      jclass clazz);

ORPExport jfieldID JNICALL GetFieldID(JNIEnv *env,
                    jclass clazz,
                    const char *name,
                    const char *sig);

ORPExport jfieldID JNICALL GetStaticFieldID(JNIEnv *env,
                          jclass clazz,
                          const char *name,
                          const char *sig);

ORPExport jmethodID JNICALL GetMethodID(JNIEnv *env,
                      jclass clazz,
                      const char *name,
                      const char *sig);


ORPExport jmethodID JNICALL GetStaticMethodID(JNIEnv *env,
                            jclass clazz,
                            const char *name,
                            const char *sig);


// This fucntion is not part of the standard JNI interface, but we can use
// it internally.  It is faster and, IMHO, more convenient to use.
ORPExport jfieldID JNICALL GetFieldID_Quick(JNIEnv *env,
                          const char *class_name,
                          const char *field_name,
                          const char *sig);


// This fucntion is not part of the standard JNI interface, but we can use
// it internally.  It is faster and, IMHO, more convenient to use.
ORPExport jfieldID JNICALL GetStaticFieldID_Quick(JNIEnv *env,
                                const char *class_name,
                                const char *field_name,
                                const char *sig);



ORPExport jboolean    JNICALL GetBooleanField (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jbyte       JNICALL GetByteField    (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jchar       JNICALL GetCharField    (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jshort      JNICALL GetShortField   (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jint        JNICALL GetIntField     (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jlong       JNICALL GetLongField    (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jfloat      JNICALL GetFloatField   (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jdouble     JNICALL GetDoubleField  (JNIEnv *env, jobject obj, jfieldID fieldID);
ORPExport jobject     JNICALL GetObjectField  (JNIEnv *env, jobject obj, jfieldID fieldID);


ORPExport void JNICALL SetBooleanField (JNIEnv *env, jobject obj, jfieldID fieldID, jboolean value);
ORPExport void JNICALL SetByteField    (JNIEnv *env, jobject obj, jfieldID fieldID, jbyte value);
ORPExport void JNICALL SetCharField    (JNIEnv *env, jobject obj, jfieldID fieldID, jchar value);
ORPExport void JNICALL SetShortField   (JNIEnv *env, jobject obj, jfieldID fieldID, jshort value);
ORPExport void JNICALL SetIntField     (JNIEnv *env, jobject obj, jfieldID fieldID, jint value);
ORPExport void JNICALL SetLongField    (JNIEnv *env, jobject obj, jfieldID fieldID, jlong value);
ORPExport void JNICALL SetFloatField   (JNIEnv *env, jobject obj, jfieldID fieldID, jfloat value);
ORPExport void JNICALL SetDoubleField  (JNIEnv *env, jobject obj, jfieldID fieldID, jdouble value);
ORPExport void JNICALL SetObjectField  (JNIEnv *env, jobject obj, jfieldID fieldID, jobject value);


ORPExport jboolean    JNICALL GetStaticBooleanField (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jbyte       JNICALL GetStaticByteField    (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jchar       JNICALL GetStaticCharField    (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jshort      JNICALL GetStaticShortField   (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jint        JNICALL GetStaticIntField     (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jlong       JNICALL GetStaticLongField    (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jfloat      JNICALL GetStaticFloatField   (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jdouble     JNICALL GetStaticDoubleField  (JNIEnv *env, jclass clazz, jfieldID fieldID); 
ORPExport jobject     JNICALL GetStaticObjectField  (JNIEnv *env, jclass clazz, jfieldID fieldID); 


ORPExport void JNICALL SetStaticBooleanField (JNIEnv *env, jclass clazz, jfieldID fieldID, jboolean value);
ORPExport void JNICALL SetStaticByteField    (JNIEnv *env, jclass clazz, jfieldID fieldID, jbyte value);
ORPExport void JNICALL SetStaticCharField    (JNIEnv *env, jclass clazz, jfieldID fieldID, jchar value);
ORPExport void JNICALL SetStaticShortField   (JNIEnv *env, jclass clazz, jfieldID fieldID, jshort value);
ORPExport void JNICALL SetStaticIntField     (JNIEnv *env, jclass clazz, jfieldID fieldID, jint value);
ORPExport void JNICALL SetStaticLongField    (JNIEnv *env, jclass clazz, jfieldID fieldID, jlong value);
ORPExport void JNICALL SetStaticFloatField   (JNIEnv *env, jclass clazz, jfieldID fieldID, jfloat value);
ORPExport void JNICALL SetStaticDoubleField  (JNIEnv *env, jclass clazz, jfieldID fieldID, jdouble value);
ORPExport void JNICALL SetStaticObjectField  (JNIEnv *env, jclass clazz, jfieldID fieldID, jobject value);


ORPExport jsize JNICALL GetArrayLength(JNIEnv *env, jarray array);

ORPExport jboolean * JNICALL GetBooleanArrayElements (JNIEnv *env, jbooleanArray array, jboolean *isCopy); 
ORPExport jbyte    * JNICALL GetByteArrayElements    (JNIEnv *env, jbyteArray array,    jboolean *isCopy); 
ORPExport jchar    * JNICALL GetCharArrayElements    (JNIEnv *env, jcharArray array,    jboolean *isCopy); 
ORPExport jshort   * JNICALL GetShortArrayElements   (JNIEnv *env, jshortArray array,   jboolean *isCopy); 
ORPExport jint     * JNICALL GetIntArrayElements     (JNIEnv *env, jintArray array,     jboolean *isCopy); 
ORPExport jlong    * JNICALL GetLongArrayElements    (JNIEnv *env, jlongArray array,    jboolean *isCopy); 
ORPExport jfloat   * JNICALL GetFloatArrayElements   (JNIEnv *env, jfloatArray array,   jboolean *isCopy); 
ORPExport jdouble  * JNICALL GetDoubleArrayElements  (JNIEnv *env, jdoubleArray array,  jboolean *isCopy); 


ORPExport jobject JNICALL GetObjectArrayElement(JNIEnv *env, jobjectArray array, jsize index);

ORPExport void JNICALL SetObjectArrayElement(JNIEnv *env, jobjectArray array, jsize index, jobject value);


ORPExport void JNICALL ReleaseBooleanArrayElements(JNIEnv *env, jbooleanArray array, jboolean *elems, jint mode);
ORPExport void JNICALL ReleaseByteArrayElements   (JNIEnv *env, jbyteArray array,    jbyte *elems,    jint mode);
ORPExport void JNICALL ReleaseCharArrayElements   (JNIEnv *env, jcharArray array,    jchar *elems,    jint mode);
ORPExport void JNICALL ReleaseShortArrayElements  (JNIEnv *env, jshortArray array,   jshort *elems,   jint mode);
ORPExport void JNICALL ReleaseIntArrayElements    (JNIEnv *env, jintArray array,     jint *elems,     jint mode);
ORPExport void JNICALL ReleaseLongArrayElements   (JNIEnv *env, jlongArray array,    jlong *elems,    jint mode);
ORPExport void JNICALL ReleaseFloatArrayElements  (JNIEnv *env, jfloatArray array,   jfloat *elems,   jint mode);
ORPExport void JNICALL ReleaseDoubleArrayElements (JNIEnv *env, jdoubleArray array,  jdouble *elems,  jint mode);


ORPExport void JNICALL GetBooleanArrayRegion (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jboolean *buf);
ORPExport void JNICALL GetByteArrayRegion    (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jbyte *buf);
ORPExport void JNICALL GetCharArrayRegion    (JNIEnv *env, jobjectArray array, 
                            jsize start, jsize len,
                            jchar *buf);
ORPExport void JNICALL GetShortArrayRegion   (JNIEnv *env, jobjectArray array, 
                            jsize start, jsize len,
                            jshort *buf);
ORPExport void JNICALL GetIntArrayRegion     (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jint *buf);
ORPExport void JNICALL GetLongArrayRegion    (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jlong *buf);
ORPExport void JNICALL GetFloatArrayRegion   (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jfloat *buf);
ORPExport void JNICALL GetDoubleArrayRegion  (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jdouble *buf);

ORPExport void JNICALL SetBooleanArrayRegion (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jboolean *buf);
ORPExport void JNICALL SetByteArrayRegion    (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jbyte *buf);
ORPExport void JNICALL SetCharArrayRegion    (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jchar *buf);
ORPExport void JNICALL SetShortArrayRegion   (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jshort *buf);
ORPExport void JNICALL SetIntArrayRegion     (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jint *buf);
ORPExport void JNICALL SetLongArrayRegion    (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jlong *buf);
ORPExport void JNICALL SetFloatArrayRegion   (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jfloat *buf);
ORPExport void JNICALL SetDoubleArrayRegion  (JNIEnv *env, jobjectArray array,
                            jsize start, jsize len,
                            jdouble *buf);

ORPExport jbooleanArray JNICALL NewBooleanArray (JNIEnv *env, jsize length);
ORPExport jbyteArray    JNICALL NewByteArray    (JNIEnv *env, jsize length);
ORPExport jcharArray    JNICALL NewCharArray    (JNIEnv *env, jsize length);
ORPExport jshortArray   JNICALL NewShortArray   (JNIEnv *env, jsize length);
ORPExport jintArray     JNICALL NewIntArray     (JNIEnv *env, jsize length);
ORPExport jlongArray    JNICALL NewLongArray    (JNIEnv *env, jsize length);
ORPExport jfloatArray   JNICALL NewFloatArray   (JNIEnv *env, jsize length);
ORPExport jdoubleArray  JNICALL NewDoubleArray  (JNIEnv *env, jsize length);

ORPExport jarray JNICALL NewObjectArray(JNIEnv *env,
                      jsize length,
                      jclass elementClass,
                      jobject initialElement);


ORPExport jsize       JNICALL GetStringLength(JNIEnv *env, jstring string);
ORPExport const jchar * JNICALL GetStringChars(JNIEnv *env, jstring string, jboolean *isCopy);
ORPExport void      JNICALL ReleaseStringChars(JNIEnv *env, jstring string, const jchar *chars);

ORPExport jsize       JNICALL GetStringUTFLength(JNIEnv *env, jstring string);
ORPExport const char * JNICALL GetStringUTFChars(JNIEnv *env, jstring string, jboolean *isCopy);
ORPExport void     JNICALL ReleaseStringUTFChars(JNIEnv *env, jstring string, const char *utf);


ORPExport void     JNICALL CallVoidMethod     (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport void     JNICALL CallVoidMethodV    (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport void     JNICALL CallVoidMethodA    (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jobject  JNICALL CallObjectMethod   (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jobject  JNICALL CallObjectMethodV  (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jobject  JNICALL CallObjectMethodA  (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jboolean JNICALL CallBooleanMethod  (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jboolean JNICALL CallBooleanMethodV (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jboolean JNICALL CallBooleanMethodA (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jbyte    JNICALL CallByteMethod     (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jbyte    JNICALL CallByteMethodV    (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jbyte    JNICALL CallByteMethodA    (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jchar    JNICALL CallCharMethod     (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jchar    JNICALL CallCharMethodV    (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jchar    JNICALL CallCharMethodA    (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jshort   JNICALL CallShortMethod    (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jshort   JNICALL CallShortMethodV   (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jshort   JNICALL CallShortMethodA   (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jint     JNICALL CallIntMethod      (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jint     JNICALL CallIntMethodV     (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jint     JNICALL CallIntMethodA     (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jlong    JNICALL CallLongMethod     (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jlong    JNICALL CallLongMethodV    (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jlong    JNICALL CallLongMethodA    (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jfloat   JNICALL CallFloatMethod    (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jfloat   JNICALL CallFloatMethodV   (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jfloat   JNICALL CallFloatMethodA   (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);
ORPExport jdouble  JNICALL CallDoubleMethod   (JNIEnv *env, jobject obj, jmethodID methodID, ...);
ORPExport jdouble  JNICALL CallDoubleMethodV  (JNIEnv *env, jobject obj, jmethodID methodID, va_list args);
ORPExport jdouble  JNICALL CallDoubleMethodA  (JNIEnv *env, jobject obj, jmethodID methodID, jvalue *args);



ORPExport void JNICALL CallNonvirtualVoidMethod(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       ...);
ORPExport void JNICALL CallNonvirtualVoidMethodV(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       va_list args);
ORPExport void JNICALL CallNonvirtualVoidMethodA(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       jvalue *args);
ORPExport jobject JNICALL CallNonvirtualObjectMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jobject JNICALL CallNonvirtualObjectMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jobject JNICALL CallNonvirtualObjectMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jboolean JNICALL CallNonvirtualBooleanMethod(JNIEnv *env,
                                             jobject obj,
                                             jclass clazz,
                                             jmethodID methodID,
                                             ...);
ORPExport jboolean JNICALL CallNonvirtualBooleanMethodV(JNIEnv *env,
                                              jobject obj,
                                              jclass clazz,
                                              jmethodID methodID,
                                              va_list args);
ORPExport jboolean JNICALL CallNonvirtualBooleanMethodA(JNIEnv *env,
                                              jobject obj,
                                              jclass clazz,
                                              jmethodID methodID,
                                              jvalue *args);
ORPExport jbyte JNICALL CallNonvirtualByteMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jbyte JNICALL CallNonvirtualByteMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jbyte JNICALL CallNonvirtualByteMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jchar JNICALL CallNonvirtualCharMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jchar JNICALL CallNonvirtualCharMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jchar JNICALL CallNonvirtualCharMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jshort JNICALL CallNonvirtualShortMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jshort JNICALL CallNonvirtualShortMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jshort JNICALL CallNonvirtualShortMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jint JNICALL CallNonvirtualIntMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jint JNICALL CallNonvirtualIntMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jint JNICALL CallNonvirtualIntMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jlong JNICALL CallNonvirtualLongMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jlong JNICALL CallNonvirtualLongMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jlong JNICALL CallNonvirtualLongMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jfloat JNICALL CallNonvirtualFloatMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jfloat JNICALL CallNonvirtualFloatMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jfloat JNICALL CallNonvirtualFloatMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);
ORPExport jdouble JNICALL CallNonvirtualDoubleMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...);
ORPExport jdouble JNICALL CallNonvirtualDoubleMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args);
ORPExport jdouble JNICALL CallNonvirtualDoubleMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args);


ORPExport void JNICALL 
CallStaticVoidMethod     (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport void JNICALL 
CallStaticVoidMethodV    (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport void JNICALL 
CallStaticVoidMethodA    (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jobject JNICALL 
CallStaticObjectMethod   (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jobject JNICALL 
CallStaticObjectMethodV  (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jobject JNICALL 
CallStaticObjectMethodA  (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jboolean JNICALL 
CallStaticBooleanMethod  (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jboolean JNICALL 
CallStaticBooleanMethodV (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jboolean JNICALL 
CallStaticBooleanMethodA (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jbyte JNICALL 
CallStaticByteMethod     (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jbyte JNICALL 
CallStaticByteMethodV    (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jbyte JNICALL 
CallStaticByteMethodA    (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jchar JNICALL 
CallStaticCharMethod     (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jchar JNICALL 
CallStaticCharMethodV    (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jchar JNICALL 
CallStaticCharMethodA    (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jshort JNICALL 
CallStaticShortMethod    (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jshort JNICALL 
CallStaticShortMethodV   (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jshort JNICALL 
CallStaticShortMethodA   (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jint JNICALL 
CallStaticIntMethod      (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jint JNICALL 
CallStaticIntMethodV     (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jint JNICALL 
CallStaticIntMethodA     (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jlong JNICALL 
CallStaticLongMethod     (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jlong JNICALL 
CallStaticLongMethodV    (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jlong JNICALL 
CallStaticLongMethodA    (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jfloat JNICALL 
CallStaticFloatMethod    (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jfloat JNICALL 
CallStaticFloatMethodV   (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jfloat JNICALL 
CallStaticFloatMethodA   (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);
ORPExport jdouble JNICALL 
CallStaticDoubleMethod   (JNIEnv *env, jclass clazz, jmethodID methodID, ...);
ORPExport jdouble JNICALL 
CallStaticDoubleMethodV  (JNIEnv *env, jclass clazz, jmethodID methodID, va_list args);
ORPExport jdouble JNICALL 
CallStaticDoubleMethodA  (JNIEnv *env, jclass clazz, jmethodID methodID, jvalue *args);


ORPExport jint JNICALL Throw (JNIEnv *env, jthrowable obj);
ORPExport jint JNICALL ThrowNew(JNIEnv *env, jclass clazz, const char *message);
ORPExport jint JNICALL ThrowNew_Quick (JNIEnv *env, const char *classname, const char *message);
ORPExport jthrowable JNICALL ExceptionOccurred(JNIEnv *env);
ORPExport void JNICALL ExceptionClear(JNIEnv *env);
ORPExport void JNICALL ExceptionDescribe(JNIEnv *env);
ORPExport void JNICALL FatalError(JNIEnv *env, const char *msg);


ORPExport jint JNICALL RegisterNatives(JNIEnv *env,
                             jclass clazz,
                             const JNINativeMethod *methods,
                             jint nMethods);
ORPExport jint JNICALL UnregisterNatives(JNIEnv *env, jclass clazz);

ORPExport jint JNICALL MonitorEnter(JNIEnv *env, jobject obj);
ORPExport jint JNICALL MonitorExit(JNIEnv *env, jobject obj);
ORPExport jint JNICALL GetJavaVM(JNIEnv *env, JavaVM **vm);





#endif
