// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/object_list.cpp,v 1.2 2001/10/12 14:47:04 rlhudson Exp $
//

 
#include <string.h>
 
#include "gc_for_orp.h"
 

#include "object_list.h"
#include "gc_consts.h"
 
#include "gc_header.h"

Object_List::Object_List() 
{
    _size_in_entries = DEFAULT_OBJECT_SIZE_IN_ENTRIES;

    _store = (Java_java_lang_Object **)malloc(_size_in_entries * 
                                          sizeof(Java_java_lang_Object *));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating object list" << endl;
        assert(0);
        orp_exit(1);
    }

    _resident_count  = 0;
}

Object_List::~Object_List()
{
    free(_store);
}

unsigned
Object_List::add_entry(Java_java_lang_Object *p_obj)
{
    if (_resident_count >= (_size_in_entries - 1)) {
        _extend();
    }

    _store[_resident_count++] = p_obj;

    return (_resident_count - 1);
}

void
Object_List::_extend()
{
    Java_java_lang_Object **old_store = _store;

    //
    // Present policy: double it.
    //
    _size_in_entries = _size_in_entries * 2;

    _store = (Java_java_lang_Object **)malloc(_size_in_entries * 
                                          sizeof (Java_java_lang_Object *));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating object list" << endl;
        assert(0);
        orp_exit(1);
    }

    memcpy((void *)_store, 
           (void *)old_store, 
           _resident_count * sizeof(Java_java_lang_Object *));

	free(old_store);
}

Java_java_lang_Object *
Object_List::next()
{
    if (_current_pointer >= _resident_count) {
        return NULL;
    }

    return _store[_current_pointer++];
}

void 
Object_List::debug_dump_list()
{
    orp_cout << "Dump of object list:" << endl;
    for (unsigned idx = 0; idx < _resident_count; idx++) {
        orp_cout << "entry[" << idx << "] = " << _store[idx] << endl;
    }
}


void
Object_List::rewind()
{
    _current_pointer = 0;
}

void
Object_List::reset()
{
    rewind();
    _resident_count = 0;
}

unsigned
Object_List::size()
{
    return _resident_count;
}

// end Object_List.cpp

// Start Root list which is similar to object list but hold pointers to 
// slots not in the heap that hold references to objects in the heap.
//

Root_List::Root_List() 
{
    _size_in_entries = DEFAULT_OBJECT_SIZE_IN_ENTRIES;

    _store = (Java_java_lang_Object ***)malloc(_size_in_entries * 
                                          sizeof(Java_java_lang_Object **));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating object list" << endl;
        assert(0);
        orp_exit(1);
    }
    reset();

}

Root_List::~Root_List()
{
    free(_store);
}

unsigned
Root_List::add_entry(Java_java_lang_Object **pp_obj)
{
    if (_resident_count >= (_size_in_entries - 1)) {
        _extend();
    }

    _store[_resident_count++] = pp_obj;

    return (_resident_count - 1);
}

void
Root_List::_extend()
{
    Java_java_lang_Object ***old_store = _store;

    //
    // Present policy: double it.
    //
    _size_in_entries = _size_in_entries * 2;

    _store = (Java_java_lang_Object ***)malloc(_size_in_entries * 
                                          sizeof (Java_java_lang_Object *));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating object list" << endl;
        assert(0);
        orp_exit(1);
    }

    memcpy((void *)_store, 
           (void *)old_store, 
           _resident_count * sizeof(Java_java_lang_Object *));

	free(old_store);
}

Java_java_lang_Object **
Root_List::pp_next()
{
    if (_current_pointer >= _resident_count) {
        return NULL;
    }

    return _store[_current_pointer++];
}

void 
Root_List::debug_dump_list()
{
    orp_cout << "Dump of object list:" << endl;
    for (unsigned idx = 0; idx < _resident_count; idx++) {
        orp_cout << "entry[" << idx << "] = " << _store[idx] << endl;
    }
}

void
Root_List::rewind()
{
    _current_pointer = 0;
}

void
Root_List::reset()
{
    rewind();
#ifdef _DEBUG
    unsigned int i;
    for (i = 0; i < _size_in_entries; i++) {
        _store[i] = NULL;
    }
#endif
    _resident_count = 0;
}

unsigned
Root_List::size()
{
    return _resident_count;
}

// end file gc\Object_List.cpp
