// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/train_generation.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//


#ifndef _train_generation_H_
#define _train_generation_H_

//
// Generations which have trains instead of steps. Train_Generations
// inherit from Generation.
//
//                Generation
//                    |
//                    |
//       ---------------------------
//       |                         |
//       |                         |
//    Step_Generation              |
//       |                         |
//       |                  Train_Generation
//       |
//  Step_Plus_Nursery_Generation
//



#include "gc_header.h"
//
// The train data structures are accessed using the variable trains. 
// They are arranged from the oldest train to the youngest train in a linked list.
// Each train has a list of cars associated with it and the next younger train.
// Each car has a list of blocks and a next younger car associated with it.
//

extern train_info *trains;
#endif // _train_generation_H_
