// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/hash_table.h,v 1.2 2001/10/12 14:47:04 rlhudson Exp $
//

#ifndef _hash_table_H_
#define _hash_table_H_


// Provides hash table support for remembered sets, scan sets, etc.
//

// #include "platform.h"
// #include "object_layout.h"
// #include "orp_utils.h"

enum table_state {
     empty,
     rewound,
     scanning,
     modified,
     scanned
     };


class Hash_Table {
public:
    Hash_Table();    

    virtual ~Hash_Table();

    unsigned add_entry(void *address);

	int delete_entry(void *address);

    void empty_all();

    inline bool is_empty()
        {return _resident_count == 0 ? true : false;}

    inline bool is_not_empty()
        {return _resident_count == 0 ? false : true;}

    Hash_Table *merge(Hash_Table *rs);

    bool is_present(void *address);

    bool is_not_present(void *address) {

		if (is_present(address)) {
			return false;
		}

		return true;
	}

	void rewind(void);

	void *next(void);

	void *next_delete(void); // delete after returning

	int size() {
		return _resident_count;
	}

    //
    // Look for any entries in the hash table that *point* *to* the old address
    // and replace them with pointers to the new one.
    // NOTE: This doesn't simply update old entries with new ones.
    //
    void update_target(void *p_old,
                       void *p_new) {
        for (int index = 0; index < _size_in_entries; index++) {

            void **pp_ref = (void **)_table[index];

            if (*pp_ref == p_old) {
                *pp_ref = p_new;
            }
        }
    }

protected:

    virtual void _extend();

    int _get_offset(void *address);
    //
    // An offset into the primes table corresponding to the
    // current size of the hash table.
    //
    unsigned int _prime_index;

    //
    // The number of entries currently in this hash table.
    //
    int _resident_count;

    int _save_pointer;      // used to record last item served

    //
    // The number of entries that this hash table can accomodate.
    //
    int _size_in_entries;

    int _size_in_bytes;
    //
    // Storage for this hash table.
    // volatile since it can be extended by different threads in Sapphire.
    //
    volatile void **_table;


    int _threshold_entries;

private:

//OBSOLETE	CRITICAL_SECTION _critical_section;

    unsigned int _do_rs_hash(POINTER_SIZE_INT address, unsigned int table_size);


    void *_next();
    //
    // An entry at location hash_code has just been deleted. We need
    // to scan to the next zero entry and rehash every intervening
    // entry so that this new zero entry doesn't confuse subsequent
    // add_entries from creating duplicates. This needs to be done
    // in a batch, (delete all, then rehash all) to minimize complexity.
    //
    void _rehash(unsigned int hash_code);


    void _rewind();

};

#endif // _hash_table_H_

