// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/remembered_set.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _Remembered_Set_H_
#define _Remembered_Set_H_

//
// A remembered set is maintained per car and per generation 
// (except the highest numbered car and the oldest generation).
// and is a non-duplicate list of pointers to pointers from
// outside that region. Typically only pointers from older to
// younger generations, and higher to lower trains are recorded.
//

#include "platform.h"
#include "object_layout.h"
#include "hash_table.h"

class Train_Generation;

//
// Remembered Sets inherit from Hash Table and enhance it
// by typing the entries of the Hash Table to be pointers
// to Java_lang_Object.
//
class Remembered_Set : public Hash_Table {
public:

#if 1 //  (GC_DEBUG>2) also change remembered_set.cpp definition.
    // For now remove the inline so we can check for valid references.

    unsigned add_entry(Java_java_lang_Object **address) ;

#else

    inline unsigned add_entry(Java_java_lang_Object **address) {
		return Hash_Table::add_entry((void *)address);
	}
#endif // GC_DEBUG
    Remembered_Set *p_clone();

	inline int delete_entry(Java_java_lang_Object **address) {
		return Hash_Table::delete_entry((void *)address);
	}

	void dump() {
		void **pp_obj;

		printf(">>>>>>>>>>>>>>>>>>\n");
		printf("%d entries>>>>>>>>>>\n", _resident_count);
		rewind();

		while ((pp_obj = (void **)next()) != NULL) {
			printf("\t==> [%x](%x)\n", pp_obj, *pp_obj);
		}
		printf("<<<<<<<<<<<<<<<<<<<\n");
		return;
	}

    Remembered_Set *merge(Remembered_Set *rs) {
		return (Remembered_Set *)Hash_Table::merge((Hash_Table *)rs);
	}

    inline bool is_present(Java_java_lang_Object **address) {
		return Hash_Table::is_present((void *)address);
	}

    inline bool is_not_present(Java_java_lang_Object **address) {
		return Hash_Table::is_not_present((void *)address);
	}

	inline Java_java_lang_Object **next(void) {
		return (Java_java_lang_Object **)Hash_Table::next();
	}

	inline Java_java_lang_Object **next_delete(void) {
		return (Java_java_lang_Object **)Hash_Table::next_delete();
	}

	//
	// Update any entries pointing to the old target with the new.
	//
    inline void update_target(Java_java_lang_Object *p_old_obj,
		                      Java_java_lang_Object *p_new_obj) {
		Hash_Table::update_target((void **)p_old_obj, (void *)p_new_obj);
	}
#if (GC_DEBUG>3)
    //
    // Verify that none of the references point to objects in obsolete spaces.
    //
    void verify_no_obsolete_references();
#endif
};

#endif // _Remembered_Set_H_

