// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/orp_cout.cpp,v 1.2 2001/08/03 03:13:39 xli18 Exp $
//


#include "platform.h"
#include "orp_cout.h"

// orp_out is used to isolate/contain the use of C++ cout
// the goal is to make the ORP independent of C++ libraries
// and thus make it easier to port


orp_out& endl(orp_out& jo)
{
    printf("\n");
    fflush(stdout);
    return jo;
}

orp_out& flush(orp_out& jo)
{
    fflush(stdout);
    return jo;
}

orp_out& hex(orp_out& jo)
{
    jo.hex = true;
    return jo;
}

orp_out& dec(orp_out& jo)
{
    jo.hex = false;
    return jo;
}


orp_out& orp_out::operator<< (const char *string_x)
    {
        printf("%s", string_x);
        return *this;
    }


    orp_out& orp_out::operator<< (int int_x)
    {
        printf((hex ? "%x" : "%d"), int_x);
        return *this;
    }


    orp_out& orp_out::operator<< (unsigned unsigned_x)
    {
        printf((hex ? "%x" : "%u"), unsigned_x);
        return *this;
    }


    orp_out& orp_out::operator<< (unsigned long ul_x)
    {
        printf((hex ? "%x" : "%u"), ul_x);
        return *this;
    }


    orp_out& orp_out::operator<< (__int64 u64_x)
    {
        printf((hex ? "%x" : "%u"), u64_x);
        return *this;
    }


    orp_out& orp_out::operator<< (double double_x)
    {
        printf("%f", double_x);
        return *this;
    }

    orp_out& orp_out::operator<< (const void *ptr)
    {
        printf("%p", ptr);
        return *this;
    }

//#ifdef ORP_POSIX
    // fix this
//#else
    orp_out& orp_out::operator<<(orp_out& (* _f)(orp_out&)) 
    { 
        (*_f)(*this); 
        return *this; 
    }
//#endif // ORP_POSIX

    orp_out::orp_out() { hex = false; }
