// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_util_Date.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//

#include "platform.h"
#include "jni.h"
#include "assert.h"
#include "time.h"

#include "java_util_Date.h"

/*
 * Class:     java_util_Date
 * Method:    toString
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT jstring JNICALL Java_java_util_Date_toString
  (JNIEnv *jenv, jobject jobj)
{
	// Need to return the Date in the form : 
	// " dow mon dd hh:mm:ss zzz yyyy"

	jclass date_class = jenv->FindClass("java/util/Date");	
	assert(date_class);
	jfieldID millis_field = jenv->GetFieldID(date_class, "millis", "J");
	assert(millis_field);
	jlong millis = jenv->GetLongField(jobj, millis_field);
	assert(millis >= 0);

	// Are we losing data with "time_t" being declared "long" i.e. 32bit ??
	assert((__int64)((__int32)(millis/1000)) == (__int64)(millis/1000));

	const time_t time = (time_t) (millis / 1000);
	// Now use "ctime" to get the string.
	const char *time_string = ctime(&time);
	assert(time_string);
	jstring ret_string = jenv->NewStringUTF(time_string);
	assert(ret_string);
	return ret_string;
} // Java_java_util_Date_toString







