// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_VMSystem.cpp,v 1.6 2002/01/14 01:14:15 gwu2 Exp $
//


#include "platform.h"
#include "orp_utils.h"

#include "jni.h"
#include "native_utils.h"
#include "jni_utils.h"
#include "jni_direct.h"
#include <sys/types.h>
#include <sys/stat.h>
#include "environment.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#else
#include "object_generic.h"
#endif

#ifdef ORP_NT
#include <direct.h>
#else
#include <unistd.h>
#include <sys/utsname.h>
#endif
#include "java_lang_VMSystem.h"
#include "properties.h"

/*
 * Class:     VMSystem
 * Method:    insertSystemProperties
 * Signature: (Ljava/util/Properties;)V
 */

JNIEXPORT void JNICALL Java_java_lang_VMSystem_insertSystemProperties(JNIEnv *jenv, jclass clazz, jobject pProperties)
{

	// Now, insert all the default properties.

    char local[_MAX_PATH];

    void __stdcall PropPut(JNIEnv *env, jobject pObj, char *pProp, char *pVal);

    PropPut(jenv, pProperties, "user.language", "en");
    PropPut(jenv, pProperties, "java.home", ".");
    PropPut(jenv, pProperties, "java.version", "GNU Classpath 0.02");
    PropPut(jenv, pProperties, "java.vendor", "GNU/FSF");
	PropPut(jenv, pProperties, "java.vm.name", "Open Runtime Platform");
    PropPut(jenv, pProperties, "java.vm.version", "1.09");
    PropPut(jenv, pProperties, "java.vm.vendor", "Intel MRL");

#ifdef ORP_NT
    PropPut(jenv, pProperties, "file.separator", "\\");
#else
    PropPut(jenv, pProperties, "file.separator", "/");
#endif

    PropPut(jenv, pProperties, "line.separator", "\n");
    PropPut(jenv, pProperties, "user.region", "US");
    PropPut(jenv, pProperties, "file.encoding", "8859_1");
    PropPut(jenv, pProperties, "java.vendor", "Intel MRL");
    PropPut(jenv, pProperties, "user.name", "ssubram5");
    PropPut(jenv, pProperties, "os.arch", "x86");

#ifdef ORP_NT
	OSVERSIONINFO vi;
	vi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if(!GetVersionEx(&vi)){
		PropPut(jenv, pProperties, "os.name", "Windows NT");
		PropPut(jenv, pProperties, "os.version", "4.0");
	}else{
		assert(vi.dwPlatformId == VER_PLATFORM_WIN32_NT);
		if(vi.dwMajorVersion < 5)
			PropPut(jenv, pProperties, "os.name", "Windows NT");
		else
			PropPut(jenv, pProperties, "os.name", "Windows 2000");
		char buf[20];
		sprintf(buf, "%d.%d", vi.dwMajorVersion, vi.dwMinorVersion);
		PropPut(jenv, pProperties, "os.version", buf);
	}
#else
	struct utsname buf;
	if(uname(&buf)){
		PropPut(jenv, pProperties, "os.name", "Linux");
		PropPut(jenv, pProperties, "os.version", "6.1");
	}else{
		PropPut(jenv, pProperties, "os.name", buf.sysname);
		PropPut(jenv, pProperties, "os.version", buf.release);
	}
#endif

    PropPut(jenv, pProperties, "java.vendor.url", "http://www.intel.com/");
#ifdef ORP_NT
    PropPut(jenv, pProperties, "user.dir", _getcwd(local, _MAX_PATH));
	char *tmpdir = getenv("TEMP");
	PropPut(jenv, pProperties, "java.tmpdir", tmpdir != NULL ? tmpdir: ".");
#else
    PropPut(jenv, pProperties, "user.dir", getcwd(local, _MAX_PATH));
	PropPut(jenv, pProperties, "java.tmpdir", "/tmp");
#endif
    PropPut(jenv, pProperties, "java.class.path", ORP_Global_State::loader_env->classpath);
    PropPut(jenv, pProperties, "java.class.version", "45.3");

#ifdef ORP_NT
    PropPut(jenv, pProperties, "path.separator", ";");
#else
    PropPut(jenv, pProperties, "path.separator", ":");
#endif

    PropPut(jenv, pProperties, "user.home", ".");

//ORP specified/APP specified properties are supported here.
    Properties::Iterator *iterator = ORP_Global_State::loader_env->properties.getIterator();
	const Prop_entry *next = NULL;
	while(next = iterator->next()){
		PropPut(jenv, pProperties, next->key, ((Prop_String*)next->value)->value);
	}
	
} //Java_java_lang_VMSystem_insertSystemProperties





/*
 * Class:     java_lang_VMSystem
 * Method:    identityHashCode
 * Signature: (Ljava/lang/Object;)I
 */


JNIEXPORT jint JNICALL Java_java_lang_VMSystem_identityHashCode
  (JNIEnv *jenv, jclass clazz, jobject jobj)
{
	Object_Handle h = (Object_Handle)jobj;
    
	Java_java_lang_Object *p_obj = h->java_reference;

    if (!p_obj) return 0;
        return (jint) generic_hashcode(p_obj);

} // Java_java_lang_System_identityHashCode








