// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_VMClassLoader.cpp,v 1.7 2001/12/19 08:21:00 gwu2 Exp $
//


#include "platform.h"
#include "orp_utils.h"

#include "jni.h"
#include "native_utils.h"
#include "jni_utils.h"
#include "jni_direct.h"


#include "java_lang_VMClassLoader.h"


/*
 * Class:     java_lang_VMClassLoader
 * Method:    defineClass
 * Signature: (Ljava/lang/ClassLoader;Ljava/lang/String;[BII)Ljava/lang/Class;
 */

JNIEXPORT jclass JNICALL Java_java_lang_VMClassLoader_defineClass
  (JNIEnv *jenv, jclass p_this, jobject cl, jstring name, jbyteArray data, jint offset, jint len)
{
	const char* clssname = NULL;
	if(name){
		jint strlen;
		clssname = JavaStringToCharArray(jenv, name, &strlen);
#if 0
		printf("define Class: %s\n", clssname);
#endif
	}

	jboolean is_copy;
	jbyte *bytes = jenv->GetByteArrayElements(data, &is_copy);
   	assert(bytes);

	jclass clss = DefineClass(jenv, clssname, cl, bytes + offset, len);

	jenv->ReleaseByteArrayElements(data, bytes, 0);
	
	if(clssname)
		free((void*)clssname);

	return clss;
}

/*
 * Class:     java_lang_VMClassLoader
 * Method:    defineClass1
 * Signature: (Ljava/lang/ClassLoader;Ljava/lang/String;[BIILjava/security/ProtectionDomain)Ljava/lang/Class;
 */
JNIEXPORT jclass JNICALL Java_java_lang_VMClassLoader_defineClass1
  (JNIEnv *jenv, jclass p_this, jobject cl, jstring name, jbyteArray data, jint offset, jint len, jobject domain)
{
	jclass clazz = Java_java_lang_VMClassLoader_defineClass(jenv, p_this, cl, name, data, offset, len);
	jclass jlc = FindClass(jenv, "java/lang/Class");
	jmethodID mthd = GetMethodID(jenv, jlc, "setProtectionDomain", "(Ljava/security/ProtectionDomain;)V");
	CallVoidMethod(jenv, clazz, mthd, domain);

	return clazz;
}

/*
 * Class:     java_lang_VMClassLoader
 * Method:    getPrimitiveClass
 * Signature: (Ljava/lang/String;)Ljava/lang/Class;
 */

JNIEXPORT jclass JNICALL Java_java_lang_VMClassLoader_getPrimitiveClass
  (JNIEnv *jenv, jclass p_this, jstring class_name)
{
	jint strlen;
    const char* clssname = JavaStringToCharArray(jenv, class_name, &strlen);
	assert (clssname);

	jclass primclazz = jenv->FindClass(clssname);
	assert(primclazz);
	
	free((void*)clssname);
	
    return primclazz; 
}


/*
 * Class:     java_lang_VMClassLoader
 * Method:    resolveClass
 * Signature: (Ljava/lang/Class;)V
 */

JNIEXPORT void JNICALL Java_java_lang_VMClassLoader_resolveClass
  (JNIEnv *jenv, jclass p_this, jclass clazz)
{
	Object_Handle h = (Object_Handle)clazz;
    Class *clss = (Class *)h->java_reference;
	extern Loader_Exception resolve_const_pool(Class *clss, Global_Env& env);
	orp_disable_gc();
	Loader_Exception ld_exc = resolve_const_pool(clss, *(ORP_Global_State::loader_env));
	orp_enable_gc();
	if(ld_exc != LD_NoException){
		switch(ld_exc) {
        case LD_NoClassDefFoundError:
            clazz = FindClass(jenv, "java/lang/NoClassDefFoundError");
            break;
        case LD_ClassCircularityError:
            clazz = FindClass(jenv, "java/lang/ClassCircularityError");
            break;
        case LD_IncompatibleClassChangeError:
            clazz = FindClass(jenv, "java/lang/IncompatibleClassChangeError");
            break;
        case LD_ClassFormatError:
        default:
            clazz = FindClass(jenv, "java/lang/ClassFormatError");
            break;
        }
        ThrowNew(jenv, clazz, "resolveClass failed");
	}
}

/* ORP implemented it as native
 * Class:     java_lang_Class
 * Method:    findLoadedClass
 * Signature: (Ljava/lang/String;)Ljava/lang/Class;
 */
#include "Class_Loader.h"
#include "environment.h"
JNIEXPORT jclass JNICALL Java_java_lang_VMClassLoader_findLoadedClass
	(JNIEnv *jenv, jclass pthis, jobject loader, jstring name)
{
	jint strlen;
    const char* clssname = JavaStringToCharArray(jenv, name, &strlen);
	assert (clssname);
	BOOL alloced = FALSE;
	if(strchr(clssname, '.')){
		char *buff = (char *)malloc(strlen + 5); 
		for(int i = 0; i < strlen; i++) {
			if(clssname[i] == '.') 
				buff[i] = '/';
			else
				buff[i] = clssname[i];
		}
		buff[strlen] = '\0';
		free((void*)clssname); //free old memory clssname pointed to
		clssname = buff;
		alloced = TRUE;
	}
	String *str = ORP_Global_State::loader_env->string_pool.lookup(clssname);
	free((void*)clssname);
	Class *clss = ORP_Global_State::loader_env->class_table.lookup(str);
	if(!clss){
		Java_java_lang_Object *loaderobj = ((Object_Handle)loader)->java_reference;
		Class_Loader *_loader = Class_Loader::find_if_exists((Java_java_lang_Object*)loaderobj);
		if(!_loader)
			return NULL;
		clss = _loader->lookup_class(str);
		if(!clss)return NULL;
	}
	Object_Handle h = orp_create_local_object_handle();
	h->java_reference = (Java_java_lang_Object*)clss;
	return h;
}

