// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Thread.cpp,v 1.6 2001/12/10 09:40:11 gwu2 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifndef ORP_POSIX
#include "orp_process.h"
#endif

#include "environment.h"
#include "orp_types.h"
#include "orp_utils.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "ini.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "jit_intf.h"
#include "orp_synch.h"
#include "exception_filter.h"

#include "java_lang_Object.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#include "thread_generic_olv2.h"
#include "thread_manager_olv2.h"
#else
#include "object_generic.h"
#include "thread_generic.h"
#include "thread_manager.h"
#endif

#include "java_lang_Thread.h"
#include "enum_trampoline.h"
#include "sync_bits.h"
#include "orp_stats.h"

#ifdef ORP_NT
// wjw -- following lines needs to be generic for all OSs
#include "java_lang_thread_nt.h"
#endif

#ifdef POINTER64
#include "java_lang_thread_ia64.h"
#else
#include "java_lang_thread_ia32.h"
#endif


#ifdef _DEBUG
///////////extern Object_Handle orp_create_global_object_handle();
#endif

#include "jni.h"
#include "jvmdi_clean.h"


///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_thread_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Thread.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////


void start_of_thread_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}


void java_lang_Thread_registerNatives(Java_java_lang_Thread *) 
{
} //java_lang_Thread_registerNatives


void java_lang_Thread_sleep(Java_java_lang_Thread *p_this, int64 msec, int32 nsec) 
{
    java_lang_Thread_sleep_generic(msec);   // p_this and nsec are ignored 
}



Java_java_lang_Thread *java_lang_Thread_currentThread(Java_java_lang_Thread *none) 

{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);
    return (Java_java_lang_Thread *)p_TLS_orpthread->p_java_lang_thread; 
} //java_lang_Thread_currentThread


void java_lang_Thread_nativeInit(Java_java_lang_Thread *none) 
{
    // do nothing on purpose
}


void java_lang_Thread_nativeDestroy(Java_java_lang_Thread *none) 
{
    // do nothing on purpose
}


void java_lang_Thread_nativeInterrupt(Java_java_lang_Thread *none) 
{
    // not implemented
    // orp_cout << "So far ORP doesn't support Thread.interrupt." << endl;
    // assert(0);
}


void java_lang_Thread_start(Java_java_lang_Thread *p_this) 
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    volatile Java_java_lang_Object *p_this_volatile = (volatile Java_java_lang_Object *)p_this;

    java_lang_Thread_start_generic(p_this_volatile);
}


void java_lang_Thread_interrupt(Java_java_lang_Thread *p_java_thr) 
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    volatile Java_java_lang_Object *p_java_thr_volatile = 
                    (volatile Java_java_lang_Object *)p_java_thr;

    java_lang_Thread_interrupt_generic(p_java_thr_volatile);
}


void java_lang_Thread_yield (Java_java_lang_Thread *not_used) 
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    orp_enable_gc();    

    SleepEx(0, false);

    orp_disable_gc();
} //java_lang_Thread_yield


void java_lang_Thread_nativeSetPriority(Java_java_lang_Thread *p_this, int32 pri)
{
#if 0 
    if (p_this == 0)
        return; // non existant thread

    ORP_thread *p_orpthread = get_orp_thread_ptr( (void *)p_this);

    if (p_orpthread == 0)
        return;  // non existant thread

    java_lang_Thread_setPriority_generic(p_orpthread, pri);
#endif
}


int32 java_lang_Thread_countStackFrames(Java_java_lang_Thread *not_used) 
{
    orp_cout << "java_lang_Thread_countStackFrames is deprecated and not implemented" << endl;
    return 1;
}


void java_lang_Thread_nativeResume(Java_java_lang_Thread *not_used) 
{
    orp_cout << "java_lang_Thread_resume is deprecated and not implemented" << endl;
}


void java_lang_Thread_nativeStop(Java_java_lang_Thread *not_used, Java_java_lang_Object *exception)
{
    orp_cout << "java_lang_Thread_stop is deprecated and not implemented" << endl;
}


void java_lang_Thread_nativeSuspend(Java_java_lang_Thread *not_used) 
{
    orp_cout << "java_lang_Thread_suspend is deprecated and not implemented" << endl;
}



int32 java_lang_Thread_isAlive(Java_java_lang_Thread *p_java_thr)
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);
    volatile Java_java_lang_Thread *p_java_thr_volatile = p_java_thr;

    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_java_thr_volatile, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    if (p_java_thr_volatile == 0) {
        p_thread_lock->_unlock_enum();
        return 0;
    }

     Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_java_thr_volatile;
    if (p_jlt->data == 0) {
        p_thread_lock->_unlock_enum();
        return 0; // don't try to isAlive() non-existant thread
    }

   // toss  ORP_thread * p_thr = (ORP_thread *) (p_java_thr_volatile->PrivateInfo);

    ORP_thread *p_orpthread = get_orp_thread_ptr( (void *)p_java_thr_volatile);

    if (p_orpthread == 0) {
        p_thread_lock->_unlock_enum();
        return 0; // don't try to isAlive() non-existant thread
    }
    if (p_orpthread->app_status == zip) {
        p_thread_lock->_unlock_enum();
        return 0;  // don't try to isAlive() non-existant thread
    }
    java_state as = p_orpthread->app_status;  

    p_thread_lock->_unlock_enum();
 
    // According to JAVA spec, this method should return true, if and
    // only if the thread has been started and not yet died.

 
    switch (as) {
 
        case thread_is_sleeping:
        case thread_is_waiting:
        case thread_is_running:
            return 1; 
            break;

        case thread_is_dying:
        case thread_is_birthing:   
            return 0; 
            break;

        default:
            assert(0);
            orp_cout << "big problem in java_lang_Thread_isAlive()" << endl;
            return 0;
            break;
    }
    assert(0);  // must return from inside the switch statement

} //java_lang_Thread_isAlive



void java_lang_Thread_join(Java_java_lang_Thread *p_java_thr, int64 timeout, int32 nanos) 
{
    volatile Java_java_lang_Thread *p_obj_volatile = p_java_thr;
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_obj_volatile, sizeof(void *) );

    orp_monitor_enter( (Java_java_lang_Object *)p_obj_volatile);

    if (java_lang_Thread_isAlive( (Java_java_lang_Thread *)p_obj_volatile) )
        java_lang_Object_wait( (Java_java_lang_Object *)p_obj_volatile, timeout);

    orp_monitor_exit( (Java_java_lang_Object *)p_obj_volatile);

    orp_pop_gc_frame(&gcf1);    
}

int32 java_lang_Thread_isInterrupted(Java_java_lang_Thread *p_java_thr)
{
    ORP_thread *p_thr = get_orp_thread_ptr((void *)p_java_thr);
    assert(p_thr);

    return p_thr->interrupt_a_waiting_thread;
}

///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_thread_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Thread.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_thread_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Thread.cpp
////////////// SEE in_busybit_critical_zone() for details
}
