// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common_olv2/mon_enter_exit.cpp,v 1.28 2002/01/11 11:31:48 xli18 Exp $
//

#ifdef OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "orp_types.h"
#include "object_layout.h"
#include "orp_threads.h"
#include "jit_runtime_support.h"
#include "exceptions.h"

#include "mon_enter_exit_olv2.h"
#include "thread_generic_olv2.h"
#include "object_generic_olv2.h"

#include "orp_stats.h"

#ifdef ORP_POSIX
#include "platform2.h"
#ifdef __linux__
#include <asm/bitops.h>
#endif
#endif


static int mon_wakeup_array[MAX_ORP_THREADS];

///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_object_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void start_of_mon_enter_exit_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

#ifdef LAZY_LOCK

Java_java_lang_Object *lazylist[1000];
int num_lazylock = (int)lazylist; //actually it's a pointer to next free slot in lazylist
bool bMultithreaded;

#ifdef ORP_STATS
void lazy_monitor_enter_check(){
	assert( num_lazylock >= (int)lazylist );
	assert( *(int **)num_lazylock !=NULL );
	orp_stats_total.num_lazy_monitor_enter++;
}

void lazy_monitor_exit_check(){
	assert( (num_lazylock-4) >= (int)lazylist );
	assert( *(int **)(num_lazylock-4) != NULL );
	orp_stats_total.num_lazy_monitor_exit++;
}
#endif //ORP_STATS

#endif //LAZY_LOCK

volatile int active_thread_count;


mon_enter_fields mon_enter_array[MAX_ORP_THREADS];

void set_contention_bit(Java_java_lang_Object *p_obj)
{
    // the contention bit shares the same byte as the 7-bit hash
    // since setting the hash happens only once, there need be only one
    // lock cmpxchg on this byte ever -- to set the hash bits.
    // Once the hash bits are set, the contention bit can then be set without
    // any lock cmpxchg

    if ( HASH_CONTENTION(p_obj) & CONTENTION_MASK)
        return; // contention bit already set

    if ( HASH_CONTENTION(p_obj) & HASH_MASK)
    {
        // got here because someone previously set the hash bits
        // no need to lock cmpxchg h_byte[HASH_CONTENTION_SLOT] -- the hash bits can't change anymore
        HASH_CONTENTION(p_obj) = 
            HASH_CONTENTION(p_obj) | CONTENTION_MASK;
        return;
    }

    // must set the hash bits before setting the contention bit
    set_hash_bits(p_obj);

    HASH_CONTENTION(p_obj) = 
        HASH_CONTENTION(p_obj) | CONTENTION_MASK;
}
#pragma warning(push)
#pragma warning(disable:4172)
unsigned int get_stack_pointer(){
    unsigned char s;
	return (unsigned int)&s;
}
#pragma warning(pop)

static ORP_thread *monitor_get_thread_ptr(Java_java_lang_Object *p_obj)
{
   
    uint32 pp_thr =(uint32)STACK_KEY(p_obj) << STACK_KEY_SHIFT;

    if( pp_thr ) 
        return *(ORP_thread **)( pp_thr + thread_local_storage_offset );
    else 
        return 0;
}

Java_java_lang_Object *block_on_mon_enter(Java_java_lang_Object *p_obj)
{
	//printf("******************************to block enter %d\n", p_TLS_orpthread->thread_handle);

    ORP_thread *p_thr = get_thread_ptr();

    DWORD stat;

    assert(mon_enter_array[p_thr->thread_index].p_obj == 0);

    set_contention_bit(p_obj);

#ifdef _DEBUG
    int loop_count = 0;
#endif

    //since p_obj may be moved by GC in the below loop, we need to reload after gc_enable/disable
    volatile Java_java_lang_Object *volatile_p_obj = (Java_java_lang_Object *)p_obj;


    while (1) {

		mon_enter_array[p_thr->thread_index].p_obj = (Java_java_lang_Object *)volatile_p_obj;

#ifdef _DEBUG
        loop_count++;
        if (loop_count > max_block_on_mon_enter_loops)
            max_block_on_mon_enter_loops = loop_count;
#endif
        if ( STACK_KEY(volatile_p_obj) == 0)
        {
            mon_enter_array[p_thr->thread_index].p_obj = 0;

            unsigned short retval = orp_try_monitor_enter( (Java_java_lang_Object *)volatile_p_obj);
            if (retval == TRY_MON_ENTER_SUCCEEDED){
	        //printf("******************************finish block enter %d\n", p_TLS_orpthread->thread_handle);
				return (Java_java_lang_Object *)volatile_p_obj;
			}
            else continue;
        }

        // cache_enter(p_obj, p_thr);
#ifdef CONCURRENCY_ANALYSIS
        ORP_thread *p_blocker = monitor_get_thread_ptr((Java_java_lang_Object *)volatile_p_obj);
        if(!p_blocker) continue;
        int p_blocker_tid = p_blocker->thread_index;
        uint64 start = readTimeStampCounter();
#endif //#ifdef CONCURRENCY_ANALYSIS
        orp_enable_gc(); 
        stat = WaitForSingleObject(p_thr->event_handle_monitor, INFINITE);
        orp_disable_gc();

        // by convention, *only* mon_enter_array and mon_wait_array will be enumerated to the GC
        // thus reload from mon_enter_array[] after the waitforsingleobject returns
		assert(mon_enter_array[p_thr->thread_index].p_obj->vt->clss->p_vtable->clss->p_vtable);
        volatile_p_obj = (volatile Java_java_lang_Object *)
                            mon_enter_array[p_thr->thread_index].p_obj;

        // cache_delete(p_obj, p_thr);
#ifdef CONCURRENCY_ANALYSIS
        uint64 end = readTimeStampCounter();
        int p_waker_tid = mon_wakeup_array[p_thr->thread_index];
        assert(p_waker_tid);
        assert(p_blocker_tid);
#ifdef ORP_POSIX
        fprintf(f_concur, 
            "MONITOR_BLOCKING_START( monitor_oid = %d, blocked_tid = %d, blocker_tid = %d, time = %llu )\n",
            generic_hashcode((Java_java_lang_Object *)volatile_p_obj),
            p_thr->thread_index, p_blocker_tid, start );
        fprintf(f_concur, 
            "MONITOR_BLOCKING_END( monitor_oid = %d, blocked_tid = %d, waker_tid = %d, time = %llu )\n",
            generic_hashcode((Java_java_lang_Object *)volatile_p_obj),
            p_thr->thread_index, p_waker_tid, end );
#else
        fprintf(f_concur, 
            "MONITOR_BLOCKING_START( monitor_oid = %d, blocked_tid = %d, blocker_tid = %d, time = %I64u )\n",
            generic_hashcode((Java_java_lang_Object *)volatile_p_obj),
            p_thr->thread_index, p_blocker_tid, start );
        fprintf(f_concur, 
            "MONITOR_BLOCKING_END( monitor_oid = %d, blocked_tid = %d, waker_tid = %d, time = %I64u )\n",
            generic_hashcode((Java_java_lang_Object *)volatile_p_obj),
            p_thr->thread_index, p_waker_tid, end );
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS

        assert( (stat == WAIT_OBJECT_0) || (stat == WAIT_TIMEOUT));

#ifdef _DEBUG /*
        if (stat == WAIT_TIMEOUT)
            printf("NOTE: block_on_mon_enter()  ---> timeout\n");
			*/
#endif
    } //while(1)
}


void find_an_interested_thread(Java_java_lang_Object *p_obj)
{
    if ( ( HASH_CONTENTION(p_obj) & CONTENTION_MASK) == 0)
        return;  // nobody wants this object

    // cache_lookup(p_obj);
    // return;

    DWORD stat;
    int xx;

    for (xx = 1; xx < next_thread_index; xx++)
    {
        if (mon_enter_array[xx].p_obj == p_obj)
        {
#ifdef CONCURRENCY_ANALYSIS
            mon_wakeup_array[xx] = p_TLS_orpthread->thread_index ;
            assert(mon_wakeup_array[xx]);
#endif //#ifdef CONCURRENCY_ANALYSIS
            stat = SetEvent(mon_enter_array[xx].p_thr->event_handle_monitor);
            assert(stat);

            return;
        }
    }
}


void orp_enumerate_root_set_mon_arrays()
{
    int xx;

    for (xx = 1; xx < next_thread_index; xx++)
    {
        if (mon_enter_array[xx].p_obj){
			assert( STACK_KEY( mon_enter_array[xx].p_obj) != mon_enter_array[xx].p_thr->stack_key );
            orp_enumerate_root_reference(0, (void **)&(mon_enter_array[xx].p_obj));
		}

        if (mon_wait_array[xx].p_obj){
			assert( mon_wait_array[xx].p_thr->app_status == thread_is_waiting);
            orp_enumerate_root_reference(0, (void **)&(mon_wait_array[xx].p_obj));
		}
    }
}

void mon_enter_recursion_overflowed(Java_java_lang_Object *p_obj)
{
    assert(0); //TODO: add the backup algorithm for recursion overflow

}

void throw_java_exception_wrapper(const char *string_of_ExceptionName){

    throw_java_exception(string_of_ExceptionName);
}

extern uint32 address_of_setup_java_to_native_frame;
extern uint32 address_of_pop_java_to_native_frame;
void orp_monitor_init()
{
#if defined(USE_IA64_JIT)
#else
    address_of_setup_java_to_native_frame = (uint32)getaddress__setup_java_to_native_frame();
    address_of_pop_java_to_native_frame = (uint32)getaddress__pop_java_to_native_frame();
#endif
}

#ifdef ORP_POSIX
#define LOCK_PREFIX "lock"
#else
#define LOCK_PREFIX lock
#endif

inline void pause(void){
#ifdef ORP_POSIX
	__asm__(
#if !((__GLIBC__ == 2) && (__GLIBC_MINOR__ <= 1))
		"pause"
#else
		"nop;nop;nop"
#endif
		::: "memory"
	);

#else
	_asm{ 
		pause
	}

#endif

}

inline uint16 LockedCompareExchangeUint16( 
						uint16 *Destination,
						uint16 Exchange,
						uint16 Comperand
						)
{
#ifdef ORP_POSIX

	__asm__(
		LOCK_PREFIX "\tcmpxchgw %1, (%2)"
        :"=a"(Comperand)
        :"d"(Exchange), "r"(Destination), "a"(Comperand) 
	);

#else
	__asm {
		mov ax,  Comperand
		mov dx,  Exchange
		mov ecx, Destination
		LOCK_PREFIX cmpxchg [ecx], dx
		mov Comperand, ax
	}

#endif //#ifdef ORP_POSIX
    
	return Comperand;
}

inline uint8 LockedCompareExchangeUint8(
						uint8 *Destination,
						uint8 Exchange,
						uint8 Comperand
						)
{
#ifdef ORP_POSIX

	__asm__(
		LOCK_PREFIX "\tcmpxchgb %1, (%2)\t\n"
		:"=al"(Comperand)
		:"dl"(Exchange), "r"(Destination), "al"(Comperand) 
	);

#else
	__asm {
		mov al,  Comperand
		mov dl,  Exchange
		mov ecx, Destination
		LOCK_PREFIX cmpxchg [ecx], dl
		mov Comperand, al
	}
    
#endif //#ifdef ORP_POSIX
	return Comperand;
}


//return the old monitor stack key, so that 0 means success, otherwise failure;
uint16 __stdcall orp_try_monitor_enter(Java_java_lang_Object *p_obj)
{
	uint16 current_stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;
	uint16 *p_monitor_stack_key = P_STACK_KEY(p_obj);
	uint16 old_stack_key = FREE_MONITOR;
	old_stack_key = LockedCompareExchangeUint16( p_monitor_stack_key, current_stack_key, FREE_MONITOR);
	if( old_stack_key == FREE_MONITOR ){	
		
		return old_stack_key;

	}else if( old_stack_key == current_stack_key ){ //recursed
		if( ++RECURSION(p_obj) ); 
		else{ //recursion overflowed
			mon_enter_recursion_overflowed(p_obj);
		}

		return old_stack_key; 
	}

	//hold by other thread
	return old_stack_key; 
}

uint16 __stdcall orp_monitor_enter_slow(Java_java_lang_Object *p_obj)
{
#ifdef LAZY_LOCK
	if(	!bMultithreaded){
		*((struct  Java_java_lang_Object **)num_lazylock) = p_obj;

#ifdef ORP_STATS
        lazy_monitor_enter_check();
#endif
		num_lazylock += sizeof(POINTER_SIZE_INT)/sizeof(BYTE);
		return 0xf0f0;
	}
#endif //LAZY_LOCK

	uint16 current_stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;
	uint16 *p_stack_key = P_STACK_KEY(p_obj);
	uint16 old_stack_key = FREE_MONITOR;
    
	if( *p_stack_key == FREE_MONITOR ){	//common case, fastest
		old_stack_key = LockedCompareExchangeUint16( p_stack_key, current_stack_key, FREE_MONITOR);
		if( old_stack_key == FREE_MONITOR ){ //ok, got it
			return old_stack_key; 
		}

	}else if( *p_stack_key == current_stack_key ){ //recursed
		if( ++RECURSION(p_obj) ); 
		else{ //recursion overflowed
			mon_enter_recursion_overflowed(p_obj);
		}
		return current_stack_key;
	}

	//hold by other thread, let's spin look for a short while

	unsigned int i = SPIN_LOOP_COUNT;
	while( i-- ){
		pause();
		if( ! *p_stack_key ){ //monitor is free now, try to get it
			old_stack_key = FREE_MONITOR;
			old_stack_key = LockedCompareExchangeUint16( p_stack_key, current_stack_key, old_stack_key);
			if( old_stack_key == FREE_MONITOR ){ //ok, got it
				return old_stack_key; 
			}
		}
	}

	//we have no way to get the lock, then sleep; since GC can move the object, we reload it
	p_obj = block_on_mon_enter(p_obj);

	assert(p_obj->vt->clss->p_vtable->clss->p_vtable);
	if( STACK_KEY(p_obj) != current_stack_key ){
		orp_cout << "Wrong monitor states after GC: " << p_obj << 
			"(" << p_obj->vt->clss->name->bytes << ")" << endl;
		exit(9747);
	}

	return current_stack_key;

}


uint16 __stdcall orp_monitor_exit(Java_java_lang_Object *p_obj)
{
#ifdef LAZY_LOCK
    if(	!bMultithreaded){      
#ifdef ORP_STATS
        lazy_monitor_exit_check();
#endif
        num_lazylock -= sizeof(POINTER_SIZE_INT)/sizeof(BYTE);
        if( *((struct  Java_java_lang_Object **)num_lazylock) != p_obj){
            assert(0); //BUG, only for debug; if hit, then remove it
            throw_java_exception("java/lang/IllegalMonitorStateException");
        }

#ifdef _DEBUG
        *((struct  Java_java_lang_Object **)num_lazylock) = 0;
#endif
        return 	0xf0f0;

    }
#endif //LAZY_LOCK

	assert(p_obj->vt->clss->p_vtable->clss->p_vtable);
	uint16 current_stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;
	uint16 *p_monitor_stack_key = P_STACK_KEY(p_obj);
    if( *p_monitor_stack_key == current_stack_key ){ //common case, fastest path
		if( !RECURSION(p_obj) ){ //no recursion
			STACK_KEY(p_obj) = 0; //release the lock

			if( HASH_CONTENTION(p_obj) & CONTENTION_MASK ){ //contented
				find_an_interested_thread(p_obj);
			}
		
		}else{ //recursed
			RECURSION(p_obj)-- ;	
		}
		
	}else{ //illegal monitor state
		assert(0);
		throw_java_exception("java/lang/IllegalMonitorStateException");
	}

	return *p_monitor_stack_key;
}




void set_hash_bits(Java_java_lang_Object *p_obj)
{
    uint8 hb = ((uint8)((unsigned)p_obj >> 3)) & HASH_MASK  ;
    // lowest 3 bits are not random enough so get rid of them

    if (hb == 0)
        hb = 23;  // NO hash = zero allowed, thus hard map hb = 0 to a fixed prime number

    // don't care if the cmpxchg fails -- just means someone else already set the hash
	LockedCompareExchangeUint8(P_HASH_CONTENTION(p_obj), hb, 0);
}



///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_object_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_mon_enter_exit_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

 
#endif //#ifdef OBJECT_LOCK_V2

