// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_load_store.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//



#ifndef _CG_LOAD_STORE_H_
#define _CG_LOAD_STORE_H_

extern X86_Reg_No reg_var_allocated_to(int index, Jit_Method_Info *method_info);

extern void gen_reg_store32(Code_Emitter& emitter,
							Stack& stack,
							X86_Reg_No reg,
							Operand *src);

extern void gen_int_load(Mem_Manager& mem_manager,
						 Code_Emitter& emitter,
						 Stack& stack,
						 Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
						 Frame& frame,
						 unsigned index,
						 unsigned is_ref);


extern void gen_int_store(Code_Emitter& emitter,
						  Stack& stack,
						  CG_Prepass& prepass,
						  Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
						  Frame& frame,
						  unsigned index);

class Bounds_Checking;
extern void gen_astore( Code_Emitter& emitter,
						Stack& stack,
						CG_Prepass& prepass,
						Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
						Frame& frame,
						unsigned index,
						const unsigned char *curr_bc
#ifndef NO_BOUNDS_CHECKING
						, Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                        );

extern void gen_iinc(Code_Emitter& emitter,Stack& stack,
			  Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
			  Frame& frame,unsigned index,int imm);

#endif // _CG_LOAD_STORE_H_