/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef PLATFORM_UNIX
#include <vcl.h>
#pragma hdrstop
#else
#include "linux_inc.h"
#endif

#include "anm.h"
#include "art.h"

int ANMFile::findpage(int framenumber)
{
	int i;

	for(i=0; i<lpheader.nLps; i++)
	{
		if(LpArray[i].baseRecord <= framenumber && LpArray[i].baseRecord + LpArray[i].nRecords > framenumber)
			return(i);
	}
	return(i);
}

void ANMFile::loadpage(int pagenumber)
{
    curlpnum=pagenumber;
    memcpy(&curlp,&file[0xb00+(pagenumber*0x10000)],sizeof(lp_descriptor));
    thepage=&file[0xb00+(pagenumber*0x10000)+sizeof(lp_descriptor)+2];
}

void ANMFile::CPlayRunSkipDump(unsigned char *srcP,unsigned char *dstP)
{
	char cnt;
	unsigned short wordCnt;
	unsigned char pixel;

#ifdef PLATFORM_UNIX
	int left = 1;	// This isn't right - DDOI
// FIXME find out where left comes from
#endif
nextOp:
    cnt = (signed char) *srcP++;
    if (cnt > 0)
        goto dump;
    if (cnt == 0)
        goto run;
    cnt -= 0x80;
    if (cnt == 0)
        goto longOp;
    dstP += cnt;
    goto nextOp;
dump:
    do
    {
        *dstP++ = *srcP++;
        if (!left) return;
    } while (--cnt);
    dstP += cnt;
    srcP += cnt;
    goto nextOp;
run:
    wordCnt = (unsigned char)*srcP++;
    pixel = *srcP++;
    do
    {
        *dstP++ = pixel;
        if (!left) return;
    } while (--wordCnt);

    dstP += wordCnt;
    goto nextOp;
longOp:
    wordCnt = *((unsigned short *)srcP)++;
    if ((short)wordCnt <= 0)
        goto notLongSkip;
    dstP += wordCnt;
    goto nextOp;
notLongSkip:
    if (wordCnt == 0)
        return;
    wordCnt -= 0x8000;		// Remove sign bit.
    if (wordCnt >= 0x4000)
        goto longRun;
	do
    {
	    *dstP++ = *srcP++;
        if (!left) return;
    } while (--wordCnt);
    dstP += wordCnt;
    srcP += wordCnt;
    goto nextOp;
longRun:
    wordCnt -= 0x4000;		// Clear "longRun" bit.
    pixel = *srcP++;
    do
    {
        *dstP++ = pixel;
        if (!left) return;
    } while (--wordCnt);
    dstP += wordCnt;
    goto nextOp;
}

// Draw the frame sepcified from the large page in the buffer pointed to
void ANMFile::renderframe(int framenumber,unsigned short *pagepointer,int updateTexture)
{
	int offset=0;
	int i;
	int destframe;
	unsigned char *ppointer;

	destframe = framenumber - curlp.baseRecord;
	for(i = 0; i < destframe; i++)
		offset += pagepointer[i];
	ppointer = (unsigned char *)pagepointer;
	ppointer+=curlp.nRecords*2+offset;
	if(ppointer[1])
		ppointer += (4 + (((unsigned short *)ppointer)[1] + (((unsigned short *)ppointer)[1] & 1)));
	else
		ppointer+=4;
	CPlayRunSkipDump(ppointer, screen);
    for (int y=0;y<200;y++)
    {
        for (int x=0;x<320;x++)
        {
            screen2[y*512+x]=screen[y*320+x];
            tex->memTex.data[y*512+x]=pal[screen[y*320+x]];
        }
    }
    if (updateTexture)
        render->UpdateMemoryTexture(tex);
}

void ANMFile::drawframe(int framenumber,int updateTexture)
{
	loadpage(findpage(framenumber));
	renderframe(framenumber, (unsigned short *)thepage,updateTexture);
}

int ANMFile::NextFrame()
{
    framecount++;
    if (framecount>=(lpheader.nRecords-1))
        return 0;
    drawframe(framecount,1);
    return 1;
}

int ANMFile::Seek(int frameNum)
{
    if (frameNum>=(lpheader.nRecords-1))
        return 0;
    if (frameNum<framecount)
    {
        for (framecount=0;framecount<frameNum;framecount++)
            drawframe(framecount,0);
        drawframe(framecount,1);
        return 1;
    }
    else if (frameNum>framecount)
    {
        for (;framecount<frameNum;framecount++)
            drawframe(framecount,0);
        drawframe(framecount,1);
        return 1;
    }
    return 1;
}

ANMFile::ANMFile(GroupFile *group,char *name,Art *_art)
{
    file=NULL; tex=NULL;
    art=_art;
    if (group->FileSize(name)==-1)
        throw "Animation file does not exist";
#ifdef PLATFORM_UNIX
    file=new char[group->FileSize(name)];
#else
    file=new unsigned char[group->FileSize(name)];
#endif
    group->LoadFile(name,file);
    curlpnum=-1;
    memcpy(&lpheader,file,sizeof(lpfileheader));
	// Read in the color palette
    unsigned char palData[768];
	for(int i=0;i<256;i++)
	{
		int b=file[(i<<2)+128+sizeof(lpfileheader)];
		int g=file[(i<<2)+129+sizeof(lpfileheader)];
		int r=file[(i<<2)+130+sizeof(lpfileheader)];
        pal[i]=((r>>3)<<10)|((g>>3)<<5)|(b>>3)|0x8000;
        palData[i*3]=r>>2;
        palData[i*3+1]=g>>2;
        palData[i*3+2]=b>>2;
	}
    int pn=art->FindFreePalette();
    art->LoadPalette(pn,palData);
	// Read in large page descriptors
    memcpy(LpArray,&file[128+256*4+sizeof(lpfileheader)],sizeof(lp_descriptor)*256);
    // Create a texture for the animation (width and
    // height must be a power of 2 on most video cards)
    tex=new Texture;
    tex->location=TLOC_MEMORY;
    tex->memTex.width=512;
    tex->memTex.height=256;
    tex->memTex.data=new unsigned short[512*256];
    tex->pal=pn;
    tex->data=screen2=new unsigned char[512*256];
    render->CreateMemoryTexture(tex);
    // Create a 320x200 version to simplify the
    // decompression code
    screen=new unsigned char[320*200];
	drawframe(0,1); // draw the first frame of the file
    framecount=0;
}

ANMFile::~ANMFile()
{
    art->FreePalette(tex->pal);
    if (file) delete[] file;
    if (tex) delete tex;
}

void ANMFile::RecreateTexture()
{
    tex->data=screen2;
    render->CreateMemoryTexture(tex);
}

void ANMFile::FreeTextureMem()
{
    // Free texture memory (but not the original
    // data in system memory)
    render->FreeTexture(tex);
}

#pragma package(smart_init)
