/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef mapH
#define mapH

#include "GroupFile.h"
#include "poly.h"
#include "art.h"
#include "SoftRender.h"

#define POLYTYPE_WALL 0
#define POLYTYPE_FLOOR 1
#define POLYTYPE_CEILING 2
#define POLYTYPE_SPRITE 3

// These structures are directly from Build help
typedef struct
{
    short wallptr, wallnum;
    long ceilingz, floorz;
    short ceilingstat, floorstat;
    short ceilingpicnum, ceilingheinum;
    signed char ceilingshade;
    unsigned char ceilingpal, ceilingxpanning, ceilingypanning;
    short floorpicnum, floorheinum;
	signed char floorshade;
	unsigned char floorpal, floorxpanning, floorypanning;
	unsigned char visibility, filler;
	short lotag, hitag, extra;
} SectorType;

typedef struct
{
    long x, y;
	short point2, nextwall, nextsector, cstat;
	short picnum, overpicnum;
	signed char shade;
	unsigned char pal, xrepeat, yrepeat, xpanning, ypanning;
	short lotag, hitag, extra;
} WallType;

typedef struct
{
    long x, y, z;
	short cstat, picnum;
	signed char shade;
    unsigned char pal, clipdist, filler;
    unsigned char xrepeat, yrepeat;
    signed char xoffset, yoffset;
    short sectnum, statnum;
    short ang, owner, xvel, yvel, zvel;
	short lotag, hitag, extra;
} SpriteType;
//---------------------------------------------------------------------------
class Art;

class Map
{
    GroupFile *group;
    Art *art;
    float CalcFloorZ(int i,int wallIndex);
    float CalcCeilingZ(int i,int wallIndex);
    void AddWallPoly(int i,int wallIndex);
    void AddFloorToFloorWallPoly(int i,int wallIndex);
    void AddCeilingToCeilingWallPoly(int i,int wallIndex);
    void AddFloorPoly(int i);
    void AddCeilingPoly(int i);
    bool IsPtInTriangle(ProjVertex *v1,ProjVertex *v2,ProjVertex *v3,int x,int y);
    bool IsPtInPoly(Poly& poly,int ptX,int ptY,float& z);
    bool hideSpecialSprites;
public:
    // heh, I know these are "supposed" to be
    // protected/private but this is a rendering
    // engine and speed is the key :)
    SectorType *sector;
    WallType *wall;
    SpriteType *sprite;
    int startX,startY,startZ,startAng,startSect;
    int numSectors,numWalls,numSprites;
    PolyList *sectorPolys;
    PolyList *sectorWindowPolys;
    PolyList *spritePolys;
    int *sectorDrawn;
    int *spriteDrawn;

    Map(GroupFile *group,char *name,Art *art);
    ~Map();
    int IsInSector(int sectNum,int x,int y,int z);
    void ConvertSectorToPolyList(int sectNum);
    void ConvertSpriteToPolyList(int spriteNum);
    float CalcFloorZAtPt(int i,float x,float y);
    float CalcCeilingZAtPt(int i,float x,float y);
    float AngleToRadian(int ang);
    void MakeSpriteFaceViewer(int spriteNum);
    void HideSpecialSprites(bool hide);
    int FindPolyAtPoint(int x,int y,int& type,int& index,int& sect);
};

#endif
