
-- DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

-- Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.

-- The contents of this file are subject to the terms of either the GNU
-- General Public License Version 2 only ("GPL") or the Common
-- Development and Distribution License("CDDL") (collectively, the
-- "License"). You may not use this file except in compliance with the
-- License. You can obtain a copy of the License at
-- http://www.netbeans.org/cddl-gplv2.html
-- or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
-- specific language governing permissions and limitations under the
-- License.  When distributing the software, include this License Header
-- Notice in each file and include the License file at
-- nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
-- particular file as subject to the "Classpath" exception as provided
-- by Sun in the GPL Version 2 section of the License file that
-- accompanied this code. If applicable, add the following below the
-- License Header, with the fields enclosed by brackets [] replaced by
-- your own identifying information:
-- "Portions Copyrighted [year] [name of copyright owner]"

-- Contributor(s):

-- The Original Software is NetBeans. The Initial Developer of the Original
-- Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
-- Microsystems, Inc. All Rights Reserved.

-- If you wish your version of this file to be governed by only the CDDL
-- or only the GPL Version 2, indicate your decision by adding
-- "[Contributor] elects to include this software in this distribution
-- under the [CDDL or GPL Version 2] license." If you do not indicate a
-- single choice of license, a recipient has the option to distribute
-- your version of this file under either the CDDL, the GPL Version 2 or
-- to extend the choice of license to its licensees as provided above.
-- However, if you add GPL Version 2 code and therefore, elected the GPL
-- Version 2 license, then the option applies only if the new code is
-- made subject to such option by the copyright holder.

-- JSC Jump Start Cycles (assumes you already have a "jsc" schema)
-- create tables

CREATE TABLE jsc.creditCardType (
    creditCardTypeId    INTEGER               NOT NULL,
    name                VARCHAR(50)           NOT NULL,
    CONSTRAINT jsc_creditCardType_pk          PRIMARY KEY ( creditCardTypeId )
);


CREATE TABLE jsc.customer (
    customerId    INTEGER                     NOT NULL,
    userId        VARCHAR(50)                 NOT NULL,
    lastName      VARCHAR(50)                 ,
    firstName     VARCHAR(50)                 ,
    emailAddress  VARCHAR(50)                 NOT NULL,
    password      VARCHAR(50)                 NOT NULL,
    creditCardNo  VARCHAR(50)                 ,
    expirationDate DATE                       , 
    securityCode   VARCHAR(50)                ,
    cardTypeId       INTEGER                  ,
    CONSTRAINT jsc_customer_pk                PRIMARY KEY ( customerId ),
    CONSTRAINT jsc_customer_emailAddress_uq   UNIQUE      ( emailAddress ),
    CONSTRAINT jsc_customer_CreditCardTypeId  FOREIGN KEY ( cardTypeId )
        REFERENCES jsc.creditCardType ( creditCardTypeId )
);

CREATE TABLE jsc.addressType (
    addressTypeId       INTEGER               NOT NULL,
    name                VARCHAR(50)           NOT NULL,
    CONSTRAINT jsc_addressType_pk             PRIMARY KEY ( addressTypeId )
);

CREATE TABLE jsc.address (
    addressId      INTEGER                    NOT NULL,
    customerId     INTEGER                    NOT NULL,
    addressTypeId  INTEGER                    NOT NULL,
    line1          VARCHAR(50)                ,
    line2          VARCHAR(50)                ,
    city           VARCHAR(50)                ,
    state          VARCHAR(50)                ,
    postalCode     VARCHAR(50)                ,
    country        VARCHAR(50)                ,
    fax            VARCHAR(50)                ,
    phone          VARCHAR(50)                ,
    phoneExt        VARCHAR(50)               ,
    CONSTRAINT jsc_address_pk                 PRIMARY KEY ( addressId ),
    CONSTRAINT jsc_address_customerId         FOREIGN KEY ( customerId )
        REFERENCES jsc.customer ( customerId ),
    CONSTRAINT jsc_address_addressTypeId      FOREIGN KEY ( addressTypeId )
        REFERENCES jsc.addressType ( addressTypeId )
);


CREATE TABLE jsc.partType (
    partTypeId         INTEGER                NOT NULL,
    label              VARCHAR(50)            NOT NULL,
    name               VARCHAR(50)            NOT NULL,
    downURL            VARCHAR(2048)          NOT NULL,
    upURL              VARCHAR(2048)          NOT NULL,
    CONSTRAINT jsc_partType_pk                PRIMARY KEY ( partTypeId )
);

CREATE TABLE jsc.part (
    partId             INTEGER                NOT NULL,
    partTYpeId         INTEGER                NOT NULL,
    name               VARCHAR(50)            NOT NULL,
    descr              VARCHAR(2048)          , 
    price	       DECIMAL                NOT NULL,
    squareURL          VARCHAR(2048)          NOT NULL,
    rectangleURL       VARCHAR(2048)          NOT NULL,
    overlayURL         VARCHAR(2048)          NOT NULL,
    CONSTRAINT jsc_part_pk                    PRIMARY KEY ( partId ),
    CONSTRAINT jsc_part_partTypeId            FOREIGN KEY ( partTypeId )
        REFERENCES jsc.partType ( partTypeId )
);

CREATE TABLE jsc.bikeOrder (
    orderId              INTEGER               NOT NULL,
    customerId           INTEGER               NOT NULL,
    orderCreatedDate	 DATE		       NOT NULL,	
    shipToAddressId      INTEGER               NOT NULL,
    shippingCost         DECIMAL               NOT NULL,
    tax                  DECIMAL               NOT NULL,
    total 		 DECIMAL               NOT NULL,
    specialInstructions  VARCHAR(2048)         ,
    orderShippedDate     DATE                  ,
    CONSTRAINT jsc_order_pk                    PRIMARY KEY ( orderId ),
    CONSTRAINT jsc_order_customerId            FOREIGN KEY ( customerId )
        REFERENCES jsc.customer ( customerId ),
    CONSTRAINT jsc_order_shipToaddressId      FOREIGN KEY ( shipToAddressId )
        REFERENCES jsc.address ( addressId )
);

CREATE TABLE jsc.orderLineItem (
    orderLineItemId    INTEGER                 NOT NULL,
    orderId            INTEGER                 NOT NULL,
    partId             INTEGER                 NOT NULL,
    quantity	       INTEGER                 , 
    CONSTRAINT jsc_orderLineItem_pk            PRIMARY KEY ( orderLineItemId ),
    CONSTRAINT jsc_orderLineItem_orderId       FOREIGN KEY ( orderId )
        REFERENCES jsc.bikeOrder ( orderId ),
    CONSTRAINT jsc_orderLineItem_partId        FOREIGN KEY ( partId )
        REFERENCES jsc.part ( partId )
);
 
CREATE TABLE jsc.validation_table (
    keycol    INTEGER 
) ;


create view jsc.orderHistory as select * from jsc.bikeOrder;


