/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.namespace.NamespaceContext;
import org.netbeans.modules.j2ee.websphere6.config.sync.WarSynchronizer;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSWebBnd;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSWebExt;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.*;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.*;
//dkumar - import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.websphere6.util.*;
import org.openide.util.Exceptions;

public class WarDeploymentConfiguration extends WSDeploymentConfiguration
        implements PropertyChangeListener {
    
    private File []file;
    
    private String contextRoot;
    WSWebBnd wsWebBnd;
    WSWebExt wsWebExt;
    
    
    public static final String WEB_APP_ID = "WebApp";
    /**
     * Creates a new instance of WarDeploymentConfiguration
     */
    public WarDeploymentConfiguration(DeploymentManager dm,DeployableObject deployableObject,InstanceProperties ip) throws InvalidModuleException{
        super(dm,deployableObject,ip);
    }
    
    /**
     * WarDeploymentConfiguration initialization. This method should be called before
     * this class is being used.
     *
     *
     */
    public void init(File []file) {
        this.file = file;
        getWSWebBnd();
        getWSWebExt();
        
        String path;
        path=(file.length>0)?file[0].getPath():"";
        path=path.substring(0,path.lastIndexOf(File.separator)+1);
        File webInfFile = new File(path+"web.xml");
        File ibmwebbndFile = null;
        
        if(file.length<=0) return;
        if (dataObjects == null) {
            dataObjects = new DataObject[file.length];
            try {
                for(int i=0;i<dataObjects.length;i++) {
                    dataObjects [i]= dataObjects[i].find(FileUtil.toFileObject(file[i]));
                    dataObjects[i].addPropertyChangeListener(this);
                }
            } catch(DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace(donfe);
            }
        }
        for (int i = 0; i < file.length; i++) {
            WSDebug.notify(file[i].getName());
            if (file[i].getName().equals("ibm-web-bnd.xmi")) {
                ibmwebbndFile = file[i];
            }
        }
        
        if(webInfFile.exists()) {
            String contents = WSUtil.readFile(webInfFile );
            String ID = "id=\""+WEB_APP_ID+"\"";
            if(contents!=null && contents.indexOf(ID)==-1) {
                String WebAppTagOpen = "<web-app";
                String WebAppTagClose = ">";
                int startIndex = contents.indexOf(WebAppTagOpen);
                if(startIndex!=-1) {
                    String afterTageOpen = contents.substring(startIndex + WebAppTagOpen.length());
                    String tag = afterTageOpen.substring(0,afterTageOpen.indexOf(WebAppTagClose));
                    if(tag.indexOf(ID)==-1) {
                        WSUtil.writeFile(webInfFile , contents.replaceFirst(WebAppTagOpen + " ",
                                WebAppTagOpen + " " + ID +" \n        "));
                    }
                }
            }
            final WarSynchronizer webSync = new WarSynchronizer (webInfFile, ibmwebbndFile);
            webSync.addSyncFile(webInfFile);            
        }
        
    }
    
    /**
     * Return context path.
     *
     * @return context path or null, if the file is not parseable.
     */
    public String getContextPath() throws ConfigurationException {
        return contextRoot;
    }
    
    /**
     * Listen to websphere.xml document changes.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == DataObject.PROP_MODIFIED &&
                evt.getNewValue() == Boolean.FALSE) {
            // dataobject has been modified, WSWeb{Ext,Bnd} graph is out of sync
            wsWebExt = null;
            wsWebBnd = null;
        }
    }
    
    /**
     * Return WSWebBnd graph. If it was not created yet, load it from the file
     * and cache it. If the file does not exist, generate it.
     *
     *
     * @return WSWebBnd graph or null if the ibm-web-bnd.xml file is not parseable.
     */
    public synchronized WSWebBnd getWSWebBnd() {
        if (wsWebBnd == null) {
            try {
                for (int i = 0; i < file.length; i++) {
                    if (!(file[i].getName().equals("ibm-web-bnd.xmi"))) {
                        continue;
                    }
                    if (file[i].exists()) {
                        
                        // load configuration if already exists
                        try {
                            WSWebBnd wsWebBnd = new WSWebBnd(file[i], false);
                        } catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        } catch (RuntimeException re) {
                            // websphere.xml is not parseable, do nothing
                        }
                    } else {
                        // create websphere.xml if it does not exist yet
                        wsWebBnd = new WSWebBnd();
                        wsWebBnd.setDefaults();
                        writefile(file[i], wsWebBnd);
                    }
                }
            } catch (ConfigurationException ce) {
                Exceptions.printStackTrace(ce);
            }
        }
        return wsWebBnd;
    }
    
    
    /**
     * Return WSWebBnd graph. If it was not created yet, load it from the file
     * and cache it. If the file does not exist, generate it.
     *
     *
     * @return WSWebBnd graph or null if the ibm-web-bnd.xml file is not parseable.
     */
    public synchronized WSWebExt getWSWebExt() {
        if (wsWebExt == null) {
            try {
                for (int i = 0; i < file.length; i++) {
                    if (!(file[i].getName().equals("ibm-web-ext.xmi"))) {
                        continue;
                    }
                    if (file[i].exists()) {
                        
                        // load configuration if already exists
                        try {
                            WSWebExt wsWebExt = new WSWebExt(file[i], false);
                        } catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        } catch (RuntimeException re) {
                            // websphere.xml is not parseable, do nothing
                        }
                    } else {
                        // create websphere.xml if it does not exist yet
                        wsWebExt = new WSWebExt();
                        wsWebExt.setDefaults();
                        writefile(file[i], wsWebExt);
                    }
                }
            } catch (ConfigurationException ce) {
                Exceptions.printStackTrace(ce);
            }
        }
        return wsWebExt;
    }
    
    
    
    // JSR-88 methods ---------------------------------------------------------
    /*
    public void save(OutputStream os) throws ConfigurationException {
        WSWebBnd wsWebBnd = getWSWebBnd();
        WSWebExt wsWebExt = getWSWebExt();
        if (wsWebExt == null || wsWebBnd==null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state."); // NOI18N
        }
        try {
            wsWebBnd.write(os);
            wsWebExt.write(os);
        } catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }
     
     
    /**
     * Replace the content of the document by the graph.
     */
    private void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write(out);
        } catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
        }
        NbDocument.runAtomic(doc, new Runnable() {
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                } catch (BadLocationException ble) {
                    Exceptions.printStackTrace(ble);
                }
            }
        });
    }
    
    // TODO: this contextPath fix code will be removed, as soon as it will
    // be moved to the web project
    private boolean isCorrectCP(String contextPath) {
        boolean correct=true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) correct=false; //NOI18N
        else if (contextPath.endsWith("/")) correct=false; //NOI18N
        else if (contextPath.indexOf("//")>=0) correct=false; //NOI18N
        return correct;
    }
    
    
    /**
     * Set context path.
     */
    public void setContextPath(String contextPath)  {
        // TODO: this contextPath fix code will be removed, as soon as it will
        // be moved to the web project
        if (!isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            java.util.StringTokenizer tok = new java.util.StringTokenizer(contextPath,"/"); //NOI18N
            StringBuffer buf = new StringBuffer(); //NOI18N
            while (tok.hasMoreTokens()) {
                buf.append("/"+tok.nextToken()); //NOI18N
            }
            ctxRoot = buf.toString();
            NotifyDescriptor desc = new NotifyDescriptor.Message(
                    NbBundle.getMessage(WarDeploymentConfiguration.class, "MSG_invalidCP", contextPath),
                    NotifyDescriptor.Message.INFORMATION_MESSAGE);
            DialogDisplayer.getDefault().notify(desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        contextRoot=contextPath;
    }
    
    // private helper interface -----------------------------------------------
    
    private interface WSWebBndModifier {
        void modify(WSWebBnd context);
    }
    private interface WSWebExtModifier {
        void modify(WSWebExt context);
    }
    
    private class WebNSC implements NamespaceContext {
        public String getPrefix(String namespaceURI) {
            return "webbnd";
        }
        public String getNamespaceURI(String prefix) {
            return "webbnd.xmi";
        }
        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
    
    
}
