/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * MdbConnectionFactoryPanel.java        October 27, 2003, 3:59 PM
 *
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.util.ResourceBundle;
import javax.swing.JPanel;

import org.netbeans.modules.j2ee.sun.dd.api.common.DefaultResourcePrincipal;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.MdbConnectionFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.MDEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;

/**
 *
 * @author  Rajeshwar Patil
 * @version %I%, %G%
 */
public class MdbConnectionFactoryPanel extends JPanel {

    private MDEjbCustomizer masterPanel;

    private final ResourceBundle bundle = ResourceBundle.getBundle(
            "org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule.Bundle"); // NOI18N


    /** Creates new form MdbConnectionFactoryPanel */
    public MdbConnectionFactoryPanel(MDEjbCustomizer src) {
        this.masterPanel = src;
        
        initComponents();
        initUserComponents();
    }

//    public java.util.Collection getErrors() {
//        if(validationSupport == null) assert(false);
//        ArrayList errors = new ArrayList();
//
//        //Mdb Connection Factory fields Validation
//        
//        String property;
//        boolean mdbConnectionFactoryPresent = isMdbConnectionFactoryPresent();
//        if(mdbConnectionFactoryPresent) {
//            property = jndiNameTextField.getText();
//            errors.addAll(validationSupport.validate(property,
//                "/sun-ejb-jar/enterprise-beans/ejb/mdb-connection-factory/jndi-name", //NOI18N
//                    bundle.getString("LBL_Jndi_Name")));                    //NOI18N
//        }
//
//        boolean resourcePrincipalPresent = isDefaultResourcePrincipalPresent();
//        if(resourcePrincipalPresent) {
//            property = nameTextField.getText();
//            errors.addAll(validationSupport.validate(property,
//                "/sun-ejb-jar/enterprise-beans/ejb/mdb-connection-factory/default-resource-principal/name", //NOI18N
//                    bundle.getString("LBL_Name")));                     //NOI18N
//
//            property = passwordTextField.getText();
//            errors.addAll(validationSupport.validate(property,
//                "/sun-ejb-jar/enterprise-beans/ejb/mdb-connection-factory/default-resource-principal/password", //NOI18N
//                    bundle.getString("LBL_Password")));                 //NOI18N
//
//        }
//
//        return errors;
//    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jndiNamePanel = new javax.swing.JPanel();
        jndiNameLabel = new javax.swing.JLabel();
        jndiNameTextField = new javax.swing.JTextField();
        defaultResourcePrincipalLabel = new javax.swing.JLabel();
        defaultResourcePrincipalPanel = new javax.swing.JPanel();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        passwordLabel = new javax.swing.JLabel();
        passwordTextField = new javax.swing.JTextField();
        fillerPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jndiNamePanel.setLayout(new java.awt.GridBagLayout());

        jndiNameLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Mdb_Conn_Fctry_Jndi_Name").charAt(0));
        jndiNameLabel.setLabelFor(jndiNameTextField);
        jndiNameLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Jndi_Name_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jndiNamePanel.add(jndiNameLabel, gridBagConstraints);
        jndiNameLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Jndi_Name_Acsbl_Name"));
        jndiNameLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mdb_Conn_Fctry_Jndi_Name_Acsbl_Desc"));

        jndiNameTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mdb_Conn_Fctry_Jndi_Name_Tool_Tip"));
        jndiNameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jndiNameKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jndiNamePanel.add(jndiNameTextField, gridBagConstraints);
        jndiNameTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Jndi_Name_Acsbl_Name"));
        jndiNameTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mdb_Conn_Fctry_Jndi_Name_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jndiNamePanel, gridBagConstraints);

        defaultResourcePrincipalLabel.setLabelFor(defaultResourcePrincipalPanel);
        defaultResourcePrincipalLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Default_Resource_Principal"));
        defaultResourcePrincipalLabel.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(defaultResourcePrincipalLabel, gridBagConstraints);

        defaultResourcePrincipalPanel.setLayout(new java.awt.GridBagLayout());

        defaultResourcePrincipalPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        nameLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Mdb_Conn_Fctry_Name").charAt(0));
        nameLabel.setLabelFor(nameTextField);
        nameLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Name_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        defaultResourcePrincipalPanel.add(nameLabel, gridBagConstraints);
        nameLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Name_Acsbl_Name"));
        nameLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Name_Acsbl_Desc"));

        nameTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Name_Tool_Tip"));
        nameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                nameKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        defaultResourcePrincipalPanel.add(nameTextField, gridBagConstraints);
        nameTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Name_Acsbl_Name"));
        nameTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Name_Acsbl_Desc"));

        passwordLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Mdb_Conn_Fctry_Password").charAt(0));
        passwordLabel.setLabelFor(passwordTextField);
        passwordLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Password_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 18, 5, 0);
        defaultResourcePrincipalPanel.add(passwordLabel, gridBagConstraints);
        passwordLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Password_Acsbl_Name"));
        passwordLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Password_Acsbl_Desc"));

        passwordTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Password_Tool_Tip"));
        passwordTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                passwordKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        defaultResourcePrincipalPanel.add(passwordTextField, gridBagConstraints);
        passwordTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Password_Acsbl_Name"));
        passwordTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Dflt_Res_Prncpl_Password_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 5, 5);
        add(defaultResourcePrincipalPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(fillerPanel, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void passwordKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_passwordKeyReleased
        MDEjb theBean = masterPanel.getMDBean();
        if(theBean != null) {
            MdbConnectionFactory connectionFactory = theBean.getMdbConnectionFactory();
            DefaultResourcePrincipal drp = connectionFactory.getDefaultResourcePrincipal();
            String newPassword = passwordTextField.getText();
            String oldPassword = (drp != null) ? drp.getPassword() : null;

            if(!Utils.strEquivalent(oldPassword, newPassword)) {
                if(Utils.notEmpty(newPassword)) {
                    if(drp == null) {
                        drp = connectionFactory.newDefaultResourcePrincipal();
                        connectionFactory.setDefaultResourcePrincipal(drp);
                    }
                    drp.setPassword(newPassword);
                } else if(drp != null) {
                    if(Utils.notEmpty(drp.getName())) {
                        drp.setPassword(null);
                    } else {
                        connectionFactory.setDefaultResourcePrincipal(null);
                    }
                }
                
                theBean.firePropertyChange("mdbConnFactoryDrpPassword", oldPassword, newPassword); // NOI18N
                masterPanel.validateField(MDEjb.FIELD_MD_CONNFACTORY);
            }
        }
    }//GEN-LAST:event_passwordKeyReleased

    private void nameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_nameKeyReleased
        MDEjb theBean = masterPanel.getMDBean();
        if(theBean != null) {
            MdbConnectionFactory connectionFactory = theBean.getMdbConnectionFactory();
            DefaultResourcePrincipal drp = connectionFactory.getDefaultResourcePrincipal();
            String newName = nameTextField.getText();
            String oldName = (drp != null) ? drp.getName() : null;

            if(!Utils.strEquivalent(oldName, newName)) {
                if(Utils.notEmpty(newName)) {
                    if(drp == null) {
                        drp = connectionFactory.newDefaultResourcePrincipal();
                        connectionFactory.setDefaultResourcePrincipal(drp);
                    }
                    drp.setName(newName);
                } else if(drp != null) {
                    if(Utils.notEmpty(drp.getPassword())) {
                        drp.setName(null);
                    } else {
                        connectionFactory.setDefaultResourcePrincipal(null);
                    }
                }
                
                theBean.firePropertyChange("mdbConnFactoryDrpName", oldName, newName); // NOI18N
                masterPanel.validateField(MDEjb.FIELD_MD_CONNFACTORY);
            }
        }
    }//GEN-LAST:event_nameKeyReleased

    private void jndiNameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jndiNameKeyReleased
        MDEjb theBean = masterPanel.getMDBean();
        if(theBean != null) {
            MdbConnectionFactory connectionFactory = theBean.getMdbConnectionFactory();
            String newJndiName = jndiNameTextField.getText();
            String oldJndiName = connectionFactory.getJndiName();

            if(!Utils.strEquivalent(oldJndiName, newJndiName)) {
                if(Utils.notEmpty(newJndiName)) {
                    connectionFactory.setJndiName(newJndiName);
                } else {
                    connectionFactory.setJndiName(null);
                }

                theBean.firePropertyChange("mdbConnFactoryJndiName", oldJndiName, newJndiName); // NOI18N
                masterPanel.validateField(MDEjb.FIELD_MD_CONNFACTORY);
           }
        }
    }//GEN-LAST:event_jndiNameKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel defaultResourcePrincipalLabel;
    private javax.swing.JPanel defaultResourcePrincipalPanel;
    private javax.swing.JPanel fillerPanel;
    private javax.swing.JLabel jndiNameLabel;
    private javax.swing.JPanel jndiNamePanel;
    private javax.swing.JTextField jndiNameTextField;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel passwordLabel;
    private javax.swing.JTextField passwordTextField;
    // End of variables declaration//GEN-END:variables
    
    private void initUserComponents() {
        putClientProperty(EjbCustomizer.PARTITION_KEY, ValidationError.PARTITION_EJB_MDBCONNFACTORY);
    }
    
    public void initFields(MDEjb theBean) {
        String jndiName = null;
        String name = null;
        String password = null;
        
        if(theBean != null) {
            MdbConnectionFactory connectionFactory = theBean.getMdbConnectionFactory();
            jndiName = connectionFactory.getJndiName();
            
            DefaultResourcePrincipal drp = connectionFactory.getDefaultResourcePrincipal();
            if(drp != null) {
                name = drp.getName();
                password = drp.getPassword();
            }
        }
        
        jndiNameTextField.setText(jndiName);
        nameTextField.setText(name);
        passwordTextField.setText(password);
    }
}
