/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.api;

import java.util.Collection;
import org.netbeans.spi.viewmodel.ModelEvent;


/** Represents a node in variables model.  Passed back to debugger api for use by
 *  the debugger UI.
 *
 * @author Peter Williams
 */
public interface VariableNode {

    // These refer to public icon resources in the NB debugger/core module.
    public static final String LOCAL_VARIABLE_ICON =
            "org/netbeans/modules/debugger/resources/localsView/LocalVariable"; // NOI18N
    public static final String SCRIPT_FIELD_ICON =
            "org/netbeans/modules/debugger/resources/watchesView/Field"; // NOI18N
    public static final String SUPER_ICON =
            "org/netbeans/modules/debugger/resources/watchesView/SuperVariable"; // NOI18N
    public static final String JAVA_FIELD_ICON =
            "org/netbeans/modules/debugger/resources/classesView/Classes"; // NOI18N

    // !PW FIXME these references are hacks.  Find a way to put in more appropriate icons
    // or remove the usage of these.
    public static final String UNDEFINED_FIELD_ICON =
            "org/netbeans/modules/phobos/localdebugger/resources/undefined"; // NOI18N
    public static final String FUNCTION_ICON =
            "org/netbeans/modules/phobos/localdebugger/resources/function"; // NOI18N
    public static final String SCRIPT_ADAPTER_ICON =
            "org/netbeans/modules/debugger/resources/watchesView/StaticModifier"; // NOI18N

    // For use by the watch window.
    public static final String WATCH_ICON =
            "org/netbeans/modules/debugger/resources/watchesView/Watch"; // NOI18N


    // Important: Numeric order of these contants must match order of icons in
    // array below them.
    public static final int TYPE_LOCAL_FIELD = 0;
    public static final int TYPE_SCRIPT_FIELD = 1;
    public static final int TYPE_JAVA_FIELD = 2;
    public static final int TYPE_UNDEFINED_FIELD = 3;
    public static final int TYPE_SUPER = 4;
    public static final int TYPE_SCRIPT_ADAPTER = 5;
    public static final int TYPE_FUNCTION = 6;
    public static final int TYPE_WATCH = 7;

    // ------------------------------------------------------------------------
    // public api for use by the debugger
    // ------------------------------------------------------------------------
    public String getName();

    public String getDisplayName();

    public String getShortDescription();

    public String getIconBase();

    public int getType();

    public String getTypeName();

    public Object getValue();

    public boolean isReadOnly();
    
    public String getTooltipValue();

    public VariableNode[] getChildren(int from, int to);

    public boolean isLeaf();

    public int getChildrenCount();

    // ------------------------------------------------------------------------
    // Private api for use by the model to manage the tree
    // FIXME Need to find a better way to expose these capabilities.
    // ------------------------------------------------------------------------

    public void collectUpdates(Object source, Collection<ModelEvent> events, VariableNode newVar);
}
