/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.ruby.extrahints.introduce;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/**
 *
 * @author Jan Lahoda
 */
public class IntroduceVariablePanel extends javax.swing.JPanel {

    private boolean introduceConstant;
    private Set<String> takenNames;
    private JButton btnOk;

    public IntroduceVariablePanel(int numDuplicates, String defaultName, boolean introduceConstant,
            JButton btnOk, Set<String> takenNames) {
        this.btnOk = btnOk;
        this.takenNames = takenNames;

        initComponents();

        this.introduceConstant = introduceConstant;

        Preferences pref = getPreferences(introduceConstant);
        if (numDuplicates == 1) {
            replaceAll.setEnabled(false);
            replaceAll.setSelected(false);
        } else {
            replaceAll.setEnabled(true);
            replaceAll.setText(replaceAll.getText() + " (" + numDuplicates + ")");
            replaceAll.setSelected(pref.getBoolean("replaceAll", true)); //NOI18N
        }

        // Replace All not yet implemented
        replaceAll.setVisible(numDuplicates > 1);

        name.setText(defaultName);
        if (name != null && defaultName.trim().length() > 0) {
            this.name.setCaretPosition(defaultName.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(defaultName.length());
        }
    }

    private Preferences getPreferences(boolean introduceConstant) {
        return NbPreferences.forModule(IntroduceVariablePanel.class).node(introduceConstant ? "introduceConstant" : "introduceVariable"); //NOI18N
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator() {

            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyIdentifier(text)) {
                    return getDefaultErrorMessage(text);
                }

                if (takenNames.contains(text)) {
                    return NbBundle.getMessage(IntroduceVariablePanel.class, "LocalAlreadyExists", text);
                }

                return null;
            }
        };

        final ErrorLabel errorLabel = new ErrorLabel(name.getDocument(), validator);
        errorLabel.addPropertyChangeListener(ErrorLabel.PROP_IS_VALID, new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent e) {
                btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        btnOk.setEnabled(errorLabel.isInputTextValid());
        return errorLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return NbBundle.getMessage(IntroduceVariablePanel.class, introduceConstant ? "ConstantAlreadyExists" : "NotValidIdentifier", inputText);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        accessGroup = new javax.swing.ButtonGroup();
        lblName = new javax.swing.JLabel();
        name = new javax.swing.JTextField();
        replaceAll = new javax.swing.JCheckBox();
        errorLabel = createErrorLabel();

        lblName.setLabelFor(name);
        org.openide.awt.Mnemonics.setLocalizedText(lblName, org.openide.util.NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_Name")); // NOI18N

        name.setColumns(20);

        org.openide.awt.Mnemonics.setLocalizedText(replaceAll, org.openide.util.NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_ReplaceAll")); // NOI18N
        replaceAll.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(errorLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 483, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(lblName)
                        .add(18, 18, 18)
                        .add(name, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 425, Short.MAX_VALUE))
                    .add(replaceAll))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblName)
                    .add(name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(replaceAll)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 64, Short.MAX_VALUE)
                .add(errorLabel)
                .addContainerGap())
        );

        name.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(IntroduceVariablePanel.class, "AD_IntrVar_Name")); // NOI18N
        replaceAll.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(IntroduceVariablePanel.class, "AD_IntrVar_ReplaceAllOccurences")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(IntroduceVariablePanel.class, "AD_IntrVar_Dialog")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup accessGroup;
    private javax.swing.JLabel errorLabel;
    private javax.swing.JLabel lblName;
    private javax.swing.JTextField name;
    private javax.swing.JCheckBox replaceAll;
    // End of variables declaration//GEN-END:variables
//    private Set<Modifier> testAccess;
    public String getVariableName() {
        return name.getText();
    }

    public boolean isReplaceAll() {
        boolean ret = replaceAll.isSelected();
        getPreferences(introduceConstant).putBoolean("replaceAll", ret); //NOI18N
        return ret;
    }

    //for tests only:
    void setVariableName(String name) {
        this.name.setText(name);
    }

    void setReplaceAll(boolean replaceAll) {
        this.replaceAll.setSelected(replaceAll);
    }
}
