/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 
package org.netbeans.microedition.testme.svg.tests;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import org.netbeans.microedition.testme.svg.support.SVGTestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;

/**
 * The J2ME test suite for known issue related to SVG "to-animation" (i.e. animation 
 * without defined starting point).
 * @author  PavelBenes
 * @version
 */
public final class AnimateToTests extends SVGTestMIDlet {
    private static final int RED  = 0x00FF0000;

    /** Initial x coordinate of the animated box */
    private static final int START_X  = 30;
    /** Initial y coordinate of the animated box */
    private static final int START_Y  = 30;
    /** Box size in pixes */
    private static final int SIZE     = 10;
    /** The */
    private static final int DIFF     = 30;
    private static final int DELAY    = 2000;
    
    private volatile boolean _isRunning;
    
    public AnimateToTests() throws Exception {
        super("To-Animation unit test(s)", 1, "animateTo.svg", true);
    }
    
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testRectangleMoveTo(); break;
        }
    }    
    
    /**
     * This test verifies a correct behavior of four chained to-animations, that
     * are moving the red box on the screen. Each animation starts at coordinates
     * where the previous one ended, and thus the rectangle should smootly travel
     * along the rectangular route, moving in one direction at a time. After each
     * animation the presence of the box is verified using pixel color comparison.
     */
    protected void testRectangleMoveTo() {   
        _isRunning = true;
        schedulePositionCheck( START_X + DIFF + SIZE/2, START_Y + SIZE/2, DELAY, false);
        schedulePositionCheck( START_X + DIFF + SIZE/2, START_Y + DIFF + SIZE/2, DELAY*2, false);
        schedulePositionCheck( START_X + SIZE/2, START_Y + DIFF + SIZE/2, DELAY*3, false);
        schedulePositionCheck( START_X + SIZE/2, START_Y + SIZE/2, DELAY*4, true);
    }

    
    protected void schedulePositionCheck(final int x, final int y, long delay, final boolean isLastCheck) {
        new Timer().schedule( new TimerTask() {
            public void run() {
                if ( _isRunning) {
                    log("Checking box presence at [" + x + "," + y + "]");
                    Image img = takeScreenshot();
                    if ((SVGUtils.getPixelColor(img, x, y) & SVGUtils.RGB_MASK) != RED) {
                        _isRunning = false;
                        asynchronousTestCompleted( false,
                                "The box is not at [" + x + "," + y + "] position.");
                    } else {
                        if (isLastCheck) {
                            asynchronousTestCompleted( true, "");
                        }
                    }
                }
            }
        }, delay);
    }
}
