/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class EjbJarMoveClassRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N

    public EjbJarMoveClassRefactoring() { }

    public Problem fastCheckParameters(Collection resources, FileObject target) {
        Problem problem = null;
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            FileObject fo = JavaModel.getFileObject(res);
            if (fo != null) {
                Project prj1 = FileOwnerQuery.getOwner(fo);
                Project prj2 = null;
                if (target != null ) {
                    prj2 = FileOwnerQuery.getOwner(target);
                }
                if ((prj2 != null) && (!prj1.equals(prj2))) {
                    if (isEjbMove(res)) {
                        Problem newProblem = new Problem(true, NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarOtherProjectWarningMoveClass"));
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                        break;
                    }
                }
            }
        }
        return problem;
    }

    private boolean isEjbMove(Resource res) {
        JavaClass iface;
        List l = res.getClassifiers();

        if (l == null) {
            return false;
        }
        
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_LOCAL_OBJECT);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }
        
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_LOCAL_HOME);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_HOME);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_OBJECT);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.ENTITY_BEAN);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.SESSION_BEAN);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.MESSAGE_DRIVEN_BEAN);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.MESSAGE_LISTENER);
        for (int i=0; i < l.size(); i++) {
            JavaClass jc = (JavaClass)l.get(i);
            if (jc.isSubTypeOf(iface)) {
                return true;
            }
        }

        return false;
    }
    
    public Problem checkParameters(Collection resources, FileObject target) {
        return fastCheckParameters(resources, target);
    }
    
    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (Iterator i = resources.iterator(); i.hasNext();) {
            Resource resource = (Resource) i.next();
            FileObject fo = JavaModel.getFileObject(resource);

            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            Collection emodules = Utility.getRelevantEjbModules(fo);
            Iterator emIter = null;

            if (emodules != null) {
                emIter = emodules.iterator();
            }
            if (emIter != null) {
                while (emIter.hasNext()) {
                    org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)emIter.next();
                    if (em != null) {              // the class is in an ejb module
                        FileObject ejbJarFO = em.getDeploymentDescriptor();
                        EjbJar ejbJarDD = null;
                        try {
                            ejbJarDD = DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                        } catch (IOException ioe) {
                            //ignore
                        }
                        if ((ejbJarDD != null) && (ejbJarDD.getStatus()!=EjbJar.STATE_INVALID_UNPARSABLE) && ejbJarFO != null) {
                            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();

                            Session[] sessionBeans = eBeans != null ? eBeans.getSession() : null;
                            err.log("Session Beans: " + sessionBeans);

                            Entity [] entityBeans = eBeans != null ? eBeans.getEntity() : null;
                            err.log("Entity Beans: " + entityBeans);

                            MessageDriven [] messageBeans = eBeans != null ? eBeans.getMessageDriven() :null;
                            err.log("MessageDriven Beans: " + messageBeans);

                            List classes = resource.getClassifiers();
                            err.log("Classes in resource: " + classes);

                            for (int j=0; j < classes.size(); j++ ) {
                                JavaClass jClass = (JavaClass)classes.get(j);
                                err.log("javaclass: "+ jClass);

                                String name = jClass.getName();
                                err.log("name: " + name);

                                String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                                err.log("targetPackage: " + targetPackage);

                                String newName = Utility.getClassName(targetPackage, jClass.getSimpleName());
                                err.log("newname: " + newName);

                                /* First check Session beans */
                                if ((sessionBeans != null) && (sessionBeans.length > 0)) {
                                    for (int b=0; b < sessionBeans.length; b++) {
                                        Session sBean = sessionBeans[b];
                                        err.log("Session Bean: " + sBean);
                                        String ejbClass = sBean.getEjbClass();
                                        err.log("EJB Class: " + ejbClass);
                                        if ((ejbClass != null) && (ejbClass.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbLocal = sBean.getLocal();
                                        err.log("EJB Local: " + ejbLocal);
                                        if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarLocalMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbLocalHome = sBean.getLocalHome();
                                        err.log("EJB LocalHome: " + ejbLocalHome);
                                        if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarLocalHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbHome = sBean.getHome();
                                        err.log("EJB Home: " + ejbHome);
                                        if ((ejbHome != null) && (ejbHome.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbRemote = sBean.getRemote();
                                        err.log("EJB Remote: " + ejbRemote);
                                        if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarRemoteMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        
                                        // service endpoint is related to ejb based web services
                                        String serviceEndpoint = null;
                                        try {
                                            serviceEndpoint = sBean.getServiceEndpoint();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Service Endpoint: " + serviceEndpoint);
                                            if ((serviceEndpoint != null) && (serviceEndpoint.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarServiceEndpointMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            }
                                        } catch (VersionNotSupportedException versionex) {
                                            // No problem, just ignore
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Service endpoint not supported in this version of dd.");
                                        }
                                        
                                        //refs
                                        EjbRef[] refs = sBean.getEjbRef();
                                        if ((refs != null) && (refs.length > 0)) {
                                            for (int l=0; l < refs.length; l++) {
                                                EjbRef ref = refs[l];
                                                err.log("EJB ref: " + ref);
                                                String refHome = ref.getHome();
                                                err.log("home ref: " + refHome);
                                                if ((refHome != null) && (refHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, sBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refRemote = ref.getRemote();
                                                err.log("remote ref: " + refRemote);
                                                if ((refRemote != null) && (refRemote.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, sBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                        // local refs
                                        EjbLocalRef[] localRefs = sBean.getEjbLocalRef();
                                        if ((localRefs != null) && (localRefs.length > 0)) {
                                            for (int l=0; l < localRefs.length; l++) {
                                                EjbLocalRef localRef = localRefs[l];
                                                err.log("EJB local ref: " + localRef);
                                                String refLocal = localRef.getLocal();
                                                err.log("local ref: " + refLocal);
                                                if ((refLocal != null) && (refLocal.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, sBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refLocalHome = localRef.getLocalHome();
                                                err.log("localHome ref: " + refLocalHome);
                                                if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, sBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                    }
                                }

                                /* Then entity beans */
                                if ((entityBeans != null) && (entityBeans.length > 0)) {
                                    for (int b=0; b < entityBeans.length; b++) {
                                        Entity entBean = entityBeans[b];
                                        err.log("Entity Bean: " + entBean);
                                        String ejbClass = entBean.getEjbClass();
                                        err.log("EJB Class: " + ejbClass);
                                        if ((ejbClass != null) && (ejbClass.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbLocal = entBean.getLocal();
                                        err.log("EJB Local: " + ejbLocal);
                                        if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarLocalMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbLocalHome = entBean.getLocalHome();
                                        err.log("EJB LocalHome: " + ejbLocalHome);
                                        if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarLocalHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbHome = entBean.getHome();
                                        err.log("EJB Home: " + ejbHome);
                                        if ((ejbHome != null) && (ejbHome.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String ejbRemote = entBean.getRemote();
                                        err.log("EJB Remote: " + ejbRemote);
                                        if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarRemoteMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        //refs
                                        EjbRef[] refs = entBean.getEjbRef();
                                        if ((refs != null) && (refs.length > 0)) {
                                            for (int l=0; l < refs.length; l++) {
                                                EjbRef ref = refs[l];
                                                err.log("EJB ref: " + ref);
                                                String refHome = ref.getHome();
                                                err.log("home ref: " + refHome);
                                                if ((refHome != null) && (refHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, entBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refRemote = ref.getRemote();
                                                err.log("remote ref: " + refRemote);
                                                if ((refRemote != null) && (refRemote.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, entBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                        // local refs
                                        EjbLocalRef[] localRefs = entBean.getEjbLocalRef();
                                        if ((localRefs != null) && (localRefs.length > 0)) {
                                            for (int l=0; l < localRefs.length; l++) {
                                                EjbLocalRef localRef = localRefs[l];
                                                err.log("EJB local ref: " + localRef);
                                                String refLocal = localRef.getLocal();
                                                err.log("local ref: " + refLocal);
                                                if ((refLocal != null) && (refLocal.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, entBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refLocalHome = localRef.getLocalHome();
                                                err.log("localHome ref: " + refLocalHome);
                                                if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, entBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                    }
                                }

                                /* And finally message driven beans */
                                if ((messageBeans != null) && (messageBeans.length > 0)) {
                                    for (int b=0; b < messageBeans.length; b++) {
                                        MessageDriven msgBean = messageBeans[b];
                                        err.log("MessageDriven Bean: " + msgBean);
                                        String ejbClass = msgBean.getEjbClass();
                                        err.log("EJB Class: " + ejbClass);
                                        if ((ejbClass != null) && (ejbClass.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        //refs
                                        EjbRef[] refs = msgBean.getEjbRef();
                                        if ((refs != null) && (refs.length > 0)) {
                                            for (int l=0; l < refs.length; l++) {
                                                EjbRef ref = refs[l];
                                                err.log("EJB ref: " + ref);
                                                String refHome = ref.getHome();
                                                err.log("home ref: " + refHome);
                                                if ((refHome != null) && (refHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, msgBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refRemote = ref.getRemote();
                                                err.log("remote ref: " + refRemote);
                                                if ((refRemote != null) && (refRemote.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, msgBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                        // local refs
                                        EjbLocalRef[] localRefs = msgBean.getEjbLocalRef();
                                        if ((localRefs != null) && (localRefs.length > 0)) {
                                            for (int l=0; l < localRefs.length; l++) {
                                                EjbLocalRef localRef = localRefs[l];
                                                err.log("EJB local ref: " + localRef);
                                                String refLocal = localRef.getLocal();
                                                err.log("local ref: " + refLocal);
                                                if ((refLocal != null) && (refLocal.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, msgBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                                String refLocalHome = localRef.getLocalHome();
                                                err.log("localHome ref: " + refLocalHome);
                                                if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, msgBean, name, newName,
                                                                ejbJarFO
                                                            );
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }
                                    }
                                }
                            } //for 
                        } else if (ejbJarFO != null){
                            Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarMoveClassInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    }
                }
            }
        }
        return problem;
    }

    public final class EjbJarBeanClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarBeanClassMoveClassRefactoringElement */
        public EjbJarBeanClassMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarBeanClassMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            Ejb[] ejbs = eBeans.getEjbs();
            Ejb ejb = null;
            for (int i=0; i < ejbs.length; i++) {
                String ejbClass = ejbs[i].getEjbClass();
                if (oldName.equals(ejbClass)) {
                    ejb = ejbs[i];
                    break;
                }
            }
            if (ejb!=null) {
                ejb.setEjbClass(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            Ejb[] ejbs = eBeans.getEjbs();
            Ejb ejb = null;
            for (int i=0; i < ejbs.length; i++) {
                String ejbClass = ejbs[i].getEjbClass();
                if (newName.equals(ejbClass)) {
                    ejb = ejbs[i];
                    break;
                }
            }
            if (ejb!=null) {
                ejb.setEjbClass(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }

    public final class EjbJarLocalMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarLocalMoveClassRefactoringElement */
        public EjbJarLocalMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarLocalMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbLocal = sEjbs[i].getLocal();
                if (oldName.equals(ejbLocal)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbLocal = eEjbs[i].getLocal();
                    if (oldName.equals(ejbLocal)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setLocal(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbLocal = sEjbs[i].getLocal();
                if (newName.equals(ejbLocal)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbLocal = eEjbs[i].getLocal();
                    if (newName.equals(ejbLocal)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setLocal(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }    
    
    public final class EjbJarLocalHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarLocalHomeMoveClassRefactoringElement */
        public EjbJarLocalHomeMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarLocalHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbLocalHome = sEjbs[i].getLocalHome();
                if (oldName.equals(ejbLocalHome)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbLocalHome = eEjbs[i].getLocalHome();
                    if (oldName.equals(ejbLocalHome)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setLocalHome(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbLocalHome = sEjbs[i].getLocalHome();
                if (newName.equals(ejbLocalHome)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbLocalHome = eEjbs[i].getLocalHome();
                    if (newName.equals(ejbLocalHome)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setLocalHome(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    public final class EjbJarHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarHomeMoveClassRefactoringElement */
        public EjbJarHomeMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbHome = sEjbs[i].getHome();
                if (oldName.equals(ejbHome)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbHome = eEjbs[i].getHome();
                    if (oldName.equals(ejbHome)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setHome(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbHome = sEjbs[i].getHome();
                if (newName.equals(ejbHome)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbHome = eEjbs[i].getHome();
                    if (newName.equals(ejbHome)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setHome(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }    

    public final class EjbJarRemoteMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRemoteMoveClassRefactoringElement */
        public EjbJarRemoteMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarRemoteMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbRemote = sEjbs[i].getRemote();
                if (oldName.equals(ejbRemote)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbRemote = eEjbs[i].getRemote();
                    if (oldName.equals(ejbRemote)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setRemote(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            EntityAndSession ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i=0; i < sEjbs.length; i++) {
                String ejbRemote = sEjbs[i].getRemote();
                if (newName.equals(ejbRemote)) {
                    ejb = sEjbs[i];
                    break;
                }
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i=0; i < eEjbs.length; i++) {
                    String ejbRemote = eEjbs[i].getRemote();
                    if (newName.equals(ejbRemote)) {
                        ejb = eEjbs[i];
                        break;
                    }
                }
            }
            if (ejb!=null) {
                ejb.setRemote(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }

    public final class EjbJarServiceEndpointMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarServiceEndpointMoveClassRefactoringElement */
        public EjbJarServiceEndpointMoveClassRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarServiceEndpointMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            try {
                for (int i=0; i < sEjbs.length; i++) {
                    String serviceEndpoint = sEjbs[i].getServiceEndpoint();
                    if (oldName.equals(serviceEndpoint)) {
                        ejb = sEjbs[i];
                        break;
                    }
                }
                if (ejb!=null) {
                    ejb.setServiceEndpoint(newName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            } catch (VersionNotSupportedException ex) {
                // just ignore, this is checked sooner in prepare
            }
        }
        
        public void undoExternalChange() {
            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            try {
                for (int i=0; i < sEjbs.length; i++) {
                    String serviceEndpoint = sEjbs[i].getServiceEndpoint();
                    if (newName.equals(serviceEndpoint)) {
                        ejb = sEjbs[i];
                        break;
                    }
                }
                if (ejb!=null) {
                    ejb.setServiceEndpoint(oldName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            } catch (VersionNotSupportedException ex) {
                // just ignore, this is checked sooner in prepare
            }
        }
    }

    public final class EjbJarRefLocalMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected Ejb ejb;
        protected EjbJar ejbJarDD;
        
        /** Creates a new instance of EjbJarRefLocalMoveClassRefactoringElement */
        public EjbJarRefLocalMoveClassRefactoringElement(EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) { 
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarRefLocalMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbLocal = refs[i].getLocal();
                if (oldName.equals(ejbLocal)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocal(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EjbLocalRef[] refs = ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbLocal = refs[i].getLocal();
                if (newName.equals(ejbLocal)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocal(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    public final class EjbJarRefLocalHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected Ejb ejb;
        protected EjbJar ejbJarDD;
        
        /** Creates a new instance of EjbJarRefLocalHomeMoveClassRefactoringElement */
        public EjbJarRefLocalHomeMoveClassRefactoringElement(EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) { 
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarRefLocalHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbLocalHome = refs[i].getLocalHome();
                if (oldName.equals(ejbLocalHome)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocalHome(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EjbLocalRef[] refs = ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbLocalHome = refs[i].getLocalHome();
                if (newName.equals(ejbLocalHome)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocalHome(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    public final class EjbJarRefHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected Ejb ejb;
        protected EjbJar ejbJarDD;
        
        /** Creates a new instance of EjbJarRefLocalHomeMoveClassRefactoringElement */
        public EjbJarRefHomeMoveClassRefactoringElement(EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) { 
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarRefHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EjbRef[] refs = ejb.getEjbRef();
            EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbHome = refs[i].getHome();
                if (oldName.equals(ejbHome)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setHome(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EjbRef[] refs = ejb.getEjbRef();
            EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbHome = refs[i].getHome();
                if (newName.equals(ejbHome)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setHome(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    public final class EjbJarRefRemoteMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected Ejb ejb;
        protected EjbJar ejbJarDD;
        
        /** Creates a new instance of EjbJarRefRemoteMoveClassRefactoringElement */
        public EjbJarRefRemoteMoveClassRefactoringElement(EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) { 
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, "TXT_EjbJarRefRemoteMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            EjbRef[] refs = ejb.getEjbRef();
            EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbRemote = refs[i].getRemote();
                if (oldName.equals(ejbRemote)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setRemote(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            EjbRef[] refs = ejb.getEjbRef();
            EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String ejbRemote = refs[i].getRemote();
                if (newName.equals(ejbRemote)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setRemote(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }    
}
