/* *************************************************************************
*
*          Copyright (c) 2005, SeeBeyond Technology Corporation,
*          All Rights Reserved
*
*          This program, and all the routines referenced herein,
*          are the proprietary properties and trade secrets of
*          SEEBEYOND TECHNOLOGY CORPORATION.
*
*          Except as provided for by license agreement, this
*          program shall not be duplicated, used, or disclosed
*          without  written consent signed by an officer of
*          SEEBEYOND TECHNOLOGY CORPORATION.
*
***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WorkflowMapReader {
    private static final String PARTNERLINK_ATTR = "partnerLink";
    private static final String PORTTYPE_ATTR = "portType";
    private static final String ROLE_NAME_ATTR = "roleName";
    
    protected WorkflowMapReader() {
    }

    /**
     * Parses Workflow service unit configuration file.
     * 
     * @param workflowmapfile The service unit configuration file.
     * @return list of transformation mappings.
     * @throws org.xml.sax.SAXException if a parsing error occurs.
     * @throws java.io.IOException if an error occurs reading configuration file.
     * @throws javax.xml.parsers.ParserConfigurationException if a parsing error occurs.
     */
    public static List parse(File workflowmapfile) 
            throws org.xml.sax.SAXException, 
                   java.io.IOException,
                   javax.xml.parsers.ParserConfigurationException {
        // parse entries into list
        List retList = new ArrayList();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(workflowmapfile);
        Element elem = doc.getDocumentElement();
        NodeList portmaps = elem.getChildNodes();
        for (int i = 0; i < portmaps.getLength(); i++) {
            if (!(portmaps.item(i) instanceof Element)) continue;
            
            Element mappingElem = (Element) portmaps.item(i);
            String type = mappingElem.getNodeName();
            Element inputElem = (Element) 
                    mappingElem.getElementsByTagName(
                            WorkflowMapEntry.INPUT_MESSAGE_TYPE).item(0);
            if (inputElem != null) {
                QName partnerLink = getQName(inputElem.getAttribute(PARTNERLINK_ATTR));
                QName portType = getQName(inputElem.getAttribute(PORTTYPE_ATTR));
                String roleName = inputElem.getAttribute(ROLE_NAME_ATTR);
                
                if (WorkflowMapEntry.REQUEST_REPLY_SERVICE.equals(type)) {
                    retList.add(
                            WorkflowMapEntry.newRequestReplyService(partnerLink, 
                                                                portType, 
                                                                roleName));
                }
                else if (WorkflowMapEntry.FILTER_ONE_WAY.equals(type)) {
                    Element outputElem = (Element) 
                            mappingElem.getElementsByTagName(
                                        WorkflowMapEntry.OUTPUT_MESSAGE_TYPE).item(0);
                    if (outputElem != null) {
                        QName outPartnerLink = 
                                getQName(outputElem.getAttribute(PARTNERLINK_ATTR));
                        QName outPortType =
                                getQName(outputElem.getAttribute(PORTTYPE_ATTR));
                        String outRoleName = outputElem.getAttribute(ROLE_NAME_ATTR);
                        retList.add(
                                WorkflowMapEntry.newFilterOneWay(partnerLink,
                                                             portType,
                                                             roleName,
                                                             outPartnerLink,
                                                             outPortType,
                                                             outRoleName));
                    }
                }
                else if (WorkflowMapEntry.FILTER_REQUEST_REPLY.equals(type)) {
                    Element outputElem = (Element) 
                    mappingElem.getElementsByTagName(
                                WorkflowMapEntry.OUTPUT_MESSAGE_TYPE).item(0);
                    if (outputElem != null) {
                        QName outPartnerLink = 
                                getQName(outputElem.getAttribute(PARTNERLINK_ATTR));
                        QName outPortType =
                                getQName(outputElem.getAttribute(PORTTYPE_ATTR));
                        String outRoleName = outputElem.getAttribute(ROLE_NAME_ATTR);
                        retList.add(
                                WorkflowMapEntry.newFilterRequestReply(partnerLink,
                                                                   portType,
                                                                   roleName,
                                                                   outPartnerLink,
                                                                   outPortType,
                                                                   outRoleName));
                    }
                }
            }
            // TODO throw exception if input is missing?
        }        
        return retList;
    }
    
    private static QName getQName(String qname) {
        return QName.valueOf(qname);
    }
}
